/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.common.item.ItemLaputaShard;
import vazkii.botania.common.item.ModItems;

public class LaputaShardUpgradeRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<LaputaShardUpgradeRecipe> SERIALIZER = new SpecialRecipeSerializer(LaputaShardUpgradeRecipe::new);

    public LaputaShardUpgradeRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        boolean foundShard = false;
        boolean foundSpirit = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.laputaShard && !foundShard && ItemLaputaShard.getShardLevel(stack) < 19) {
                foundShard = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.lifeEssence && !foundSpirit) {
                foundSpirit = true;
                continue;
            }
            return false;
        }
        return foundShard && foundSpirit;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != ModItems.laputaShard) continue;
            ItemStack result = stack.func_77946_l();
            result.func_196082_o().func_74768_a("level", ItemLaputaShard.getShardLevel(stack) + 1);
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

