/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeRuneAltar;

public class HeadRecipe
extends RecipeRuneAltar {
    public HeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        super(id, output, mana, inputs);
    }

    @Override
    public boolean func_77569_a(IInventory inv, @Nonnull World world) {
        boolean matches = super.func_77569_a(inv, world);
        if (matches) {
            ItemStack stack;
            for (int i = 0; i < inv.func_70302_i_() && !(stack = inv.func_70301_a(i)).func_190926_b(); ++i) {
                if (stack.func_77973_b() != Items.field_151057_cb) continue;
                String defaultName = new TranslationTextComponent(Items.field_151057_cb.func_77658_a()).getString();
                if (!stack.func_200301_q().getString().equals(defaultName)) continue;
                return false;
            }
        }
        return matches;
    }

    @Override
    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        ItemStack stack = this.func_77571_b().func_77946_l();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingr = inv.func_70301_a(i);
            if (ingr.func_77973_b() != Items.field_151057_cb) continue;
            ItemNBTHelper.setString(stack, "SkullOwner", ingr.func_200301_q().getString());
            break;
        }
        return stack;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<HeadRecipe> {
        @Nonnull
        public HeadRecipe read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new HeadRecipe(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public HeadRecipe read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
            }
            ItemStack output = buf.func_150791_c();
            int mana = buf.func_150792_a();
            return new HeadRecipe(id, output, mana, inputs);
        }

        public void write(@Nonnull PacketBuffer buf, @Nonnull HeadRecipe recipe) {
            ModRecipeTypes.RUNE_SERIALIZER.func_199427_a_(buf, (IRecipe)recipe);
        }
    }
}

