/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipePureDaisy
implements IPureDaisyRecipe {
    public static final int DEFAULT_TIME = 150;
    private final ResourceLocation id;
    private final StateIngredient input;
    private final BlockState outputState;
    private final int time;

    public RecipePureDaisy(ResourceLocation id, StateIngredient input, BlockState state, int time) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.id = id;
        this.input = input;
        this.outputState = state;
        this.time = time;
    }

    @Override
    public boolean matches(World world, BlockPos pos, TileEntitySpecialFlower pureDaisy, BlockState state) {
        return this.input.test(state);
    }

    @Override
    public boolean set(World world, BlockPos pos, TileEntitySpecialFlower pureDaisy) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, this.outputState);
        }
        return true;
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public BlockState getOutputState() {
        return this.outputState;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.PURE_DAISY_SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipePureDaisy> {
        @Nonnull
        public RecipePureDaisy read(@Nonnull ResourceLocation id, JsonObject object) {
            StateIngredient input = StateIngredientHelper.deserialize(JSONUtils.func_152754_s((JsonObject)object, (String)"input"));
            BlockState output = StateIngredientHelper.readBlockState(JSONUtils.func_152754_s((JsonObject)object, (String)"output"));
            int time = JSONUtils.func_151208_a((JsonObject)object, (String)"time", (int)150);
            return new RecipePureDaisy(id, input, output, time);
        }

        public void write(@Nonnull PacketBuffer buf, RecipePureDaisy recipe) {
            recipe.input.write(buf);
            buf.func_150787_b(Block.func_196246_j((BlockState)recipe.outputState));
            buf.func_150787_b(recipe.time);
        }

        @Nullable
        public RecipePureDaisy read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            StateIngredient input = StateIngredientHelper.read(buf);
            BlockState output = Block.func_196257_b((int)buf.func_150792_a());
            int time = buf.func_150792_a();
            return new RecipePureDaisy(id, input, output, time);
        }
    }
}

