/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.string;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.string.TileRedString;

public class TileRedStringContainer
extends TileRedString {
    private static final LazyOptional<IItemHandler> EMPTY = LazyOptional.of(EmptyHandler::new);
    @Nullable
    private LazyOptional<?> lastBoundInv = null;
    @Nullable
    private LazyOptional<?> proxiedInv = null;

    public TileRedStringContainer() {
        this(ModTiles.RED_STRING_CONTAINER);
    }

    public TileRedStringContainer(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        return tile != null && Arrays.stream(Direction.values()).anyMatch(e -> tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e).isPresent());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getTileAtBinding() != null) {
                LazyOptional optional = this.getTileAtBinding().getCapability(cap, side);
                if (!optional.isPresent()) {
                    this.invalidateLastCap();
                    return EMPTY.cast();
                }
                if (this.lastBoundInv == optional) {
                    return this.proxiedInv.cast();
                }
                if (this.proxiedInv != null) {
                    this.proxiedInv.invalidate();
                }
                this.lastBoundInv = optional;
                this.proxiedInv = this.createProxyOptional((LazyOptional<IItemHandler>)optional.cast());
                return this.proxiedInv.cast();
            }
            this.invalidateLastCap();
            return EMPTY.cast();
        }
        return super.getCapability(cap, side);
    }

    private void invalidateLastCap() {
        if (this.proxiedInv != null) {
            this.proxiedInv.invalidate();
            this.proxiedInv = null;
        }
        this.lastBoundInv = null;
    }

    private LazyOptional<IItemHandler> createProxyOptional(LazyOptional<IItemHandler> original) {
        LazyOptional proxy = LazyOptional.of(() -> (IItemHandler)original.orElse((Object)EmptyHandler.INSTANCE));
        original.addListener(orig -> proxy.invalidate());
        return proxy;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateLastCap();
    }

    public void func_70296_d() {
        super.func_70296_d();
        TileEntity tile = this.getTileAtBinding();
        if (tile != null) {
            tile.func_70296_d();
        }
    }
}

