/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ExperienceHelper;

public class SubTileArcaneRose
extends TileEntityGeneratingFlower {
    private static final int MANA_PER_XP = 50;
    private static final int MANA_PER_XP_ORB = 35;
    private static final int MANA_PER_XP_DISENCHANT = 40;
    private static final int RANGE = 1;

    public SubTileArcaneRose() {
        super(ModSubtiles.ROSA_ARCANA);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.field_145850_b.field_72995_K || this.getMana() >= this.getMaxMana()) {
            return;
        }
        AxisAlignedBB effectBounds = new AxisAlignedBB(this.getEffectivePos().func_177982_a(-1, -1, -1), this.getEffectivePos().func_177982_a(2, 2, 2));
        List players = this.func_145831_w().func_217357_a(PlayerEntity.class, effectBounds);
        for (Object player : players) {
            if (ExperienceHelper.getPlayerXP((PlayerEntity)player) < 1 || !player.func_233570_aj_()) continue;
            ExperienceHelper.drainPlayerXP((PlayerEntity)player, 1);
            this.addMana(50);
            this.sync();
            return;
        }
        List orbs = this.func_145831_w().func_217357_a(ExperienceOrbEntity.class, effectBounds);
        for (ExperienceOrbEntity orb : orbs) {
            if (!orb.func_70089_S()) continue;
            this.addMana(orb.func_70526_d() * 35);
            orb.func_70106_y();
            float pitch = (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.35f + 0.9f;
            this.field_145850_b.func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.07f, pitch);
            this.sync();
            return;
        }
        List items = this.func_145831_w().func_175647_a(ItemEntity.class, effectBounds, e -> e.func_70089_S() && !e.func_92059_d().func_190926_b());
        for (ItemEntity entity : items) {
            int xp;
            ItemStack stack = entity.func_92059_d();
            if (stack.func_77973_b() != Items.field_151134_bR && !stack.func_77948_v() || (xp = SubTileArcaneRose.getEnchantmentXpValue(stack)) <= 0) continue;
            ItemStack newStack = SubTileArcaneRose.removeNonCurses(stack);
            newStack.func_190920_e(1);
            stack.func_190918_g(1);
            ItemEntity newEntity = new ItemEntity(this.field_145850_b, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), newStack);
            newEntity.func_213317_d(entity.func_213322_ci());
            this.field_145850_b.func_217376_c((Entity)newEntity);
            this.field_145850_b.func_184133_a(null, this.getEffectivePos(), ModSounds.arcaneRoseDisenchant, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            while (xp > 0) {
                int i = ExperienceOrbEntity.func_70527_a((int)xp);
                xp -= i;
                this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, (double)this.getEffectivePos().func_177958_n() + 0.5, (double)this.getEffectivePos().func_177956_o() + 0.5, (double)this.getEffectivePos().func_177952_p() + 0.5, i));
            }
            return;
        }
    }

    private static int getEnchantmentXpValue(ItemStack stack) {
        int ret = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.func_190936_d()) continue;
            ret += enchantment.func_77321_a(integer.intValue());
        }
        return ret;
    }

    private static ItemStack removeNonCurses(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        itemstack.func_196083_e("Enchantments");
        itemstack.func_196083_e("StoredEnchantments");
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p_217012_0_ -> ((Enchantment)p_217012_0_.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.func_82782_a(map, (ItemStack)itemstack);
        itemstack.func_82841_c(0);
        if (itemstack.func_77973_b() == Items.field_151134_bR && map.size() == 0) {
            itemstack = new ItemStack((IItemProvider)Items.field_151122_aG);
            if (stack.func_82837_s()) {
                itemstack.func_200302_a(stack.func_200301_q());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.func_82841_c(RepairContainer.func_216977_d((int)itemstack.func_82838_A()));
        }
        return itemstack;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getColor() {
        return 0xFF8EF8;
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }
}

