/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.subtile.functional.SubTileBergamute;

public class BergamuteEventHandler {
    private static final Random RAND = new Random();
    private static final float MULTIPLIER = 0.15f;

    private BergamuteEventHandler() {
    }

    public static void onSoundEvent(PlaySoundEvent evt) {
        ISound sound = evt.getResultSound();
        if (sound != null && BergamuteEventHandler.shouldSilence(sound)) {
            if (sound instanceof ITickableSound) {
                evt.setResultSound((ISound)new WrappedTickableSound((ITickableSound)sound, 0.15f));
            } else {
                SubTileBergamute berg = SubTileBergamute.getBergamuteNearby(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
                if (berg != null) {
                    evt.setResultSound((ISound)new WrappedSound(sound, 0.15f));
                    if (RAND.nextBoolean()) {
                        int color = 50943;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
                        berg.func_145831_w().func_195594_a((IParticleData)data, (double)berg.getEffectivePos().func_177958_n() + 0.3 + Math.random() * 0.5, (double)berg.getEffectivePos().func_177956_o() + 0.5 + Math.random() * 0.5, (double)berg.getEffectivePos().func_177952_p() + 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    private static boolean shouldSilence(ISound sound) {
        return sound.func_184365_d() != SoundCategory.VOICE && sound.func_184365_d() != SoundCategory.MUSIC && sound.func_184365_d() != SoundCategory.RECORDS && sound.func_184365_d() != SoundCategory.AMBIENT && sound.getClass().getName().startsWith("net.minecraft.client.audio");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class WrappedTickableSound
    extends WrappedSound
    implements ITickableSound {
        private final ITickableSound compose;

        private WrappedTickableSound(ITickableSound toWrap, float volMult) {
            super((ISound)toWrap, volMult);
            this.compose = toWrap;
        }

        public boolean func_147667_k() {
            return this.compose.func_147667_k();
        }

        public void func_73660_a() {
            this.compose.func_73660_a();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class WrappedSound
    implements ISound {
        private final ISound compose;
        private final float volMult;
        private final boolean recheck;

        private WrappedSound(ISound toWrap, float volMult) {
            this.compose = toWrap;
            this.volMult = volMult;
            this.recheck = toWrap instanceof TickableSound;
        }

        public float func_147653_e() {
            float mult = this.recheck && SubTileBergamute.getBergamuteNearby(this.func_147649_g(), this.func_147654_h(), this.func_147651_i()) == null ? 1.0f : this.volMult;
            return this.compose.func_147653_e() * mult;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.compose.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(@Nonnull SoundHandler handler) {
            return this.compose.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.compose.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.compose.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.compose.func_147657_c();
        }

        public boolean func_217861_m() {
            return this.compose.func_217861_m();
        }

        public int func_147652_d() {
            return this.compose.func_147652_d();
        }

        public float func_147655_f() {
            return this.compose.func_147655_f();
        }

        public double func_147649_g() {
            return this.compose.func_147649_g();
        }

        public double func_147654_h() {
            return this.compose.func_147654_h();
        }

        public double func_147651_i() {
            return this.compose.func_147651_i();
        }

        public boolean func_211503_n() {
            return this.compose.func_211503_n();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.compose.func_147656_j();
        }
    }
}

