/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.item.ModItems;

public class BlockManaFlame
extends BlockMod
implements ITileEntityProvider {
    private static final VoxelShape SHAPE = BlockManaFlame.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockManaFlame(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack;
        if (Botania.gardenOfGlassLoaded && !(stack = player.func_184586_b(hand)).func_190926_b() && ItemTags.field_200037_g.func_230235_a_((Object)stack.func_77973_b()) && !player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.lexicon))) {
            if (!world.field_72995_K) {
                stack.func_190918_g(1);
                player.field_71071_by.func_191975_a(player.field_70170_p, new ItemStack((IItemProvider)ModItems.lexicon));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileManaFlame) {
            float v;
            float b;
            float g;
            int color = ((TileManaFlame)te).getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            double luminance = 0.2126 * (double)r + 0.7152 * (double)(g = (float)(color >> 8 & 0xFF) / 255.0f) + 0.0722 * (double)(b = (float)(color & 0xFF) / 255.0f);
            if (luminance < (double)(v = 0.1f)) {
                r += (float)Math.random() * 0.125f;
                g += (float)Math.random() * 0.125f;
                b += (float)Math.random() * 0.125f;
            }
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)pos.func_177958_n() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)pos.func_177956_o() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)pos.func_177952_p() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.03f + (float)Math.random() * 0.015f;
            WispParticleData data = WispParticleData.wisp(s, r, g, b, 1.0f);
            world.func_195594_a((IParticleData)data, x, y, z, 0.0, (double)m, 0.0);
        }
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileManaFlame();
    }
}

