/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.tile.RenderTileFloatingFlower;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public class RenderTileSpecialFlower
extends TileEntityRenderer<TileEntity> {
    public RenderTileSpecialFlower(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void func_225616_a_(TileEntity tile, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        RenderTileFloatingFlower.renderFloatingIsland(tile, partialTicks, ms, buffers, light, overlay);
        if (!(tile instanceof TileEntitySpecialFlower) || !(Minecraft.func_71410_x().field_175622_Z instanceof LivingEntity)) {
            return;
        }
        LivingEntity view = (LivingEntity)Minecraft.func_71410_x().field_175622_Z;
        if (!ItemMonocle.hasMonocle(view)) {
            return;
        }
        BlockPos pos = null;
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            pos = ((BlockRayTraceResult)ray).func_216350_a();
        }
        if ((hasBindingAttempt = RenderTileSpecialFlower.hasBindingAttempt(view, tile.func_174877_v())) || tile.func_174877_v().equals((Object)pos)) {
            TileEntitySpecialFlower flower = (TileEntitySpecialFlower)tile;
            ms.func_227860_a_();
            if (hasBindingAttempt) {
                ms.func_227861_a_(0.0, 0.005, 0.0);
            }
            RenderTileSpecialFlower.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.func_227861_a_(0.0, 0.002, 0.0);
            RenderTileSpecialFlower.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.func_227865_b_();
        }
    }

    public static void renderRadius(TileEntity tile, MatrixStack ms, IRenderTypeBuffer buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)(-tile.func_174877_v().func_177958_n()), (double)(-tile.func_174877_v().func_177956_o()), (double)(-tile.func_174877_v().func_177952_p()));
            if (descriptor.isCircle()) {
                RenderTileSpecialFlower.renderCircle(ms, buffers, descriptor.getSubtileCoords(), descriptor.getCircleRadius());
            } else {
                RenderTileSpecialFlower.renderRectangle(ms, buffers, descriptor.getAABB(), true, null, (byte)32);
            }
            ms.func_227865_b_();
        }
    }

    public static boolean hasBindingAttempt(LivingEntity view, BlockPos tilePos) {
        ItemStack stackHeld = PlayerHelper.getFirstHeldItem(view, ModItems.twigWand);
        if (!stackHeld.func_190926_b() && ItemTwigWand.getBindMode(stackHeld)) {
            Optional<BlockPos> coords = ItemTwigWand.getBindingAttempt(stackHeld);
            return coords.isPresent() && coords.get().equals((Object)tilePos);
        }
        return false;
    }

    private static void renderCircle(MatrixStack ms, IRenderTypeBuffer buffers, BlockPos center, double radius) {
        ms.func_227860_a_();
        double x = (double)center.func_177958_n() + 0.5;
        double y = center.func_177956_o();
        double z = (double)center.func_177952_p() + 0.5;
        ms.func_227861_a_(x, y, z);
        int color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int alpha = 32;
        float f = 0.0625f;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= (double)f;
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.CIRCLE);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        Runnable centerFunc = () -> buffer.func_227888_a_(mat, 0.0f, f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
        ArrayList<Runnable> vertexFuncs = new ArrayList<Runnable>();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.func_227888_a_(mat, xp, f, zp).func_225586_a_(r, g, b, alpha).func_181675_d());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        radius += (double)f;
        float f1 = f + f / 4.0f;
        int alpha2 = 64;
        centerFunc = () -> buffer.func_227888_a_(mat, 0.0f, f1, 0.0f).func_225586_a_(r, g, b, alpha2).func_181675_d();
        vertexFuncs.clear();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.func_227888_a_(mat, xp, f1, zp).func_225586_a_(r, g, b, alpha2).func_181675_d());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        ms.func_227865_b_();
    }

    public static void renderRectangle(MatrixStack ms, IRenderTypeBuffer buffers, AxisAlignedBB aabb, boolean inner, @Nullable Integer color, byte alpha) {
        ms.func_227860_a_();
        ms.func_227861_a_(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        if (color == null) {
            color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float f = 0.0625f;
        float x = (float)(aabb.field_72336_d - aabb.field_72340_a - (double)f);
        float z = (float)(aabb.field_72334_f - aabb.field_72339_c - (double)f);
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, x, f, f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, f, f, f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, f, f, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, x, f, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        if (inner) {
            float f1 = f + f / 4.0f;
            alpha = (byte)(alpha * 2);
            buffer.func_227888_a_(mat, x += f, f1, 0.0f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, f1, 0.0f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, f1, z += f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, x, f1, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        }
        ms.func_227865_b_();
    }
}

