/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.mixin.AccessorItemEntity;

public class RenderTileEnchanter
extends TileEntityRenderer<TileEnchanter> {
    private ItemEntity item;

    public RenderTileEnchanter(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileEnchanter enchanter, float f, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        float alphaMod = 0.0f;
        if (enchanter.stage == TileEnchanter.State.GATHER_MANA) {
            alphaMod = (float)Math.min(20, enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.RESET) {
            alphaMod = (float)(20 - enchanter.stageTicks) / 20.0f;
        } else if (enchanter.stage == TileEnchanter.State.DO_ENCHANT) {
            alphaMod = 1.0f;
        }
        ms.func_227860_a_();
        if (!enchanter.itemToEnchant.func_190926_b()) {
            if (this.item == null) {
                this.item = new ItemEntity(enchanter.func_145831_w(), (double)enchanter.func_174877_v().func_177958_n(), (double)(enchanter.func_174877_v().func_177956_o() + 1), (double)enchanter.func_174877_v().func_177952_p(), enchanter.itemToEnchant);
            }
            ((AccessorItemEntity)this.item).setAge(ClientTickHandler.ticksInGame);
            this.item.func_92058_a(enchanter.itemToEnchant);
            ms.func_227861_a_(0.5, 1.25, 0.5);
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)this.item, 0.0, 0.0, 0.0, 0.0f, f, ms, buffers, light);
            ms.func_227861_a_(-0.5, -1.25, -0.5);
        }
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        ms.func_227861_a_(-2.0, -2.0, (double)-0.001f);
        float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 5.0 + 0.4) * alphaMod;
        if (alpha > 0.0f) {
            if (enchanter.stage == TileEnchanter.State.DO_ENCHANT || enchanter.stage == TileEnchanter.State.RESET) {
                int ticks = enchanter.stageTicks + enchanter.stage3EndTicks;
                int angle = ticks * 2;
                float yTranslation = (float)Math.min(20, ticks) / 20.0f * 1.15f;
                float scale = ticks < 10 ? 1.0f : 1.0f - (float)Math.min(20, ticks - 10) / 20.0f * 0.75f;
                ms.func_227861_a_(2.5, 2.5, (double)(-yTranslation));
                ms.func_227862_a_(scale, scale, 1.0f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)angle));
                ms.func_227861_a_(-2.5, -2.5, 0.0);
            }
            IVertexBuilder buffer = buffers.getBuffer(RenderHelper.ENCHANTER);
            IconHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousIcons.INSTANCE.enchanterOverlay, 5, 5, alpha);
        }
        ms.func_227865_b_();
    }
}

