/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.model.ModelBellows;
import vazkii.botania.common.block.tile.mana.TileBellows;

public class RenderTileBellows
extends TileEntityRenderer<TileBellows> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/bellows.png");
    private static final ModelBellows model = new ModelBellows();

    public RenderTileBellows(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nullable TileBellows bellows, float f, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 1.5, 0.5);
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        float angle = 0.0f;
        if (bellows != null) {
            switch ((Direction)bellows.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                case SOUTH: {
                    break;
                }
                case NORTH: {
                    angle = 180.0f;
                    break;
                }
                case EAST: {
                    angle = 270.0f;
                    break;
                }
                case WEST: {
                    angle = 90.0f;
                }
            }
        }
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        float fract = Math.max(0.1f, 1.0f - (bellows == null ? 0.0f : bellows.movePos + bellows.moving * f + 0.1f));
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
        model.render(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, fract);
        ms.func_227865_b_();
    }
}

