/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.EntitySparkBase;

public abstract class RenderSparkBase<T extends EntitySparkBase>
extends EntityRenderer<T> {
    public RenderSparkBase(EntityRendererManager manager) {
        super(manager);
    }

    public void render(@Nonnull T tEntity, float yaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        TextureAtlasSprite iicon = this.getBaseIcon(tEntity);
        ms.func_227860_a_();
        double time = (float)(((EntitySparkBase)((Object)tEntity)).field_70170_p.func_82737_E() % 24000L) + partialTicks + (float)new Random(tEntity.func_145782_y()).nextInt(200);
        float a = 0.1f + (float)(!tEntity.func_82150_aj() ? 1 : 0) * 0.8f;
        int alpha = (int)((0.7 + 0.3 * (Math.sin(time / 5.0) + 0.5) * 2.0) * (double)a * 255.0);
        int iconColor = 0xFFFFFF | alpha << 24;
        float scale = 0.75f + 0.1f * (float)Math.sin(time / 10.0);
        ms.func_227862_a_(scale, scale, scale);
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.SPARK);
        ms.func_227860_a_();
        ms.func_227863_a_(this.field_76990_c.func_229098_b_());
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        this.renderIcon(ms, buffer, iicon, iconColor);
        ms.func_227860_a_();
        ms.func_227861_a_(-0.02 + Math.sin(time / 20.0) * 0.2, 0.24 + Math.cos(time / 20.0) * 0.2, 0.005);
        ms.func_227862_a_(0.2f, 0.2f, 0.2f);
        int starColor = ((EntitySparkBase)((Object)tEntity)).getNetwork().getColorValue() | (int)(a * 255.0f) << 24;
        this.renderIcon(ms, buffer, MiscellaneousIcons.INSTANCE.corporeaIconStar, starColor);
        ms.func_227865_b_();
        TextureAtlasSprite spinningIcon = this.getSpinningIcon(tEntity);
        if (spinningIcon != null) {
            ms.func_227861_a_(-0.02 + Math.sin(time / 20.0) * -0.2, 0.24 + Math.cos(time / 20.0) * -0.2, 0.005);
            ms.func_227862_a_(0.2f, 0.2f, 0.2f);
            this.renderIcon(ms, buffer, spinningIcon, iconColor);
        }
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    protected TextureAtlasSprite getBaseIcon(T entity) {
        return MiscellaneousIcons.INSTANCE.sparkWorldIcon;
    }

    @Nullable
    protected TextureAtlasSprite getSpinningIcon(T entity) {
        return null;
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull EntitySparkBase entity) {
        return AtlasTexture.field_110575_b;
    }

    private void renderIcon(MatrixStack ms, IVertexBuilder buffer, TextureAtlasSprite icon, int color) {
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        int fullbright = 0xF000F0;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, 0.0f - f5, 0.0f - f6, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(f, f3).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, f4 - f5, 0.0f - f6, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(f1, f3).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, f4 - f5, f4 - f6, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(f1, f2).func_227886_a_(fullbright).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f - f5, f4 - f6, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(f, f2).func_227886_a_(fullbright).func_181675_d();
    }
}

