/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ElvenTradeProcessor
implements IComponentProcessor {
    private List<IElvenTradeRecipe> recipes;
    private int longestIngredientSize;
    private int mostInputs;
    private int mostOutputs;

    public void setup(IVariableProvider variables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IVariable s : variables.get("recipes").asListOrSingleton()) {
            IRecipe recipe = ModRecipeTypes.getRecipes((World)Minecraft.func_71410_x().field_71441_e, ModRecipeTypes.ELVEN_TRADE_TYPE).get(new ResourceLocation(s.asString()));
            if (recipe instanceof IElvenTradeRecipe) {
                builder.add((Object)((IElvenTradeRecipe)recipe));
                continue;
            }
            Botania.LOGGER.warn("Missing elven trade recipe " + s);
        }
        this.recipes = builder.build();
        for (IElvenTradeRecipe recipe : this.recipes) {
            NonNullList<Ingredient> inputs = recipe.func_192400_c();
            for (Ingredient ingredient : inputs) {
                int length = ingredient.func_193365_a().length;
                if (length <= this.longestIngredientSize) continue;
                this.longestIngredientSize = length;
            }
            if (inputs.size() > this.mostInputs) {
                this.mostInputs = inputs.size();
            }
            if (recipe.getOutputs().size() <= this.mostOutputs) continue;
            this.mostOutputs = recipe.getOutputs().size();
        }
    }

    public IVariable process(String key) {
        int index;
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            return IVariable.from((Object)this.recipes.get(0).getOutputs().get(0).func_200301_q());
        }
        if (key.startsWith("input")) {
            int index2 = Integer.parseInt(key.substring(5)) - 1;
            if (index2 < this.mostInputs) {
                return this.interweaveIngredients(index2);
            }
            return null;
        }
        if (key.startsWith("output") && (index = Integer.parseInt(key.substring(6)) - 1) < this.mostOutputs) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(IElvenTradeRecipe::getOutputs).map(l -> index < l.size() ? (ItemStack)l.get(index) : ItemStack.field_190927_a).map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }

    private IVariable interweaveIngredients(int inputIndex) {
        List<Ingredient> recipes = this.recipes.stream().map(IElvenTradeRecipe::func_192400_c).map(ingredients -> {
            if (inputIndex < ingredients.size()) {
                return (Ingredient)ingredients.get(inputIndex);
            }
            return Ingredient.field_193370_a;
        }).collect(Collectors.toList());
        return PatchouliUtils.interweaveIngredients(recipes, this.longestIngredientSize);
    }
}

