/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.petalapothecary;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PetalApothecaryRecipeCategory
implements IRecipeCategory<IPetalRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("petals");
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;

    public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 97);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.petalApothecary", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 17, 11, 114, 82);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.defaultAltar));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IPetalRecipe> getRecipeClass() {
        return IPetalRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IPetalRecipe recipe, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.func_192400_c()) {
            list.add(Arrays.asList(ingr.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, list);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(IPetalRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IPetalRecipe recipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 47, 44);
        recipeLayout.getItemStacks().set(0, new ItemStack((IItemProvider)ModBlocks.defaultAltar));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Vector2f point = new Vector2f(47.0f, 12.0f);
        Vector2f center = new Vector2f(47.0f, 44.0f);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, (int)point.field_189982_i, (int)point.field_189983_j);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        recipeLayout.getItemStacks().init(index, false, 86, 11);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public static Vector2f rotatePointAbout(Vector2f in, Vector2f about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.field_189982_i - about.field_189982_i) - Math.sin(rad) * (double)(in.field_189983_j - about.field_189983_j) + (double)about.field_189982_i;
        double newY = Math.sin(rad) * (double)(in.field_189982_i - about.field_189982_i) + Math.cos(rad) * (double)(in.field_189983_j - about.field_189983_j) + (double)about.field_189983_j;
        return new Vector2f((float)newX, (float)newY);
    }
}

