/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.mixin.AccessorRenderState;

public final class RenderHelper {
    private static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = AccessorRenderState.getTranslucentTransparency();
    private static final RenderType STAR;
    public static final RenderType RECTANGLE;
    public static final RenderType CIRCLE;
    public static final RenderType LINE_1;
    public static final RenderType LINE_1_NO_DEPTH;
    public static final RenderType LINE_4_NO_DEPTH;
    public static final RenderType LINE_5_NO_DEPTH;
    public static final RenderType LINE_8_NO_DEPTH;
    public static final RenderType SPARK;
    public static final RenderType LIGHT_RELAY;
    public static final RenderType SPINNING_CUBE;
    public static final RenderType SPINNING_CUBE_GHOST;
    public static final RenderType ICON_OVERLAY;
    public static final RenderType BABYLON_ICON;
    public static final RenderType MANA_POOL_WATER;
    public static final RenderType TERRA_PLATE;
    public static final RenderType ENCHANTER;
    public static final RenderType HALO;
    public static final RenderType MANA_PYLON_GLOW;
    public static final RenderType NATURA_PYLON_GLOW;
    public static final RenderType GAIA_PYLON_GLOW;
    public static final RenderType MANA_PYLON_GLOW_DIRECT;
    public static final RenderType NATURA_PYLON_GLOW_DIRECT;
    public static final RenderType GAIA_PYLON_GLOW_DIRECT;
    public static final RenderType ASTROLABE_PREVIEW;
    public static final RenderType ENTITY_TRANSLUCENT_GOLD;

    private static RenderType getPylonGlowDirect(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, true);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture) {
        return RenderHelper.getPylonGlow(name, texture, false);
    }

    private static RenderType getPylonGlow(String name, ResourceLocation texture, boolean direct) {
        RenderType.State.Builder glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(new RenderState.AlphaState(0.0f)).func_228714_a_(new RenderState.CullState(false)).func_228719_a_(new RenderState.LightmapState(true));
        if (!direct) {
            glState = glState.func_228721_a_(AccessorRenderState.getItemEntityTarget());
        }
        RenderType.Type layer = RenderType.func_228632_a_((String)("botania:" + name), (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)128, (RenderType.State)glState.func_228728_a_(false));
        return ShaderHelper.useShaders() ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.PYLON_GLOW, null, (RenderType)layer) : layer;
    }

    public static RenderType getHaloLayer(ResourceLocation texture) {
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228714_a_(new RenderState.CullState(false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"botania:crafting_halo", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)64, (boolean)false, (boolean)true, (RenderType.State)glState);
    }

    public static void drawTexturedModalRect(MatrixStack ms, int x, int y, int u, int v, int width, int height) {
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void renderStar(MatrixStack ms, IRenderTypeBuffer buffers, int color, float xScale, float yScale, float zScale, long seed) {
        float f1;
        IVertexBuilder buffer = buffers.getBuffer(STAR);
        float ticks = (float)(ClientTickHandler.ticksInGame % 200) + ClientTickHandler.partialTicks;
        if (ticks >= 100.0f) {
            ticks = 200.0f - ticks - 1.0f;
        }
        float f2 = (f1 = ticks / 200.0f) > 0.0f ? (f1 - 0.7f) / 0.2f : 0.0f;
        Random random = new Random(seed);
        ms.func_227860_a_();
        ms.func_227862_a_(xScale, yScale, zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + f1 * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            Runnable center = () -> buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f - f2).func_181675_d();
            Runnable[] vertices = new Runnable[]{() -> buffer.func_227888_a_(mat, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, 0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, 0.0f, f3, 1.0f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d()};
            RenderHelper.triangleFan(center, vertices);
            ++i;
        }
        ms.func_227865_b_();
    }

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderHelper.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void renderProgressPie(MatrixStack ms, int x, int y, float progress, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175599_af().func_180450_b(stack, x, y);
        RenderSystem.clear((int)256, (boolean)true);
        GL11.glEnable((int)2960);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        mc.func_175599_af().func_180450_b(stack, x, y);
        mc.field_71446_o.func_110577_a(new ResourceLocation("botania:textures/gui/mana_hud.png"));
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        int degs = (int)(360.0f * progress);
        float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10.0) * 0.5f + 0.5f);
        RenderSystem.disableLighting();
        RenderSystem.disableTexture();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buf.func_227888_a_(mat, (float)centerX, (float)centerY, 0.0f).func_227885_a_(0.0f, 0.5f, 0.5f, a).func_181675_d();
        for (int i = degs; i > 0; --i) {
            float rad = (float)(i - 90) / 180.0f * (float)Math.PI;
            buf.func_227888_a_(mat, (float)centerX + MathHelper.func_76134_b((float)rad) * (float)r, (float)centerY + MathHelper.func_76126_a((float)rad) * (float)r, 0.0f).func_227885_a_(0.0f, 1.0f, 0.5f, a).func_181675_d();
        }
        buf.func_227888_a_(mat, (float)centerX, (float)centerY, 0.0f).func_227885_a_(0.0f, 1.0f, 0.5f, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        GL11.glDisable((int)2960);
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay, @Nullable IBakedModel model) {
        ms.func_227860_a_();
        if (model == null) {
            model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, entity.field_70170_p, entity);
        }
        model = ForgeHooksClient.handleCameraTransforms((MatrixStack)ms, (IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        ms.func_227861_a_(-0.5, -0.5, -0.5);
        if (!model.func_188618_c() && stack.func_77973_b() != Items.field_203184_eO) {
            RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true);
            IVertexBuilder ivertexbuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffers, (RenderType)rendertype, (boolean)true, (boolean)stack.func_77962_s());
            RenderHelper.renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
        } else {
            stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, ItemCameraTransforms.TransformType.NONE, ms, buffers, light, overlay);
        }
        ms.func_227865_b_();
    }

    public static void renderItemCustomColor(LivingEntity entity, ItemStack stack, int color, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        RenderHelper.renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
    }

    private static void renderBakedItemModel(IBakedModel model, ItemStack stack, int color, int light, int overlay, MatrixStack ms, IVertexBuilder buffer) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderHelper.renderBakedItemQuads(ms, buffer, color, model.func_200117_a((BlockState)null, direction, random), stack, light, overlay);
        }
        random.setSeed(42L);
        RenderHelper.renderBakedItemQuads(ms, buffer, color, model.func_200117_a((BlockState)null, (Direction)null, random), stack, light, overlay);
    }

    private static void renderBakedItemQuads(MatrixStack ms, IVertexBuilder buffer, int color, List<BakedQuad> quads, ItemStack stack, int light, int overlay) {
        MatrixStack.Entry matrixstack$entry = ms.func_227866_c_();
        for (BakedQuad bakedquad : quads) {
            int i = color;
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            buffer.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, alpha, light, overlay, true);
        }
    }

    public static void renderItemModelGold(@Nullable LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transform, MatrixStack ms, IRenderTypeBuffer buffers, @Nullable World world, int light, int overlay) {
        ItemRenderer ir = Minecraft.func_71410_x().func_175599_af();
        if (!stack.func_190926_b()) {
            boolean flag1;
            IBakedModel ibakedmodel = ir.func_184393_a(stack, world, entity);
            ms.func_227860_a_();
            boolean flag = transform == ItemCameraTransforms.TransformType.GUI;
            boolean bl = flag1 = flag || transform == ItemCameraTransforms.TransformType.GROUND || transform == ItemCameraTransforms.TransformType.FIXED;
            if (stack.func_77973_b() == Items.field_203184_eO && flag1) {
                ibakedmodel = ir.func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            ibakedmodel = ForgeHooksClient.handleCameraTransforms((MatrixStack)ms, (IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)transform, (boolean)false);
            ms.func_227861_a_(-0.5, -0.5, -0.5);
            if (!ibakedmodel.func_188618_c() && (stack.func_77973_b() != Items.field_203184_eO || flag1)) {
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffers, (RenderType)ENTITY_TRANSLUCENT_GOLD, (boolean)true, (boolean)stack.func_77962_s());
                ir.func_229114_a_(ibakedmodel, stack, light, overlay, ms, ivertexbuilder);
            }
            ms.func_227865_b_();
        }
    }

    static {
        MANA_PYLON_GLOW = RenderHelper.getPylonGlow("mana_pylon_glow", RenderTilePylon.MANA_TEXTURE);
        NATURA_PYLON_GLOW = RenderHelper.getPylonGlow("natura_pylon_glow", RenderTilePylon.NATURA_TEXTURE);
        GAIA_PYLON_GLOW = RenderHelper.getPylonGlow("gaia_pylon_glow", RenderTilePylon.GAIA_TEXTURE);
        MANA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("mana_pylon_glow_direct", RenderTilePylon.MANA_TEXTURE);
        NATURA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("natura_pylon_glow_direct", RenderTilePylon.NATURA_TEXTURE);
        GAIA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("gaia_pylon_glow_direct", RenderTilePylon.GAIA_TEXTURE);
        RenderState.TransparencyState lightningTransparency = AccessorRenderState.getLightningTransparency();
        RenderState.TextureState mipmapBlockAtlasTexture = new RenderState.TextureState(AtlasTexture.field_110575_b, false, true);
        RenderState.CullState disableCull = new RenderState.CullState(false);
        RenderState.LayerState viewOffsetZLayering = AccessorRenderState.getViewOffsetZLayer();
        RenderState.WriteMaskState colorMask = new RenderState.WriteMaskState(true, false);
        RenderState.ShadeModelState smoothShade = new RenderState.ShadeModelState(true);
        RenderState.LightmapState enableLightmap = new RenderState.LightmapState(true);
        RenderState.OverlayState enableOverlay = new RenderState.OverlayState(true);
        RenderState.DiffuseLightingState enableDiffuse = new RenderState.DiffuseLightingState(true);
        RenderState.AlphaState oneTenthAlpha = new RenderState.AlphaState(0.004f);
        RenderState.DepthTestState noDepth = new RenderState.DepthTestState("always", 519);
        RenderState.TargetState itemTarget = AccessorRenderState.getItemEntityTarget();
        boolean useShaders = ShaderHelper.useShaders();
        RenderType.State glState = RenderType.State.func_228694_a_().func_228723_a_(smoothShade).func_228727_a_(colorMask).func_228726_a_(lightningTransparency).func_228728_a_(false);
        STAR = RenderType.func_228633_a_((String)"botania:star", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228721_a_(itemTarget).func_228714_a_(disableCull).func_228728_a_(false);
        RECTANGLE = RenderType.func_228633_a_((String)"botania:rectangle_highlight", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)glState);
        CIRCLE = RenderType.func_228633_a_((String)"botania:circle_highlight", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(1.0))).func_228718_a_(viewOffsetZLayering).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(colorMask).func_228728_a_(false);
        LINE_1 = RenderType.func_228632_a_((String)"botania:line_1", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(1.0))).func_228718_a_(viewOffsetZLayering).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(colorMask).func_228715_a_(noDepth).func_228728_a_(false);
        LINE_1_NO_DEPTH = RenderType.func_228632_a_((String)"botania:line_1_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(4.0))).func_228718_a_(viewOffsetZLayering).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(colorMask).func_228715_a_(noDepth).func_228728_a_(false);
        LINE_4_NO_DEPTH = RenderType.func_228632_a_((String)"botania:line_4_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(5.0))).func_228718_a_(viewOffsetZLayering).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(colorMask).func_228715_a_(noDepth).func_228728_a_(false);
        LINE_5_NO_DEPTH = RenderType.func_228632_a_((String)"botania:line_5_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(8.0))).func_228718_a_(viewOffsetZLayering).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(colorMask).func_228715_a_(noDepth).func_228728_a_(false);
        LINE_8_NO_DEPTH = RenderType.func_228632_a_((String)"botania:line_8_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228724_a_(mipmapBlockAtlasTexture).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228721_a_(itemTarget).func_228713_a_(new RenderState.AlphaState(0.05f)).func_228719_a_(enableLightmap).func_228728_a_(true);
        SPARK = RenderType.func_228632_a_((String)"botania:spark", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)glState);
        RenderType.Type lightRelay = RenderType.func_228632_a_((String)"botania:light_relay", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)64, (RenderType.State)glState);
        LIGHT_RELAY = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, (RenderType)lightRelay) : lightRelay;
        glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228716_a_(enableDiffuse).func_228728_a_(false);
        SPINNING_CUBE = RenderType.func_228632_a_((String)"botania:spinning_cube", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228716_a_(enableDiffuse).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228721_a_(itemTarget).func_228728_a_(false);
        SPINNING_CUBE_GHOST = RenderType.func_228632_a_((String)"botania:spinning_cube_ghost", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228724_a_(mipmapBlockAtlasTexture).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228721_a_(itemTarget).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(oneTenthAlpha).func_228719_a_(enableLightmap).func_228728_a_(true);
        ICON_OVERLAY = RenderType.func_228632_a_((String)"botania:icon_overlay", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)128, (RenderType.State)glState);
        RenderState.TextureState babylonTexture = new RenderState.TextureState(new ResourceLocation("botania:textures/misc/babylon.png"), false, true);
        glState = RenderType.State.func_228694_a_().func_228724_a_(babylonTexture).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228721_a_(itemTarget).func_228714_a_(disableCull).func_228723_a_(smoothShade).func_228728_a_(true);
        RenderType.Type babylonIcon = RenderType.func_228632_a_((String)"botania:babylon", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)64, (RenderType.State)glState);
        BABYLON_ICON = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, (RenderType)babylonIcon) : babylonIcon;
        MANA_POOL_WATER = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.MANA_POOL, null, ICON_OVERLAY) : ICON_OVERLAY;
        TERRA_PLATE = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.TERRA_PLATE, null, ICON_OVERLAY) : ICON_OVERLAY;
        ENCHANTER = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.ENCHANTER_RUNE, null, ICON_OVERLAY) : ICON_OVERLAY;
        RenderState.TextureState haloTexture = new RenderState.TextureState(ItemFlightTiara.textureHalo, false, true);
        glState = RenderType.State.func_228694_a_().func_228724_a_(haloTexture).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(oneTenthAlpha).func_228714_a_(disableCull).func_228728_a_(true);
        RenderType.Type halo = RenderType.func_228632_a_((String)"botania:halo", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)64, (RenderType.State)glState);
        HALO = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.HALO, null, (RenderType)halo) : halo;
        glState = RenderType.State.func_228694_a_().func_228715_a_(new RenderState.DepthTestState("always", 519)).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(enableDiffuse).func_228713_a_(oneTenthAlpha).func_228714_a_(disableCull).func_228719_a_(enableLightmap).func_228722_a_(enableOverlay).func_228728_a_(true);
        ShaderCallback cb = shader -> {
            int alpha = GlStateManager.func_227680_b_((int)shader, (CharSequence)"alpha");
            ShaderHelper.FLOAT_BUF.position(0);
            ShaderHelper.FLOAT_BUF.put(0, 0.4f);
            RenderSystem.glUniform1((int)alpha, (FloatBuffer)ShaderHelper.FLOAT_BUF);
        };
        RenderType.Type astrolabePreview = RenderType.func_228633_a_((String)"botania:astrolabe_preview", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)glState);
        ASTROLABE_PREVIEW = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.ALPHA, cb, (RenderType)astrolabePreview) : astrolabePreview;
        glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(enableDiffuse).func_228713_a_(oneTenthAlpha).func_228714_a_(disableCull).func_228719_a_(enableLightmap).func_228722_a_(enableOverlay).func_228728_a_(true);
        RenderType.Type gold = RenderType.func_228633_a_((String)"botania:entity_translucent_gold", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)128, (boolean)true, (boolean)true, (RenderType.State)glState);
        ENTITY_TRANSLUCENT_GOLD = useShaders ? new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.GOLD, null, (RenderType)gold) : gold;
    }
}

