/*
 * Decompiled with CFR 0.152.
 */
package net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.oriondevcorgitaco.unearthed.config.UnearthedConfig;
import net.oriondevcorgitaco.unearthed.util.RegistrationHelper;

public class TrueMesaGenerator
extends Feature<NoFeatureConfig> {
    public static final Feature<NoFeatureConfig> MESA = RegistrationHelper.registerFeature("true_mesa_generator", new TrueMesaGenerator((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    BlockState mesaBlockState = Blocks.field_150405_ch.func_176223_P();

    public TrueMesaGenerator(Codec<NoFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                int topY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p());
                for (int y = 0; y < topY; ++y) {
                    this.setStrataLayerBlock(y);
                    if (TrueMesaGenerator.useStoneTag(world, (BlockPos)mutable)) {
                        world.func_180501_a((BlockPos)mutable, this.mesaBlockState, 2);
                    }
                    mutable.func_189536_c(Direction.UP);
                }
            }
        }
        return true;
    }

    public static boolean useStoneTag(ISeedReader world, BlockPos mutable) {
        boolean stoneTag = (Boolean)UnearthedConfig.stoneTag.get();
        if (stoneTag) {
            return world.func_180495_p(mutable).func_235714_a_((ITag)BlockTags.field_242172_aH);
        }
        return world.func_180495_p(mutable) == Blocks.field_150348_b.func_176223_P();
    }

    public void setStrataLayerBlock(int yPos) {
        if (yPos % 4 == 0) {
            this.mesaBlockState = Blocks.field_150405_ch.func_176223_P();
        } else if (yPos % 5 == 0) {
            this.mesaBlockState = Blocks.field_196778_fp.func_176223_P();
        } else if (yPos % 3 == 0) {
            this.mesaBlockState = Blocks.field_196777_fo.func_176223_P();
        }
    }
}

