/*
 * Decompiled with CFR 0.152.
 */
package net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.oriondevcorgitaco.unearthed.Unearthed;
import net.oriondevcorgitaco.unearthed.block.ConfigBlockReader;
import net.oriondevcorgitaco.unearthed.config.UnearthedConfig;
import net.oriondevcorgitaco.unearthed.util.RegistrationHelper;
import net.oriondevcorgitaco.unearthed.util.noise.FNVector3f;
import net.oriondevcorgitaco.unearthed.util.noise.FastNoise;

public class NaturalGenerator
extends Feature<NoFeatureConfig> {
    public static final Feature<NoFeatureConfig> UNDERGROUND_STONE = RegistrationHelper.registerFeature("natural_generator", new NaturalGenerator((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    FastNoise selectorNoise = null;
    FastNoise cellNoise1 = null;
    FastNoise cellNoise2 = null;
    FastNoise perturb1 = null;
    FastNoise perturb2 = null;
    FastNoise perturbSmall1 = null;
    FastNoise perturbSmall2 = null;
    double storedNoiseHigh = 0.0;
    double storedNoiseLow = 0.0;

    public NaturalGenerator(Codec<NoFeatureConfig> configCodec) {
        super(configCodec);
    }

    private void getHighestNoisePoint(double noise) {
        if (noise > this.storedNoiseHigh) {
            this.storedNoiseHigh = noise;
            Unearthed.LOGGER.info("Highest Noise point: " + this.storedNoiseHigh);
        }
        if (noise < this.storedNoiseLow) {
            this.storedNoiseLow = noise;
            Unearthed.LOGGER.info("Lowest Noise point: " + this.storedNoiseLow);
        }
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                int topY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p());
                for (int y = 0; y < topY; ++y) {
                    if (topY < 2) {
                        topY = 256;
                    }
                    FNVector3f perturb3f = new FNVector3f(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p());
                    this.perturb1.GradientPerturb(perturb3f);
                    this.perturbSmall1.GradientPerturb(perturb3f);
                    FNVector3f perturb3f2 = new FNVector3f(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p());
                    this.perturb2.GradientPerturb(perturb3f2);
                    this.perturbSmall2.GradientPerturb(perturb3f2);
                    double cellNoise1 = this.cellNoise1.GetNoise(perturb3f.x, perturb3f.y, perturb3f.z);
                    double cellNoise2 = this.cellNoise2.GetNoise(perturb3f2.x, perturb3f2.y, perturb3f2.z);
                    double selectorNoiseValue = (double)(this.selectorNoise.GetValue(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()) * 12.0f) + 0.5;
                    double clampedValue = MathHelper.func_151238_b((double)cellNoise1, (double)cellNoise2, (double)selectorNoiseValue);
                    ConfigBlockReader reader = ConfigBlockReader.blocksFromConfig.get((int)((clampedValue / 2.0 + 0.5) * (double)ConfigBlockReader.blocksFromConfig.size()));
                    BlockState mutableState = world.func_180495_p((BlockPos)mutable);
                    if (reader.getBlock() != Blocks.field_150348_b) {
                        if (NaturalGenerator.useStoneTag(world, (BlockPos)mutable)) {
                            world.func_180501_a((BlockPos)mutable, reader.getBlock().func_176223_P(), 2);
                        } else if (((Boolean)UnearthedConfig.replaceCobble.get()).booleanValue() && mutableState.func_177230_c() == Blocks.field_150347_e) {
                            world.func_180501_a((BlockPos)mutable, reader.getCobbleBlock(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150365_q.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getCoalOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150366_p.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getIronOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150352_o.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getGoldOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150369_x.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getLapisOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150450_ax.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getRedstoneOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150482_ag.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getDiamondOre(mutableState).func_176223_P(), 2);
                        } else if (mutableState == Blocks.field_150412_bA.func_176223_P()) {
                            world.func_180501_a((BlockPos)mutable, reader.getEmeraldOre(mutableState).func_176223_P(), 2);
                        }
                    }
                    mutable.func_189536_c(Direction.UP);
                }
            }
        }
        return true;
    }

    public static boolean useStoneTag(ISeedReader world, BlockPos mutable) {
        boolean stoneTag = (Boolean)UnearthedConfig.stoneTag.get();
        if (stoneTag) {
            return world.func_180495_p(mutable).func_235714_a_((ITag)BlockTags.field_242172_aH);
        }
        return world.func_180495_p(mutable) == Blocks.field_150348_b.func_176223_P();
    }

    private void setSeed(long seed) {
        float scaleFactor = ((Double)UnearthedConfig.stoneVeinScaleFactor.get()).floatValue();
        float perturbAmpStrength = ((Double)UnearthedConfig.perturbAmpStrength.get()).floatValue();
        float smallPerturbAmpStrength = ((Double)UnearthedConfig.smallPerturbAmpStrength.get()).floatValue();
        int perturbOctaves = (Integer)UnearthedConfig.perturbAmpOctaves.get();
        int smallPerturbOctaves = (Integer)UnearthedConfig.smallPerturbAmpOctaves.get();
        if (this.selectorNoise == null) {
            this.selectorNoise = new FastNoise((int)seed);
            this.selectorNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.selectorNoise.SetFrequency(8.0E-4f * scaleFactor);
        }
        if (this.cellNoise1 == null) {
            this.cellNoise1 = new FastNoise((int)seed + 19495485);
            this.cellNoise1.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.cellNoise1.SetFrequency(0.004f * scaleFactor);
        }
        if (this.cellNoise2 == null) {
            this.cellNoise2 = new FastNoise((int)seed + 9484585);
            this.cellNoise2.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.cellNoise2.SetFrequency(0.004f * scaleFactor);
        }
        if (this.perturb1 == null) {
            this.perturb1 = new FastNoise((int)seed + 2838495);
            this.perturb1.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.perturb1.SetFractalOctaves(perturbOctaves);
            this.perturb1.SetGradientPerturbAmp(perturbAmpStrength);
            this.perturb1.SetFrequency(0.008f * scaleFactor);
        }
        if (this.perturb2 == null) {
            this.perturb2 = new FastNoise((int)seed + 100);
            this.perturb2.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.perturb2.SetFractalOctaves(perturbOctaves);
            this.perturb2.SetGradientPerturbAmp(perturbAmpStrength);
            this.perturb2.SetFrequency(0.008f * scaleFactor);
        }
        if (this.perturbSmall1 == null) {
            this.perturbSmall1 = new FastNoise((int)seed + 9475);
            this.perturbSmall1.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.perturbSmall1.SetFractalOctaves(smallPerturbOctaves);
            this.perturbSmall1.SetGradientPerturbAmp(smallPerturbAmpStrength);
            this.perturbSmall1.SetFrequency(0.06f * scaleFactor);
        }
        if (this.perturbSmall2 == null) {
            this.perturbSmall2 = new FastNoise((int)seed + 948556);
            this.perturbSmall2.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.perturbSmall2.SetFractalOctaves(smallPerturbOctaves);
            this.perturbSmall2.SetGradientPerturbAmp(smallPerturbAmpStrength);
            this.perturbSmall2.SetFrequency(0.06f * scaleFactor);
        }
    }
}

