/*
 * Decompiled with CFR 0.152.
 */
package net.oriondevcorgitaco.unearthed.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.oriondevcorgitaco.unearthed.block.BlockGeneratorReference;
import net.oriondevcorgitaco.unearthed.util.RegistrationHelper;
import net.oriondevcorgitaco.unearthed.util.noise.FastNoise;

public class StrataGenerator
extends Feature<NoFeatureConfig> {
    public static final Feature<NoFeatureConfig> UNDERGROUND_STONE = RegistrationHelper.registerFeature("strata_gen1", new StrataGenerator((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    FastNoise fastNoise3D = null;
    FastNoise fastNoise3D2 = null;

    public StrataGenerator(Codec<NoFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                int topY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p());
                for (int y = 0; y < topY; ++y) {
                    double noise3D = this.fastNoise3D.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p());
                    if (world.func_180495_p((BlockPos)mutable).func_177230_c().func_203417_a((ITag)BlockTags.field_242172_aH)) {
                        if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.ICY) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196654_e.func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196656_g.func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIMESTONE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GABBRO.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.MESA) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196721_fC.func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196722_fD.func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196783_fs.func_176223_P(), 2);
                            } else if (noise3D > -0.6) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196777_fo.func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196789_fv.func_176223_P(), 2);
                            } else if (noise3D > -0.8) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196791_fw.func_176223_P(), 2);
                            } else if (noise3D > -0.9) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_150405_ch.func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196778_fp.func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.EXTREME_HILLS) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196650_c.func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196656_g.func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.9) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.KIMBERLITE.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.EXTREME_HILLS) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196654_e.func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196656_g.func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GRAY_BASALT.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.9) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.KIMBERLITE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.KIMBERLITE.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.OCEAN) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.PUMICE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GABBRO.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GABBRO.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GRAY_BASALT.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.DESERT) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_150322_A.func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.CONGLOMERATE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIMESTONE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIMESTONE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.SILTSTONE.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.SWAMP) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.SILTSTONE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.SILTSTONE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIGNITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIGNITE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.MUDSTONE.getBlock().func_176223_P(), 2);
                            }
                        } else if (world.func_226691_t_((BlockPos)mutable).func_201856_r() == Biome.Category.FOREST) {
                            if (noise3D > 0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.MARBLE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > 0.0) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.MARBLE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.5) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.SCHIST.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.7) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.PHYLLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D > -0.9) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.QUARTZITE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.QUARTZITE.getBlock().func_176223_P(), 2);
                            }
                        } else {
                            double noise3D2 = this.fastNoise3D2.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p());
                            if (noise3D2 > 0.8) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.LIMESTONE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > 0.6) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.MARBLE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > 0.4) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.CONGLOMERATE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > 0.0) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.QUARTZITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > -0.2) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.RHYOLITE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > -0.4) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.CONGLOMERATE.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > -0.6) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.GABBRO.getBlock().func_176223_P(), 2);
                            } else if (noise3D2 > -0.8) {
                                world.func_180501_a((BlockPos)mutable, BlockGeneratorReference.SILTSTONE.getBlock().func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_196656_g.func_176223_P(), 2);
                            }
                        }
                    }
                    mutable.func_189536_c(Direction.UP);
                }
            }
        }
        return true;
    }

    private void setSeed(long seed) {
        if (this.fastNoise3D == null) {
            this.fastNoise3D = new FastNoise((int)seed);
            this.fastNoise3D.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.fastNoise3D.SetFrequency(0.004f);
        }
        if (this.fastNoise3D2 == null) {
            this.fastNoise3D2 = new FastNoise((int)seed);
            this.fastNoise3D2.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.fastNoise3D2.SetFrequency(0.004f);
        }
    }
}

