/*
 * Decompiled with CFR 0.152.
 */
package net.oriondevcorgitaco.unearthed.mixin.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.oriondevcorgitaco.unearthed.config.UnearthedConfig;
import net.oriondevcorgitaco.unearthed.util.RegistrationHelper;
import net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators.NaturalDesertGenerator;
import net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators.NaturalGenerator;
import net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators.NaturalIcyGenerator;
import net.oriondevcorgitaco.unearthed.world.feature.naturalgenerators.TrueMesaGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MixinMinecraftServer {
    private final ConfiguredFeature<?, ?> NATURAL_GENERATOR = RegistrationHelper.newConfiguredFeature("natural_generator", NaturalGenerator.UNDERGROUND_STONE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));
    private final ConfiguredFeature<?, ?> NATURAL_ICY_GENERATOR = RegistrationHelper.newConfiguredFeature("natural_icy_generator", NaturalIcyGenerator.UNDERGROUND_STONE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));
    private final ConfiguredFeature<?, ?> NATURAL_DESERT_GENERATOR = RegistrationHelper.newConfiguredFeature("natural_desert_generator", NaturalDesertGenerator.UNDERGROUND_STONE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));
    private final ConfiguredFeature<?, ?> MESA_GENERATOR = RegistrationHelper.newConfiguredFeature("true_mesa_generator", TrueMesaGenerator.MESA.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig())));
    @Shadow
    @Final
    protected DynamicRegistries.Impl field_240767_f_;

    @Inject(at={@At(value="RETURN")}, method={"<init>(Ljava/lang/Thread;Lnet/minecraft/util/registry/DynamicRegistries$Impl;Lnet/minecraft/world/storage/SaveFormat$LevelSave;Lnet/minecraft/world/storage/IServerConfiguration;Lnet/minecraft/resources/ResourcePackList;Ljava/net/Proxy;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/resources/DataPackRegistries;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Lcom/mojang/authlib/GameProfileRepository;Lnet/minecraft/server/management/PlayerProfileCache;Lnet/minecraft/world/chunk/listener/IChunkStatusListenerFactory;)V"}, cancellable=true)
    private void implementUnearthedStones(Thread thread, DynamicRegistries.Impl impl, SaveFormat.LevelSave session, IServerConfiguration saveProperties, ResourcePackList resourcePackManager, Proxy proxy, DataFixer dataFixer, DataPackRegistries serverResourceManager, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache userCache, IChunkStatusListenerFactory worldGenerationProgressListenerFactory, CallbackInfo ci) {
        if (this.field_240767_f_.func_230521_a_(Registry.field_239720_u_).isPresent()) {
            for (Biome biome : (MutableRegistry)this.field_240767_f_.func_230521_a_(Registry.field_239720_u_).get()) {
                if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND || biome.func_201856_r() == Biome.Category.NONE) continue;
                if (MixinMinecraftServer.useDesertCaves(biome)) {
                    MixinMinecraftServer.addFeatureToBiome(biome, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, this.NATURAL_DESERT_GENERATOR);
                    continue;
                }
                if (MixinMinecraftServer.useIceCaves(biome)) {
                    MixinMinecraftServer.addFeatureToBiome(biome, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, this.NATURAL_ICY_GENERATOR);
                    continue;
                }
                if (MixinMinecraftServer.useTrueMesas(biome)) {
                    MixinMinecraftServer.addFeatureToBiome(biome, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, this.MESA_GENERATOR);
                    continue;
                }
                MixinMinecraftServer.addFeatureToBiome(biome, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, this.NATURAL_GENERATOR);
            }
        }
    }

    private static void addFeatureToBiome(Biome biome, GenerationStage.Decoration feature, ConfiguredFeature<?, ?> configuredFeature) {
        MixinMinecraftServer.ConvertImmutableFeatures(biome);
        List biomeFeatures = biome.func_242440_e().field_242484_f;
        while (biomeFeatures.size() <= feature.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        ((List)biomeFeatures.get(feature.ordinal())).add(() -> configuredFeature);
    }

    private static void ConvertImmutableFeatures(Biome biome) {
        if (biome.func_242440_e().field_242484_f instanceof ImmutableList) {
            biome.func_242440_e().field_242484_f = biome.func_242440_e().field_242484_f.stream().map(Lists::newArrayList).collect(Collectors.toList());
        }
    }

    private static boolean useTrueMesas(Biome biome) {
        boolean trueMesas = (Boolean)UnearthedConfig.trueMesas.get();
        if (trueMesas) {
            return biome.func_201856_r() == Biome.Category.MESA;
        }
        return false;
    }

    private static boolean useIceCaves(Biome biome) {
        boolean icyCaves = (Boolean)UnearthedConfig.icyCaves.get();
        if (icyCaves) {
            return biome.func_201856_r() == Biome.Category.ICY;
        }
        return false;
    }

    private static boolean useDesertCaves(Biome biome) {
        boolean desertCaves = (Boolean)UnearthedConfig.desertCaves.get();
        if (desertCaves) {
            return biome.func_201856_r() == Biome.Category.DESERT;
        }
        return false;
    }
}

