/*
 * Decompiled with CFR 0.152.
 */
package net.oriondevcorgitaco.unearthed.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.oriondevcorgitaco.unearthed.Unearthed;
import net.oriondevcorgitaco.unearthed.block.BlockGeneratorReference;
import net.oriondevcorgitaco.unearthed.util.BlockDataHelper;

public class BlockGeneratorHelper {
    public static ItemGroup UNEARTHED_TAB = new ItemGroup("unearthed"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", "kimberlite_diamond_ore")));
        }

        public boolean hasSearchBar() {
            return true;
        }

        public boolean func_78017_i() {
            return true;
        }
    };
    private final String id;
    private final boolean hasPolished;
    private final boolean hasCobble;
    private final boolean hasMossy;
    private final boolean hasBricks;
    private final boolean hasMossyBricks;
    public static List<String> baseBlockIdList = new ArrayList<String>();
    public static List<String> cobbleBlockIdList = new ArrayList<String>();
    public static List<String> oreBlockIdList = new ArrayList<String>();
    public static List<String> wallIDList = new ArrayList<String>();
    public static List<String> slabList = new ArrayList<String>();
    public static List<String> buttonList = new ArrayList<String>();
    public static List<String> stairsList = new ArrayList<String>();
    public static List<Block> baseStoneBlockArray = new ArrayList<Block>();
    public static List<Block> cobbleStoneBlockArray = new ArrayList<Block>();
    public static List<Block> oreBlockArray = new ArrayList<Block>();
    public static List<String> getCobbleBlockIdList = new ArrayList<String>();

    public BlockGeneratorHelper(String id, boolean hasPolishedVariant, boolean hasCobbleVariant, boolean hasMossyVariant, boolean hasBricksVariant, boolean hasMossyBricksVariant) {
        this.id = id;
        this.hasPolished = hasPolishedVariant;
        this.hasCobble = hasCobbleVariant;
        this.hasMossy = hasMossyVariant;
        this.hasBricks = hasBricksVariant;
        this.hasMossyBricks = hasMossyBricksVariant;
        BlockGeneratorReference.ROCK_TYPES.add(this);
        this.generateBaseVariant();
        this.generateCobbleVariant(hasCobbleVariant);
        this.generateVanillaOreVariants();
        baseBlockIdList.add(id);
    }

    private void generateBaseVariant() {
        String slabID = this.id + "_slab";
        String stairID = this.id + "_stairs";
        String buttonID = this.id + "_button";
        String plateID = this.id + "_pressure_plate";
        String wallID = this.id + "_wall";
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", this.id), (Object)new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", slabID), (Object)new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150333_U).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", stairID), (Object)((Object)new StairsBlockAccess(((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id))).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222438_lb).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", buttonID), (Object)((Object)new ButtonBlockAccess(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150430_aB).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", plateID), (Object)((Object)new PressurePlateBlockAccess(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150456_au).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", wallID), (Object)new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222413_lB).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
        Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", this.id), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
        slabList.add("\"unearthed:" + slabID + "\",");
        wallIDList.add("\"unearthed:" + wallID + "\",");
        buttonList.add("\"unearthed:" + buttonID + "\",");
        stairsList.add("\"unearthed:" + stairID + "\",");
        for (String type : BlockDataHelper.BASE_TYPES) {
            String modifiedID = this.id + type;
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", modifiedID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", modifiedID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
        }
        baseStoneBlockArray.add((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id)));
    }

    private void generatePolishedVariant(boolean generate) {
        if (generate) {
            String polishedID = "polished_" + this.id;
            String polishedSlabID = polishedID + "_slab";
            String polishedStairID = polishedID + "_stairs";
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", polishedID), (Object)new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196657_h)));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", polishedSlabID), (Object)new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222444_lh)));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", polishedStairID), (Object)((Object)new StairsBlockAccess(((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedID))).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e))));
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", polishedID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", polishedSlabID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedSlabID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", polishedStairID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedStairID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
        }
    }

    private void generateVanillaOreVariants() {
        String coalOreID = this.id + "_coal_ore";
        String ironOreID = this.id + "_iron_ore";
        String goldOreID = this.id + "_gold_ore";
        String lapisOreID = this.id + "_lapis_ore";
        String redStoneOreID = this.id + "_redstone_ore";
        String diamondOreID = this.id + "_diamond_ore";
        String emeraldOreID = this.id + "_emerald_ore";
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", coalOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150365_q).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", ironOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150366_p).harvestLevel(1).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", goldOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150352_o).harvestLevel(2).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", lapisOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150369_x).harvestLevel(2).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", redStoneOreID), (Object)new RedstoneOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150450_ax).harvestLevel(2).harvestTool(ToolType.PICKAXE)));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", diamondOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150482_ag).harvestLevel(2).harvestTool(ToolType.PICKAXE))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", emeraldOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150412_bA).harvestLevel(2).harvestTool(ToolType.PICKAXE))));
        for (String type : BlockDataHelper.VANILLA_ORE_TYPES) {
            String modifiedID = this.id + type;
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", modifiedID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", modifiedID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
            oreBlockArray.add((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", modifiedID)));
            oreBlockIdList.add(modifiedID);
        }
    }

    private void generateBYGOreVariants() {
        String bygID = "byg";
        String ametrineOreID = this.id + "_ametrine_ore";
        String pendoriteOreID = this.id + "_pendorite_ore";
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", ametrineOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)Registry.field_212618_g.func_82594_a(new ResourceLocation(bygID, "ametrine_ore")))))));
        Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", pendoriteOreID), (Object)((Object)new UEOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)Registry.field_212618_g.func_82594_a(new ResourceLocation(bygID, "pendorite_ore")))))));
        for (String type : BlockDataHelper.BYG_ORE_TYPES) {
            String modifiedID = this.id + type;
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", modifiedID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", modifiedID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
        }
    }

    private void generateCobbleVariant(boolean generate) {
        if (generate) {
            String cobbleID = this.id + "_cobble";
            String slabID = cobbleID + "_slab";
            String stairID = cobbleID + "_stairs";
            String buttonID = cobbleID + "_button";
            String plateID = cobbleID + "_pressure_plate";
            String wallID = cobbleID + "_wall";
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", cobbleID), (Object)new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", slabID), (Object)new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150333_U).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", stairID), (Object)((Object)new StairsBlockAccess(((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id))).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222438_lb).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", buttonID), (Object)((Object)new ButtonBlockAccess(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150430_aB).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", plateID), (Object)((Object)new PressurePlateBlockAccess(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150456_au).harvestLevel(0).harvestTool(ToolType.PICKAXE))));
            Registry.func_218322_a((Registry)Registry.field_212618_g, (ResourceLocation)new ResourceLocation("unearthed", wallID), (Object)new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222413_lB).harvestLevel(0).harvestTool(ToolType.PICKAXE)));
            Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", cobbleID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", cobbleID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
            cobbleBlockIdList.add(cobbleID);
            slabList.add("\"unearthed:" + slabID + "\",");
            wallIDList.add("\"unearthed:" + wallID + "\",");
            buttonList.add("\"unearthed:" + buttonID + "\",");
            stairsList.add("\"unearthed:" + stairID + "\",");
            for (String type : BlockDataHelper.BASE_TYPES) {
                String modifiedID = cobbleID + type;
                Registry.func_218322_a((Registry)Registry.field_212630_s, (ResourceLocation)new ResourceLocation("unearthed", modifiedID), (Object)new BlockItem((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", modifiedID)), new Item.Properties().func_200916_a(UNEARTHED_TAB)));
            }
            cobbleStoneBlockArray.add((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id)));
            cobbleBlockIdList.add(cobbleID);
        }
    }

    public Block getBlock() {
        Block block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", this.id));
        if (block == null) {
            Unearthed.LOGGER.error("Block does not exist");
            block = Blocks.field_150348_b;
        }
        return block;
    }

    public Block getSlabBlock() {
        String slabID = this.id + "_slab";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", slabID));
    }

    public Block getStairBlock() {
        String stairID = this.id + "_stair";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", stairID));
    }

    public Block getPolishedBlock() {
        String polishedID = "polished_" + this.id;
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedID));
    }

    public Block getPolishedSlabBlock() {
        String polishedID = "polished_" + this.id;
        String polishedSlabID = polishedID + "_slab";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedSlabID));
    }

    public Block getPolishedStairBlock() {
        String polishedID = "polished_" + this.id;
        String polishedStairID = polishedID + "_stairs";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", polishedStairID));
    }

    public Block getCobbleBlock() {
        String cobbleID = this.id + "_cobble";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", cobbleID));
    }

    public Block getCobbleSlabBlock() {
        String cobbleID = this.id + "_cobble";
        String cobbleSlabID = cobbleID + "_slab";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", cobbleSlabID));
    }

    public Block getCobbleStairBlock() {
        String cobbleID = this.id + "_cobble";
        String cobbleStairID = cobbleID + "_stairs";
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("unearthed", cobbleStairID));
    }

    public Item getItem() {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", this.id));
    }

    public Item getSlabItem() {
        String slabID = this.id + "_slab";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", slabID));
    }

    public Item getStairItem() {
        String stairID = this.id + "_stair";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", stairID));
    }

    public Item getPolishedItem() {
        String polishedID = "polished_" + this.id;
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", polishedID));
    }

    public Item getPolishedSlabItem() {
        String polishedID = "polished_" + this.id;
        String polishedSlabID = polishedID + "_slab";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", polishedSlabID));
    }

    public Item getPolishedStairItem() {
        String polishedID = "polished_" + this.id;
        String polishedStairID = polishedID + "_stairs";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", polishedStairID));
    }

    public Item getCobbleItem() {
        String cobbleID = this.id + "_cobble";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", cobbleID));
    }

    public Item getCobbleSlabItem() {
        String cobbleID = this.id + "_cobble";
        String cobbleSlabID = cobbleID + "_slab";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", cobbleSlabID));
    }

    public Item getCobbleStairItem() {
        String cobbleID = this.id + "_cobble";
        String cobbleStairID = cobbleID + "_stairs";
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", cobbleStairID));
    }

    public static class UECreativeTab {
        public static ItemGroup ueCreativeTab = new ItemGroup("unearthed"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation("unearthed", "kimberlite_diamond_ore")));
            }

            public boolean hasSearchBar() {
                return true;
            }

            public boolean func_78017_i() {
                return true;
            }
        };

        public static void init() {
            Unearthed.LOGGER.debug("Unearthed: Item Group Created!");
        }
    }

    public static class UEOreBlock
    extends OreBlock {
        public UEOreBlock(AbstractBlock.Properties Properties2) {
            super(Properties2);
        }

        protected int func_220281_a(Random random) {
            if (this.func_203417_a((ITag)Tags.Blocks.ORES_COAL)) {
                return MathHelper.func_76136_a((Random)random, (int)0, (int)2);
            }
            if (this.func_203417_a((ITag)Tags.Blocks.ORES_DIAMOND)) {
                return MathHelper.func_76136_a((Random)random, (int)3, (int)7);
            }
            if (this.func_203417_a((ITag)Tags.Blocks.ORES_EMERALD)) {
                return MathHelper.func_76136_a((Random)random, (int)3, (int)7);
            }
            if (this.func_203417_a((ITag)Tags.Blocks.ORES_LAPIS)) {
                return MathHelper.func_76136_a((Random)random, (int)2, (int)5);
            }
            return 0;
        }
    }

    public static class ButtonBlockAccess
    extends StoneButtonBlock {
        public ButtonBlockAccess(AbstractBlock.Properties Properties2) {
            super(Properties2);
        }
    }

    public static class PressurePlateBlockAccess
    extends PressurePlateBlock {
        public PressurePlateBlockAccess(AbstractBlock.Properties Properties2) {
            super(PressurePlateBlock.Sensitivity.MOBS, Properties2);
        }
    }

    public static class StairsBlockAccess
    extends StairsBlock {
        public StairsBlockAccess(BlockState baseBlockState, AbstractBlock.Properties Properties2) {
            super(baseBlockState, Properties2);
        }
    }
}

