/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.chunk;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import javax.annotation.Nullable;
import mod.azure.chunk.util.LoaderInterface;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;

public class ChunkLoader
implements LoaderInterface {
    public Long2IntMap intMap = new Long2IntOpenHashMap();
    public LongSet longSet = new LongOpenHashSet();
    public boolean loading = false;
    @Nullable
    public final ServerWorld world;

    public ChunkLoader(ServerWorld world) {
        this.intMap.defaultReturnValue(Integer.MIN_VALUE);
        this.world = world;
    }

    @Override
    public void add(BlockPos pos) {
        if (!this.longSet.contains(pos.func_218275_a())) {
            if (!this.loading) {
                this.forceload(pos, "add");
            }
            this.intMap.put(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)), this.intMap.get(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4))));
            this.longSet.add(pos.func_218275_a());
        }
    }

    @Override
    public void remove(BlockPos pos) {
        if (this.longSet.remove(pos.func_218275_a())) {
            if (this.intMap.get(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4))) == Integer.MIN_VALUE) {
                if (!this.loading) {
                    this.forceload(pos, "remove");
                }
                this.intMap.remove(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)));
            } else {
                this.intMap.put(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)), this.intMap.get(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4))));
            }
        }
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.longSet.contains(pos.func_218275_a());
    }

    public void force(BlockPos pos) {
        this.forceload(pos, "add");
    }

    public void forceload(BlockPos pos, String action) {
        this.world.func_73046_m().func_195571_aL().func_197059_a(this.world.func_73046_m().func_195573_aM().func_201003_a(this.world), "forceload " + action + " " + pos.func_177958_n() + " " + pos.func_177952_p());
    }

    public static class Storage
    implements Capability.IStorage<LoaderInterface> {
        public INBT writeNBT(Capability<LoaderInterface> capability, LoaderInterface instance, Direction side) {
            if (!(instance instanceof ChunkLoader)) {
                return null;
            }
            ChunkLoader list = (ChunkLoader)instance;
            long[] data = new long[list.longSet.size()];
            int idx = 0;
            LongIterator longIterator = list.longSet.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                data[idx++] = l;
            }
            return new LongArrayNBT(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readNBT(Capability<LoaderInterface> capability, LoaderInterface instance, Direction side, INBT nbt) {
            if (!(instance instanceof ChunkLoader) || !(nbt instanceof LongArrayNBT)) {
                return;
            }
            ChunkLoader list = (ChunkLoader)instance;
            list.loading = true;
            list.intMap.clear();
            list.longSet.clear();
            try {
                for (long l : ((LongArrayNBT)nbt).func_197652_h()) {
                    list.add(BlockPos.func_218283_e((long)l));
                }
                if (list.world != null) {
                    list.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                        LongIterator longIterator = list.intMap.keySet().iterator();
                        while (longIterator.hasNext()) {
                            long l = (Long)longIterator.next();
                            ChunkPos chunk = new ChunkPos(l);
                            list.force(new BlockPos(chunk.field_77276_a << 4, 0, chunk.field_77275_b << 4));
                        }
                    }));
                }
            }
            finally {
                list.loading = false;
            }
        }
    }
}

