/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.events;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.collective.objects.SAMObject;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MobSpawnEvents {
    @SubscribeEvent
    public void onMobSpawn(LivingSpawnEvent.CheckSpawn e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getWorld());
        if (world == null) {
            return;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return;
        }
        Entity entity = e.getEntity();
        EntityType entitytype = entity.func_200600_R();
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return;
        }
        boolean isspawner = e.getSpawner() != null;
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return;
        }
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vector3d evec = entity.func_213303_ch();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue()) continue;
            Entity to = sam.totype.func_200721_a(world);
            to.func_70029_a(world);
            to.func_70107_b(evec.field_72450_a, evec.field_72448_b, evec.field_72449_c);
            if (sam.helditem != null && to instanceof LivingEntity && !(le = (LivingEntity)to).func_184614_ca().func_77973_b().equals(sam.helditem)) {
                le.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)sam.helditem, 1));
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                if (to instanceof AbstractHorseEntity) {
                    AbstractHorseEntity ah = (AbstractHorseEntity)to;
                    ah.func_110234_j(true);
                    to = ah;
                    ride = true;
                }
            } else if (((Boolean)ConfigHandler.COLLECTIVE.transferItemsBetweenReplacedEntities.get()).booleanValue()) {
                EntityFunctions.transferItemsBetweenEntities(entity, to);
            }
            world.func_217376_c(to);
            if (ride) {
                entity.func_184220_m(to);
                break;
            }
            e.setResult(Event.Result.DENY);
            break;
        }
    }
}

