/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.world.carver.BetterCavesCarver;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CarverFeature
extends Feature<NoFeatureConfig> {
    public CarverFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @ParametersAreNonnullByDefault
    public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        WorldGenRegion worldGenRegion = (WorldGenRegion)world;
        String dimensionName = null;
        try {
            dimensionName = Objects.requireNonNull(worldGenRegion.func_201672_e().func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! Using default cave gen...");
        }
        IChunk chunk = world.func_217349_x(pos);
        ChunkPos chunkPos = chunk.func_76632_l();
        int xChunkPos = chunkPos.field_77276_a;
        int zChunkPos = chunkPos.field_77275_b;
        if (dimensionName == null || !this.isDimensionWhitelisted(dimensionName)) {
            return this.useOtherCarver(world, generator, pos);
        }
        if (BetterCaves.activeCarversMap.get(dimensionName) == null || BetterCaves.activeCarversMap.get(dimensionName).getSeed() != world.func_72905_C()) {
            BetterCavesCarver newCarver = new BetterCavesCarver();
            BetterCaves.activeCarversMap.put(dimensionName, newCarver);
            BetterCaves.LOGGER.info(String.format("CREATING AND INIT'ING CARVER W DIMENSION %s...", dimensionName));
            newCarver.initialize(world);
        }
        BetterCavesCarver carver = BetterCaves.activeCarversMap.get(dimensionName);
        carver.setWorld(world);
        carver.carve(chunk, xChunkPos, zChunkPos);
        return true;
    }

    private boolean useOtherCarver(ISeedReader world, ChunkGenerator generator, BlockPos pos) {
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        IChunk chunk = world.func_217349_x(pos);
        ChunkPos chunkPos = chunk.func_76632_l();
        int xChunkPos = chunkPos.field_77276_a;
        int zChunkPos = chunkPos.field_77275_b;
        BitSet airCarvingMask = ((ChunkPrimer)chunk).func_230345_b_(GenerationStage.Carving.AIR);
        BitSet liquidCarvingMask = ((ChunkPrimer)chunk).func_230345_b_(GenerationStage.Carving.LIQUID);
        Biome biome = chunk.func_225549_i_().func_225526_b_(pos.func_177958_n(), 1, pos.func_177952_p());
        BiomeManager biomeManager = world.func_225523_d_().func_226835_a_(generator.func_202090_b());
        List<Supplier<ConfiguredCarver<?>>> defaultAirCarvers = BetterCaves.defaultBiomeAirCarvers.get(biome.toString());
        List<Supplier<ConfiguredCarver<?>>> defaultLiquidCarvers = BetterCaves.defaultBiomeLiquidCarvers.get(biome.toString());
        if (defaultAirCarvers == null || defaultLiquidCarvers == null) {
            return false;
        }
        for (int currChunkX = xChunkPos - 8; currChunkX <= xChunkPos + 8; ++currChunkX) {
            for (int currChunkZ = zChunkPos - 8; currChunkZ <= zChunkPos + 8; ++currChunkZ) {
                ConfiguredCarver<?> carver;
                int i;
                for (i = 0; i < defaultAirCarvers.size(); ++i) {
                    sharedSeedRandom.func_202425_c(world.func_72905_C() + (long)i, currChunkX, currChunkZ);
                    carver = defaultAirCarvers.get(i).get();
                    if (!carver.func_222730_a((Random)sharedSeedRandom, currChunkX, currChunkZ)) continue;
                    carver.func_227207_a_(chunk, arg_0 -> ((BiomeManager)biomeManager).func_226836_a_(arg_0), (Random)sharedSeedRandom, world.func_181545_F(), currChunkX, currChunkZ, xChunkPos, zChunkPos, airCarvingMask);
                }
                for (i = 0; i < defaultLiquidCarvers.size(); ++i) {
                    sharedSeedRandom.func_202425_c(world.func_72905_C() + (long)i, currChunkX, currChunkZ);
                    carver = defaultLiquidCarvers.get(i).get();
                    if (!carver.func_222730_a((Random)sharedSeedRandom, currChunkX, currChunkZ)) continue;
                    carver.func_227207_a_(chunk, arg_0 -> ((BiomeManager)biomeManager).func_226836_a_(arg_0), (Random)sharedSeedRandom, world.func_181545_F(), currChunkX, currChunkZ, xChunkPos, zChunkPos, liquidCarvingMask);
                }
            }
        }
        return true;
    }

    private boolean isDimensionWhitelisted(String dimensionName) {
        return (Boolean)Configuration.enableGlobalWhitelist.get() != false || BetterCaves.whitelistedDimensions.contains(dimensionName);
    }
}

