/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.cavern;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarverBuilder;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class CavernCarver
implements ICarver {
    private CarverSettings settings;
    private NoiseGen noiseGen;
    private CavernType cavernType;
    private int bottomY;
    private int topY;

    public CavernCarver(CavernCarverBuilder builder) {
        this.settings = builder.getSettings();
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.cavernType = builder.getCavernType();
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        if (this.bottomY > this.topY) {
            BetterCaves.LOGGER.warn("Warning: Min altitude for caverns should not be greater than max altitude.");
            BetterCaves.LOGGER.warn("Using default values...");
            this.bottomY = 1;
            this.topY = 35;
        }
    }

    public void carveColumn(IChunk chunk, ColPos colPos, int topY, float smoothAmp, NoiseColumn noises, BlockState liquidBlock, boolean flooded, BitSet carvingMask) {
        int localX = BetterCavesUtils.getLocal(colPos.getX());
        int localZ = BetterCavesUtils.getLocal(colPos.getZ());
        if (localX < 0 || localX > 15) {
            return;
        }
        if (localZ < 0 || localZ > 15) {
            return;
        }
        if (this.bottomY < 0 || this.bottomY > 255) {
            return;
        }
        if (topY > 255) {
            return;
        }
        int topTransitionBoundary = (topY -= 2) - 6;
        int bottomTransitionBoundary = this.bottomY + 3;
        if (this.cavernType == CavernType.FLOORED) {
            bottomTransitionBoundary = this.bottomY < this.settings.getLiquidAltitude() ? this.settings.getLiquidAltitude() + 8 : this.bottomY + 7;
        }
        topTransitionBoundary = Math.max(topTransitionBoundary, 1);
        bottomTransitionBoundary = Math.min(bottomTransitionBoundary, 255);
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            boolean digBlock = false;
            float noise = 1.0f;
            List<Double> noiseBlock = noises.get(y).getNoiseValues();
            for (double n : noiseBlock) {
                noise = (float)((double)noise * n);
            }
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (y >= topTransitionBoundary) {
                noiseThreshold *= (float)(y - topY) / (float)(topTransitionBoundary - topY);
            }
            if (y < bottomTransitionBoundary) {
                noiseThreshold *= (float)(y - this.bottomY) / (float)(bottomTransitionBoundary - this.bottomY);
            }
            if (smoothAmp < 1.0f) {
                noiseThreshold *= smoothAmp;
            }
            if (noise < noiseThreshold) {
                digBlock = true;
            }
            BlockPos blockPos = new BlockPos(localX, y, localZ);
            if (this.settings.isEnableDebugVisualizer()) {
                CarverUtils.debugCarveBlock(chunk, blockPos, this.settings.getDebugBlock(), digBlock);
                continue;
            }
            if (!digBlock) continue;
            if (flooded) {
                CarverUtils.carveFloodedBlock(chunk, new Random(), blockPos.func_239590_i_(), liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
                continue;
            }
            CarverUtils.carveBlock(chunk, blockPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
        }
    }

    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getPriority() {
        return this.settings.getPriority();
    }

    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }
}

