/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cavern;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigFlooredCavern {
    public final ForgeConfigSpec.ConfigValue<Integer> cavernBottom;
    public final ForgeConfigSpec.ConfigValue<Integer> cavernTop;
    public final ForgeConfigSpec.ConfigValue<Double> yCompression;
    public final ForgeConfigSpec.ConfigValue<Double> xzCompression;
    public final ForgeConfigSpec.ConfigValue<Integer> cavernPriority;
    public final Advanced advancedSettings;

    public ConfigFlooredCavern(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# Settings used in the generation of Floored Caverns found at low altitudes.\n# These have much more ground to walk on than Liquid Caverns.\n##########################################################################################################").push("Floored Caverns");
        this.cavernBottom = BUILDER.comment(" The minimum y-coordinate at which Floored Caverns can generate.\n Default: 1").worldRestart().defineInRange("Floored Cavern Minimum Altitude", 1, 0, 255);
        this.cavernTop = BUILDER.comment(" The maximum y-coordinate at which Floored Caverns can generate.\n     Caverns will attempt to close off anyway if this value is greater than the surface's altitude.\n Default: 35").worldRestart().defineInRange("Floored Cavern Maximum Altitude", 35, 0, 255);
        this.yCompression = BUILDER.comment(" Stretches caverns vertically. Lower value = more open caverns with larger features.\n Default: 1.3").worldRestart().defineInRange("Compression - Vertical", 1.3, 0.0, 100.0);
        this.xzCompression = BUILDER.comment(" Stretches caverns horizontally. Lower value = more open caverns with larger features.\n Default: 0.7").worldRestart().defineInRange("Compression - Horizontal", 0.7, 0.0, 100.0);
        this.cavernPriority = BUILDER.comment(" Determines how frequently Floored Caverns spawn. 0 = will not spawn at all.\n Default: 10").worldRestart().defineInRange("Floored Cavern Priority", 10, 0, 10);
        this.advancedSettings = new Advanced();
        BUILDER.pop();
    }

    public static class Advanced {
        public final double noiseThreshold;
        public final int fractalOctaves;
        public final double fractalGain;
        public final double fractalFrequency;
        public final int numGenerators;
        public final String noiseType;

        public Advanced() {
            this.noiseThreshold = 0.6;
            this.fractalOctaves = 1;
            this.fractalGain = 0.3;
            this.fractalFrequency = 0.028;
            this.numGenerators = 2;
            this.noiseType = "SimplexFractal";
        }
    }
}

