/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeWorldServer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.WorldCapabilityData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorld
extends World
implements ISeedReader,
IForgeWorldServer {
    public static final BlockPos field_241108_a_ = new BlockPos(100, 50, 0);
    private static final Logger field_147491_a = LogManager.getLogger();
    private final Int2ObjectMap<Entity> field_217498_x = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    private final Queue<Entity> field_217499_z = Queues.newArrayDeque();
    private final List<ServerPlayerEntity> field_217491_A = Lists.newArrayList();
    private final ServerChunkProvider field_241102_C_;
    boolean field_217492_a;
    private final MinecraftServer field_73061_a;
    private final IServerWorldInfo field_241103_E_;
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final ServerTickList<Block> field_94579_S = new ServerTickList(this, p_205341_0_ -> p_205341_0_ == null || p_205341_0_.func_176223_P().func_196958_f(), arg_0 -> Registry.field_212618_g.func_177774_c(arg_0), this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList(this, p_205774_0_ -> p_205774_0_ == null || p_205774_0_ == Fluids.field_204541_a, arg_0 -> Registry.field_212619_h.func_177774_c(arg_0), this::func_205339_a);
    private final Set<PathNavigator> field_217495_I = Sets.newHashSet();
    protected final RaidManager field_217494_c;
    private final ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    private final List<ISpecialSpawner> field_241104_N_;
    @Nullable
    private final DragonFightManager field_241105_O_;
    private final StructureManager field_241106_P_;
    private final boolean field_241107_Q_;
    private WorldCapabilityData capabilityData;

    public ServerWorld(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_) {
        super((ISpawnWorldInfo)p_i241885_4_, p_i241885_5_, p_i241885_6_, p_i241885_1_::func_213185_aS, false, p_i241885_9_, p_i241885_10_);
        this.field_241107_Q_ = p_i241885_13_;
        this.field_73061_a = p_i241885_1_;
        this.field_241104_N_ = p_i241885_12_;
        this.field_241103_E_ = p_i241885_4_;
        this.field_241102_C_ = new ServerChunkProvider(this, p_i241885_3_, p_i241885_1_.func_195563_aC(), p_i241885_1_.func_240792_aT_(), p_i241885_2_, p_i241885_8_, p_i241885_1_.func_184103_al().func_72395_o(), p_i241885_1_.func_230540_aS_(), p_i241885_7_, () -> p_i241885_1_.func_241755_D_().func_217481_x());
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(p_i241885_1_.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_234620_a_((DimensionType)this.func_230315_m_()));
        if (!p_i241885_1_.func_71264_H()) {
            p_i241885_4_.func_230392_a_(p_i241885_1_.func_71265_f());
        }
        this.field_241106_P_ = new StructureManager((IWorld)this, p_i241885_1_.func_240793_aU_().func_230418_z_());
        this.field_241105_O_ = this.func_230315_m_().func_236046_h_() ? new DragonFightManager(this, p_i241885_1_.func_240793_aU_().func_230418_z_().func_236221_b_(), p_i241885_1_.func_240793_aU_().func_230402_B_()) : null;
        this.initCapabilities();
    }

    public void func_241113_a_(int p_241113_1_, int p_241113_2_, boolean p_241113_3_, boolean p_241113_4_) {
        this.field_241103_E_.func_230391_a_(p_241113_1_);
        this.field_241103_E_.func_76080_g(p_241113_2_);
        this.field_241103_E_.func_76090_f(p_241113_2_);
        this.field_241103_E_.func_76084_b(p_241113_3_);
        this.field_241103_E_.func_76069_a(p_241113_4_);
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_225526_b_(x, y, z);
    }

    public StructureManager func_241112_a_() {
        return this.field_241106_P_;
    }

    public void func_72835_b(BooleanSupplier hasTimeLeft) {
        boolean flag3;
        IProfiler iprofiler = this.func_217381_Z();
        this.field_211159_Q = true;
        iprofiler.func_76320_a("world border");
        this.func_175723_af().func_212673_r();
        iprofiler.func_219895_b("weather");
        boolean flag = this.func_72896_J();
        if (this.func_230315_m_().func_218272_d()) {
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                int i = this.field_241103_E_.func_230395_g_();
                int j = this.field_241103_E_.func_76071_n();
                int k = this.field_241103_E_.func_76083_p();
                boolean flag1 = this.field_72986_A.func_76061_m();
                boolean flag2 = this.field_72986_A.func_76059_o();
                if (i > 0) {
                    --i;
                    j = flag1 ? 0 : 1;
                    k = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j > 0) {
                        if (--j == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j = flag1 ? this.field_73012_v.nextInt(12000) + 3600 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                    if (k > 0) {
                        if (--k == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k = flag2 ? this.field_73012_v.nextInt(12000) + 12000 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                }
                this.field_241103_E_.func_76090_f(j);
                this.field_241103_E_.func_76080_g(k);
                this.field_241103_E_.func_230391_a_(i);
                this.field_241103_E_.func_76069_a(flag1);
                this.field_241103_E_.func_76084_b(flag2);
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            this.field_73017_q = MathHelper.func_76131_a((float)this.field_73017_q, (float)0.0f, (float)1.0f);
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            this.field_73004_o = MathHelper.func_76131_a((float)this.field_73004_o, (float)0.0f, (float)1.0f);
        }
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o), this.func_234923_W_());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q), this.func_234923_W_());
        }
        if (flag != this.func_72896_J()) {
            if (flag) {
                this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241766_c_, 0.0f), this.func_234923_W_());
            } else {
                this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f), this.func_234923_W_());
            }
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o), this.func_234923_W_());
            this.field_73061_a.func_184103_al().func_232642_a_((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q), this.func_234923_W_());
        }
        if (this.field_73068_P && this.field_217491_A.stream().noneMatch(p_241132_0_ -> !p_241132_0_.func_175149_v() && !p_241132_0_.func_71026_bH())) {
            this.field_73068_P = false;
            if (this.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                long l = this.func_72820_D() + 24000L;
                this.func_241114_a_(ForgeEventFactory.onSleepFinished((ServerWorld)this, (long)(l - l % 24000L), (long)this.func_72820_D()));
            }
            this.func_229856_ab_();
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                this.func_73051_P();
            }
        }
        this.func_72966_v();
        this.func_241126_b_();
        iprofiler.func_219895_b("chunkSource");
        this.func_72863_F().func_217207_a(hasTimeLeft);
        iprofiler.func_219895_b("tickPending");
        if (!this.func_234925_Z_()) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
        iprofiler.func_219895_b("raid");
        this.field_217494_c.func_215171_a();
        iprofiler.func_219895_b("blockEvents");
        this.func_147488_Z();
        this.field_211159_Q = false;
        iprofiler.func_219895_b("entities");
        boolean bl = flag3 = !this.field_217491_A.isEmpty() || !this.func_217469_z().isEmpty();
        if (flag3) {
            this.func_82742_i();
        }
        if (flag3 || this.field_80004_Q++ < 300) {
            if (this.field_241105_O_ != null) {
                this.field_241105_O_.func_186105_b();
            }
            this.field_217492_a = true;
            ObjectIterator objectiterator = this.field_217498_x.int2ObjectEntrySet().iterator();
            while (true) {
                if (!objectiterator.hasNext()) {
                    Entity entity;
                    this.field_217492_a = false;
                    while ((entity = this.field_217499_z.poll()) != null) {
                        this.func_217465_m(entity);
                    }
                    this.func_217391_K();
                    break;
                }
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
                Entity entity1 = (Entity)((Object)entry.getValue());
                Entity entity2 = entity1.func_184187_bx();
                if (!this.field_73061_a.func_230537_U_() && (entity1 instanceof AnimalEntity || entity1 instanceof WaterMobEntity)) {
                    entity1.func_70106_y();
                }
                if (!this.field_73061_a.func_230538_V_() && entity1 instanceof INPC) {
                    entity1.func_70106_y();
                }
                iprofiler.func_76320_a("checkDespawn");
                if (!entity1.field_70128_L) {
                    entity1.func_70623_bb();
                }
                iprofiler.func_76319_b();
                if (entity2 != null) {
                    if (!entity2.field_70128_L && entity2.func_184196_w(entity1)) continue;
                    entity1.func_184210_p();
                }
                iprofiler.func_76320_a("tick");
                if (!entity1.field_70128_L && !(entity1 instanceof EnderDragonPartEntity)) {
                    this.func_217390_a(this::func_217479_a, entity1);
                }
                iprofiler.func_76319_b();
                iprofiler.func_76320_a("remove");
                if (entity1.field_70128_L) {
                    this.func_217454_n(entity1);
                    objectiterator.remove();
                    this.removeEntityComplete(entity1, entity1 instanceof ServerPlayerEntity);
                }
                iprofiler.func_76319_b();
            }
        }
        iprofiler.func_76319_b();
    }

    protected void func_241126_b_() {
        if (this.field_241107_Q_) {
            long i = this.field_72986_A.func_82573_f() + 1L;
            this.field_241103_E_.func_82572_b(i);
            this.field_241103_E_.func_215763_z().func_216331_a((Object)this.field_73061_a, i);
            if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
                this.func_241114_a_(this.field_72986_A.func_76073_f() + 1L);
            }
        }
    }

    public void func_241114_a_(long p_241114_1_) {
        this.field_241103_E_.func_76068_b(p_241114_1_);
    }

    public void func_241123_a_(boolean p_241123_1_, boolean p_241123_2_) {
        for (ISpecialSpawner ispecialspawner : this.field_241104_N_) {
            ispecialspawner.func_230253_a_(this, p_241123_1_, p_241123_2_);
        }
    }

    private void func_229856_ab_() {
        this.field_217491_A.stream().filter(LivingEntity::func_70608_bn).collect(Collectors.toList()).forEach(p_241131_0_ -> p_241131_0_.func_225652_a_(false, false));
    }

    public void func_217441_a(Chunk chunkIn, int randomTickSpeed) {
        BlockPos blockpos;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        boolean flag = this.func_72896_J();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("thunder");
        if (flag && this.func_72911_I() && this.field_73012_v.nextInt(100000) == 0 && this.func_175727_C(blockpos = this.func_175736_a(this.func_217383_a(i, 0, j, 15)))) {
            boolean flag1;
            DifficultyInstance difficultyinstance = this.func_175649_E(blockpos);
            boolean bl = flag1 = this.func_82736_K().func_223586_b(GameRules.field_223601_d) && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
            if (flag1) {
                SkeletonHorseEntity skeletonhorseentity = EntityType.field_200742_ah.func_200721_a(this);
                skeletonhorseentity.func_190691_p(true);
                skeletonhorseentity.func_70873_a(0);
                skeletonhorseentity.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                this.func_217376_c((Entity)skeletonhorseentity);
            }
            LightningBoltEntity lightningboltentity = EntityType.field_200728_aG.func_200721_a(this);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_233623_a_(flag1);
            this.func_217376_c(lightningboltentity);
        }
        iprofiler.func_219895_b("iceandsnow");
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockpos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(i, 0, j, 15));
            BlockPos blockpos3 = blockpos2.func_177977_b();
            Biome biome = this.func_226691_t_(blockpos2);
            if (this.isAreaLoaded(blockpos2, 1) && biome.func_201848_a((IWorldReader)((Object)this), blockpos3)) {
                this.func_175656_a(blockpos3, Blocks.field_150432_aD.func_176223_P());
            }
            if (flag && biome.func_201850_b((IWorldReader)((Object)this), blockpos2)) {
                this.func_175656_a(blockpos2, Blocks.field_150433_aE.func_176223_P());
            }
            if (flag && this.func_226691_t_(blockpos3).func_201851_b() == Biome.RainType.RAIN) {
                this.func_180495_p(blockpos3).func_177230_c().func_176224_k(this, blockpos3);
            }
        }
        iprofiler.func_219895_b("tickBlocks");
        if (randomTickSpeed > 0) {
            for (ChunkSection chunksection : chunkIn.func_76587_i()) {
                if (chunksection == Chunk.field_186036_a || !chunksection.func_206915_b()) continue;
                int k = chunksection.func_222632_g();
                for (int l = 0; l < randomTickSpeed; ++l) {
                    FluidState fluidstate;
                    BlockPos blockpos1 = this.func_217383_a(i, k, j, 15);
                    iprofiler.func_76320_a("randomTick");
                    BlockState blockstate = chunksection.func_177485_a(blockpos1.func_177958_n() - i, blockpos1.func_177956_o() - k, blockpos1.func_177952_p() - j);
                    if (blockstate.func_204519_t()) {
                        blockstate.func_227034_b_(this, blockpos1, this.field_73012_v);
                    }
                    if ((fluidstate = blockstate.func_204520_s()).func_206890_h()) {
                        fluidstate.func_206891_b(this, blockpos1, this.field_73012_v);
                    }
                    iprofiler.func_76319_b();
                }
            }
        }
        iprofiler.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos pos) {
        BlockPos blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), this.func_217301_I(), blockpos.func_177952_p())).func_186662_g(3.0);
        List<LivingEntity> list = this.func_175647_a(LivingEntity.class, axisalignedbb, p_241115_1_ -> p_241115_1_ != null && p_241115_1_.func_70089_S() && this.func_226660_f_(p_241115_1_.func_233580_cy_()));
        if (!list.isEmpty()) {
            return list.get(this.field_73012_v.nextInt(list.size())).func_233580_cy_();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_217491_A.isEmpty()) {
            int i = 0;
            int j = 0;
            for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
                if (serverplayerentity.func_175149_v()) {
                    ++i;
                    continue;
                }
                if (!serverplayerentity.func_70608_bn()) continue;
                ++j;
            }
            this.field_73068_P = j > 0 && j >= this.field_217491_A.size() - i;
        }
    }

    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    private void func_73051_P() {
        this.field_241103_E_.func_76080_g(0);
        this.field_241103_E_.func_76084_b(false);
        this.field_241103_E_.func_76090_f(0);
        this.field_241103_E_.func_76069_a(false);
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    private void func_205339_a(NextTickListEntry<Fluid> fluidTickEntry) {
        FluidState fluidstate = this.func_204610_c(fluidTickEntry.field_180282_a);
        if (fluidstate.func_206886_c() == fluidTickEntry.func_151351_a()) {
            fluidstate.func_206880_a(this, fluidTickEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> blockTickEntry) {
        BlockState blockstate = this.func_180495_p(blockTickEntry.field_180282_a);
        if (blockstate.func_203425_a((Block)((Object)blockTickEntry.func_151351_a()))) {
            blockstate.func_227033_a_(this, blockTickEntry.field_180282_a, this.field_73012_v);
        }
    }

    public void func_217479_a(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entityIn)) {
            this.func_217464_b(entityIn);
        } else {
            entityIn.func_226286_f_(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_());
            entityIn.field_70126_B = entityIn.field_70177_z;
            entityIn.field_70127_C = entityIn.field_70125_A;
            if (entityIn.field_70175_ag) {
                ++entityIn.field_70173_aa;
                IProfiler iprofiler = this.func_217381_Z();
                iprofiler.func_194340_a(() -> entityIn.func_200600_R().getRegistryName() == null ? entityIn.func_200600_R().toString() : entityIn.func_200600_R().getRegistryName().toString());
                iprofiler.func_230035_c_("tickNonPassenger");
                if (entityIn.canUpdate()) {
                    entityIn.func_70071_h_();
                }
                iprofiler.func_76319_b();
            }
            this.func_217464_b(entityIn);
            if (entityIn.field_70175_ag) {
                for (Entity entity : entityIn.func_184188_bt()) {
                    this.func_217459_a(entityIn, entity);
                }
            }
        }
    }

    public void func_217459_a(Entity ridingEntity, Entity passengerEntity) {
        if (!passengerEntity.field_70128_L && passengerEntity.func_184187_bx() == ridingEntity) {
            if (passengerEntity instanceof PlayerEntity || this.func_72863_F().func_217204_a(passengerEntity)) {
                passengerEntity.func_226286_f_(passengerEntity.func_226277_ct_(), passengerEntity.func_226278_cu_(), passengerEntity.func_226281_cx_());
                passengerEntity.field_70126_B = passengerEntity.field_70177_z;
                passengerEntity.field_70127_C = passengerEntity.field_70125_A;
                if (passengerEntity.field_70175_ag) {
                    ++passengerEntity.field_70173_aa;
                    IProfiler iprofiler = this.func_217381_Z();
                    iprofiler.func_194340_a(() -> Registry.field_212629_r.func_177774_c(passengerEntity.func_200600_R()).toString());
                    iprofiler.func_230035_c_("tickPassenger");
                    passengerEntity.func_70098_U();
                    iprofiler.func_76319_b();
                }
                this.func_217464_b(passengerEntity);
                if (passengerEntity.field_70175_ag) {
                    for (Entity entity : passengerEntity.func_184188_bt()) {
                        this.func_217459_a(passengerEntity, entity);
                    }
                }
            }
        } else {
            passengerEntity.func_184210_p();
        }
    }

    public void func_217464_b(Entity entityIn) {
        if (entityIn.func_233578_ci_()) {
            this.func_217381_Z().func_76320_a("chunkCheck");
            int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
            int j = MathHelper.func_76128_c((double)(entityIn.func_226278_cu_() / 16.0));
            int k = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
            if (!entityIn.field_70175_ag || entityIn.field_70176_ah != i || entityIn.field_70162_ai != j || entityIn.field_70164_aj != k) {
                if (entityIn.field_70175_ag && this.func_217354_b(entityIn.field_70176_ah, entityIn.field_70164_aj)) {
                    this.func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76608_a(entityIn, entityIn.field_70162_ai);
                }
                if (!entityIn.func_233577_ch_() && !this.func_217354_b(i, k)) {
                    if (entityIn.field_70175_ag) {
                        field_147491_a.warn("Entity {} left loaded chunk area", (Object)entityIn);
                    }
                    entityIn.field_70175_ag = false;
                } else {
                    this.func_212866_a_(i, k).func_76612_a(entityIn);
                }
            }
            this.func_217381_Z().func_76319_b();
        }
    }

    @Override
    public boolean func_175660_a(PlayerEntity player, BlockPos pos) {
        return !this.field_73061_a.func_175579_a(this, pos, player) && this.func_175723_af().func_177746_a(pos);
    }

    public void func_217445_a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        if (!skipSave) {
            if (progress != null) {
                progress.func_200210_a((ITextComponent)new TranslationTextComponent("menu.savingLevel"));
            }
            this.func_73042_a();
            if (progress != null) {
                progress.func_200209_c((ITextComponent)new TranslationTextComponent("menu.savingChunks"));
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Save((IWorld)this));
            serverchunkprovider.func_217210_a(flush);
        }
    }

    private void func_73042_a() {
        if (this.field_241105_O_ != null) {
            this.field_73061_a.func_240793_aU_().func_230413_a_(this.field_241105_O_.func_186088_a());
        }
        this.func_72863_F().func_217227_h().func_212775_b();
    }

    public List<Entity> func_217482_a(@Nullable EntityType<?> entityTypeIn, Predicate<? super Entity> predicateIn) {
        ArrayList list = Lists.newArrayList();
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        for (Entity entity : this.field_217498_x.values()) {
            if (entityTypeIn != null && entity.func_200600_R() != entityTypeIn || !serverchunkprovider.func_73149_a(MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4) || !predicateIn.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public List<EnderDragonEntity> func_217439_j() {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.field_217498_x.values()) {
            if (!(entity instanceof EnderDragonEntity) || !entity.func_70089_S()) continue;
            list.add((EnderDragonEntity)entity);
        }
        return list;
    }

    public List<ServerPlayerEntity> func_217490_a(Predicate<? super ServerPlayerEntity> predicateIn) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!predicateIn.test(serverplayerentity)) continue;
            list.add(serverplayerentity);
        }
        return list;
    }

    @Nullable
    public ServerPlayerEntity func_217472_l_() {
        List<ServerPlayerEntity> list = this.func_217490_a(LivingEntity::func_70089_S);
        return list.isEmpty() ? null : list.get(this.field_73012_v.nextInt(list.size()));
    }

    public boolean func_217376_c(Entity entityIn) {
        return this.func_72838_d(entityIn);
    }

    public boolean func_217470_d(Entity entityIn) {
        return this.func_72838_d(entityIn);
    }

    public void func_217460_e(Entity entityIn) {
        boolean flag = entityIn.field_98038_p;
        entityIn.field_98038_p = true;
        this.func_217470_d(entityIn);
        entityIn.field_98038_p = flag;
        this.func_217464_b(entityIn);
    }

    public void func_217446_a(ServerPlayerEntity playerIn) {
        this.func_217448_f(playerIn);
        this.func_217464_b(playerIn);
    }

    public void func_217447_b(ServerPlayerEntity playerIn) {
        this.func_217448_f(playerIn);
        this.func_217464_b(playerIn);
    }

    public void func_217435_c(ServerPlayerEntity player) {
        this.func_217448_f(player);
    }

    public void func_217433_d(ServerPlayerEntity player) {
        this.func_217448_f(player);
    }

    private void func_217448_f(ServerPlayerEntity player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent((Entity)player, (World)this))) {
            return;
        }
        Entity entity = this.field_175741_N.get(player.func_110124_au());
        if (entity != null) {
            field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)player.func_110124_au().toString());
            entity.func_213319_R();
            this.func_217434_e((ServerPlayerEntity)entity);
        }
        this.field_217491_A.add(player);
        this.func_72854_c();
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(player.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(player.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(player);
        }
        this.func_217465_m(player);
    }

    private boolean func_72838_d(Entity entityIn) {
        if (entityIn.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entityIn.func_200600_R()));
            return false;
        }
        if (this.func_217478_l(entityIn)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, (World)this))) {
            return false;
        }
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, entityIn.field_98038_p);
        if (!(ichunk instanceof Chunk)) {
            return false;
        }
        ichunk.func_76612_a(entityIn);
        this.func_217465_m(entityIn);
        return true;
    }

    public boolean func_217440_f(Entity entityIn) {
        if (this.func_217478_l(entityIn)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, (World)this))) {
            return false;
        }
        this.func_217465_m(entityIn);
        return true;
    }

    private boolean func_217478_l(Entity entityIn) {
        UUID uuid = entityIn.func_110124_au();
        Entity entity = this.func_242105_c(uuid);
        if (entity == null) {
            return false;
        }
        field_147491_a.warn("Trying to add entity with duplicated UUID {}. Existing {}#{}, new: {}#{}", (Object)uuid, (Object)EntityType.func_200718_a(entity.func_200600_R()), (Object)entity.func_145782_y(), (Object)EntityType.func_200718_a(entityIn.func_200600_R()), (Object)entityIn.func_145782_y());
        return true;
    }

    @Nullable
    private Entity func_242105_c(UUID p_242105_1_) {
        Entity entity = this.field_175741_N.get(p_242105_1_);
        if (entity != null) {
            return entity;
        }
        if (this.field_217492_a) {
            for (Entity entity1 : this.field_217499_z) {
                if (!entity1.func_110124_au().equals(p_242105_1_)) continue;
                return entity1;
            }
        }
        return null;
    }

    public boolean func_242106_g(Entity p_242106_1_) {
        if (p_242106_1_.func_226276_cg_().anyMatch(this::func_217478_l)) {
            return false;
        }
        this.func_242417_l(p_242106_1_);
        return true;
    }

    public void func_217466_a(Chunk chunkIn) {
        this.field_147483_b.addAll(chunkIn.func_177434_r().values());
        ClassInheritanceMultiMap<Entity>[] aclassinheritancemultimap = chunkIn.func_177429_s();
        int i = aclassinheritancemultimap.length;
        for (int j = 0; j < i; ++j) {
            for (Entity entity : aclassinheritancemultimap[j]) {
                if (entity instanceof ServerPlayerEntity) continue;
                if (this.field_217492_a) {
                    throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Removing entity while ticking!"));
                }
                this.field_217498_x.remove(entity.func_145782_y());
                this.func_217484_g(entity);
            }
        }
    }

    @Deprecated
    public void func_217484_g(Entity entityIn) {
        this.removeEntityComplete(entityIn, false);
    }

    public void removeEntityComplete(Entity entityIn, boolean keepData) {
        if (entityIn instanceof EnderDragonEntity) {
            for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entityIn).func_213404_dT()) {
                enderdragonpartentity.remove(keepData);
            }
        }
        entityIn.remove(keepData);
        this.field_175741_N.remove(entityIn.func_110124_au());
        this.func_72863_F().func_217226_b(entityIn);
        if (entityIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
            this.field_217491_A.remove((Object)serverplayerentity);
        }
        this.func_96441_U().func_181140_a(entityIn);
        if (entityIn instanceof MobEntity) {
            this.field_217495_I.remove(((MobEntity)entityIn).func_70661_as());
        }
        entityIn.onRemovedFromWorld();
        MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveWorldEvent(entityIn, (World)this));
    }

    private void func_217465_m(Entity entityIn) {
        if (this.field_217492_a) {
            this.field_217499_z.add(entityIn);
        } else {
            this.field_217498_x.put(entityIn.func_145782_y(), (Object)entityIn);
            if (entityIn instanceof EnderDragonEntity) {
                for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entityIn).func_213404_dT()) {
                    this.field_217498_x.put(enderdragonpartentity.func_145782_y(), (Object)enderdragonpartentity);
                }
            }
            this.field_175741_N.put(entityIn.func_110124_au(), entityIn);
            this.func_72863_F().func_217230_c(entityIn);
            if (entityIn instanceof MobEntity) {
                this.field_217495_I.add(((MobEntity)entityIn).func_70661_as());
            }
        }
        entityIn.onAddedToWorld();
    }

    public void func_217467_h(Entity entityIn) {
        this.removeEntity(entityIn, false);
    }

    public void removeEntity(Entity entityIn, boolean keepData) {
        if (this.field_217492_a) {
            throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Removing entity while ticking!"));
        }
        this.func_217454_n(entityIn);
        this.field_217498_x.remove(entityIn.func_145782_y());
        this.removeEntityComplete(entityIn, keepData);
    }

    private void func_217454_n(Entity entityIn) {
        IChunk ichunk = this.func_217353_a(entityIn.field_70176_ah, entityIn.field_70164_aj, ChunkStatus.field_222617_m, false);
        if (ichunk instanceof Chunk) {
            ((Chunk)ichunk).func_76622_b(entityIn);
        }
    }

    public void func_217434_e(ServerPlayerEntity player) {
        this.removePlayer(player, false);
    }

    public void removePlayer(ServerPlayerEntity player, boolean keepData) {
        player.remove(keepData);
        this.removeEntity(player, keepData);
        this.func_72854_c();
    }

    @Override
    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        for (ServerPlayerEntity serverplayerentity : this.field_73061_a.func_184103_al().func_181057_v()) {
            double d2;
            double d1;
            double d0;
            if (serverplayerentity == null || serverplayerentity.field_70170_p != this || serverplayerentity.func_145782_y() == breakerId || !((d0 = (double)pos.func_177958_n() - serverplayerentity.func_226277_ct_()) * d0 + (d1 = (double)pos.func_177956_o() - serverplayerentity.func_226278_cu_()) * d1 + (d2 = (double)pos.func_177952_p() - serverplayerentity.func_226281_cx_()) * d2 < 1024.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SAnimateBlockBreakPacket(breakerId, pos, progress));
        }
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)player, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(player, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.func_234923_W_(), (IPacket<?>)new SPlaySoundEffectPacket(soundIn, category, x, y, z, volume, pitch));
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)playerIn, (SoundEvent)eventIn, (SoundCategory)categoryIn, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        eventIn = event.getSound();
        categoryIn = event.getCategory();
        volume = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(playerIn, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.func_234923_W_(), (IPacket<?>)new SSpawnMovingSoundEffectPacket(eventIn, categoryIn, entityIn, volume, pitch));
    }

    @Override
    public void func_175669_a(int id, BlockPos pos, int data) {
        this.field_73061_a.func_184103_al().func_148540_a((IPacket<?>)new SPlaySoundEventPacket(id, pos, data, true));
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        this.field_73061_a.func_184103_al().func_148543_a(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, this.func_234923_W_(), (IPacket<?>)new SPlaySoundEventPacket(type, pos, data, false));
    }

    @Override
    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.func_72863_F().func_217217_a(pos);
        VoxelShape voxelshape = oldState.func_196952_d((IBlockReader)((Object)this), pos);
        VoxelShape voxelshape1 = newState.func_196952_d((IBlockReader)((Object)this), pos);
        if (VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (IBooleanFunction)IBooleanFunction.field_223236_g_)) {
            for (PathNavigator pathnavigator : this.field_217495_I) {
                if (pathnavigator.func_188553_i()) continue;
                pathnavigator.func_220970_c(pos);
            }
        }
    }

    @Override
    public void func_72960_a(Entity entityIn, byte state) {
        this.func_72863_F().func_217216_a(entityIn, (IPacket)new SEntityStatusPacket(entityIn, state));
    }

    public ServerChunkProvider func_72863_F() {
        return this.field_241102_C_;
    }

    @Override
    public Explosion func_230546_a_(@Nullable Entity p_230546_1_, @Nullable DamageSource p_230546_2_, @Nullable ExplosionContext p_230546_3_, double p_230546_4_, double p_230546_6_, double p_230546_8_, float p_230546_10_, boolean p_230546_11_, Explosion.Mode p_230546_12_) {
        Explosion explosion = new Explosion(this, p_230546_1_, p_230546_2_, p_230546_3_, p_230546_4_, p_230546_6_, p_230546_8_, p_230546_10_, p_230546_11_, p_230546_12_);
        if (ForgeEventFactory.onExplosionStart((World)this, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (p_230546_12_ == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!(serverplayerentity.func_70092_e(p_230546_4_, p_230546_6_, p_230546_8_) < 4096.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SExplosionPacket(p_230546_4_, p_230546_6_, p_230546_8_, p_230546_10_, explosion.func_180343_e(), explosion.func_77277_b().get((Object)serverplayerentity)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.field_147490_S.add((Object)new BlockEventData(pos, blockIn, eventID, eventParam));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockeventdata = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockeventdata)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockeventdata.func_180328_a().func_177958_n(), blockeventdata.func_180328_a().func_177956_o(), blockeventdata.func_180328_a().func_177952_p(), 64.0, this.func_234923_W_(), (IPacket<?>)new SBlockActionPacket(blockeventdata.func_180328_a(), blockeventdata.func_151337_f(), blockeventdata.func_151339_d(), blockeventdata.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData event) {
        BlockState blockstate = this.func_180495_p(event.func_180328_a());
        return blockstate.func_203425_a(event.func_151337_f()) ? blockstate.func_235728_a_(this, event.func_180328_a(), event.func_151339_d(), event.func_151338_e()) : false;
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_73061_a.func_240792_aT_();
    }

    public <T extends IParticleData> int func_195598_a(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        SSpawnParticlePacket sspawnparticlepacket = new SSpawnParticlePacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        int i = 0;
        for (int j = 0; j < this.field_217491_A.size(); ++j) {
            ServerPlayerEntity serverplayerentity = this.field_217491_A.get(j);
            if (!this.func_195601_a(serverplayerentity, false, posX, posY, posZ, (IPacket<?>)sspawnparticlepacket)) continue;
            ++i;
        }
        return i;
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity player, T type, boolean longDistance, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        SSpawnParticlePacket ipacket = new SSpawnParticlePacket(type, longDistance, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        return this.func_195601_a(player, longDistance, posX, posY, posZ, (IPacket<?>)ipacket);
    }

    private boolean func_195601_a(ServerPlayerEntity player, boolean longDistance, double posX, double posY, double posZ, IPacket<?> packet) {
        if (player.func_71121_q() != this) {
            return false;
        }
        BlockPos blockpos = player.func_233580_cy_();
        if (blockpos.func_218137_a((IPosition)new Vector3d(posX, posY, posZ), longDistance ? 512.0 : 32.0)) {
            player.field_71135_a.func_147359_a(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)((Object)this.field_217498_x.get(id));
    }

    @Nullable
    public Entity func_217461_a(UUID uniqueId) {
        return this.field_175741_N.get(uniqueId);
    }

    @Nullable
    public BlockPos func_241117_a_(Structure<?> p_241117_1_, BlockPos p_241117_2_, int p_241117_3_, boolean p_241117_4_) {
        return !this.field_73061_a.func_240793_aU_().func_230418_z_().func_236222_c_() ? null : this.func_72863_F().func_201711_g().func_235956_a_(this, p_241117_1_, p_241117_2_, p_241117_3_, p_241117_4_);
    }

    @Nullable
    public BlockPos func_241116_a_(Biome p_241116_1_, BlockPos p_241116_2_, int p_241116_3_, int p_241116_4_) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_230321_a_(p_241116_2_.func_177958_n(), p_241116_2_.func_177956_o(), p_241116_2_.func_177952_p(), p_241116_3_, p_241116_4_, p_242102_1_ -> p_242102_1_ == p_241116_1_, this.field_73012_v, true);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public ITagCollectionSupplier func_205772_D() {
        return this.field_73061_a.func_244266_aF();
    }

    @Override
    public boolean func_217402_u() {
        return this.field_73058_d;
    }

    public DynamicRegistries func_241828_r() {
        return this.field_73061_a.func_244267_aX();
    }

    public DimensionSavedDataManager func_217481_x() {
        return this.func_72863_F().func_217227_h();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String mapName) {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215753_b(() -> new MapData(mapName), mapName);
    }

    @Override
    public void func_217399_a(MapData mapDataIn) {
        this.func_73046_m().func_241755_D_().func_217481_x().func_215757_a((WorldSavedData)mapDataIn);
    }

    @Override
    public int func_217395_y() {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(MapIdTracker::new, "idcounts").func_215162_a();
    }

    public void func_241124_a__(BlockPos p_241124_1_, float p_241124_2_) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(this.field_72986_A.func_76079_c(), 0, this.field_72986_A.func_76074_e()));
        this.field_72986_A.func_176143_a(p_241124_1_, p_241124_2_);
        this.func_72863_F().func_217222_b(TicketType.field_219488_a, chunkpos, 11, (Object)Unit.INSTANCE);
        this.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(p_241124_1_), 11, (Object)Unit.INSTANCE);
        this.func_73046_m().func_184103_al().func_148540_a((IPacket<?>)new SWorldSpawnChangedPacket(p_241124_1_, p_241124_2_));
    }

    public BlockPos func_241135_u_() {
        BlockPos blockpos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_230316_a_(), 0.0, this.func_175723_af().func_230317_b_()));
        }
        return blockpos;
    }

    public float func_242107_v() {
        return this.field_72986_A.func_241860_d();
    }

    public LongSet func_217469_z() {
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        return forcedchunkssavedata != null ? LongSets.unmodifiable((LongSet)forcedchunkssavedata.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_217458_b(int chunkX, int chunkZ, boolean add) {
        boolean flag;
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        long i = chunkpos.func_201841_a();
        if (add) {
            flag = forcedchunkssavedata.func_212438_a().add(i);
            if (flag) {
                this.func_212866_a_(chunkX, chunkZ);
            }
        } else {
            flag = forcedchunkssavedata.func_212438_a().remove(i);
        }
        forcedchunkssavedata.func_76186_a(flag);
        if (flag) {
            this.func_72863_F().func_217206_a(chunkpos, add);
        }
        return flag;
    }

    public List<ServerPlayerEntity> func_217369_A() {
        return this.field_217491_A;
    }

    @Override
    public void func_217393_a(BlockPos pos, BlockState blockStateIn, BlockState newState) {
        Optional<PointOfInterestType> optional1;
        Optional<PointOfInterestType> optional = PointOfInterestType.func_221047_b(blockStateIn);
        if (!Objects.equals(optional, optional1 = PointOfInterestType.func_221047_b(newState))) {
            BlockPos blockpos = pos.func_185334_h();
            optional.ifPresent(p_241130_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219140_a(blockpos);
                DebugPacketSender.func_218805_b((ServerWorld)this, (BlockPos)blockpos);
            }));
            optional1.ifPresent(p_217476_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219135_a(blockpos, p_217476_2_);
                DebugPacketSender.func_218799_a((ServerWorld)this, (BlockPos)blockpos);
            }));
        }
    }

    public PointOfInterestManager func_217443_B() {
        return this.func_72863_F().func_217231_i();
    }

    public boolean func_217483_b_(BlockPos pos) {
        return this.func_241119_a_(pos, 1);
    }

    public boolean func_222887_a(SectionPos pos) {
        return this.func_217483_b_(pos.func_218160_t());
    }

    public boolean func_241119_a_(BlockPos p_241119_1_, int p_241119_2_) {
        if (p_241119_2_ > 6) {
            return false;
        }
        return this.func_217486_a(SectionPos.func_218167_a((BlockPos)p_241119_1_)) <= p_241119_2_;
    }

    public int func_217486_a(SectionPos pos) {
        return this.func_217443_B().func_219150_a(pos);
    }

    public RaidManager func_217452_C() {
        return this.field_217494_c;
    }

    @Nullable
    public Raid func_217475_c_(BlockPos pos) {
        return this.field_217494_c.func_215174_a(pos, 9216);
    }

    public boolean func_217455_d_(BlockPos pos) {
        return this.func_217475_c_(pos) != null;
    }

    public void func_217489_a(IReputationType type, Entity target, IReputationTracking host) {
        host.func_213739_a(type, target);
    }

    public void func_225322_a(Path pathIn) throws IOException {
        Object entry2;
        Object worldentityspawner$entitydensitymanager;
        ChunkManager chunkmanager = this.func_72863_F().field_217237_a;
        try (BufferedWriter writer = Files.newBufferedWriter(pathIn.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format("spawning_chunks: %d\n", chunkmanager.func_219246_e().func_219358_b()));
            worldentityspawner$entitydensitymanager = this.func_72863_F().func_241101_k_();
            if (worldentityspawner$entitydensitymanager != null) {
                for (Object entry2 : ((WorldEntitySpawner.EntityDensityManager)worldentityspawner$entitydensitymanager).func_234995_b_().object2IntEntrySet()) {
                    writer.write(String.format("spawn_count.%s: %d\n", ((EntityClassification)((Object)entry2.getKey())).func_220363_a(), entry2.getIntValue()));
                }
            }
            writer.write(String.format("entities: %d\n", this.field_217498_x.size()));
            writer.write(String.format("block_entities: %d\n", this.field_147482_g.size()));
            writer.write(String.format("block_ticks: %d\n", this.func_205220_G_().func_225420_a()));
            writer.write(String.format("fluid_ticks: %d\n", this.func_205219_F_().func_225420_a()));
            writer.write("distance_manager: " + chunkmanager.func_219246_e().func_225412_c() + "\n");
            writer.write(String.format("pending_tasks: %d\n", this.func_72863_F().func_225314_f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.func_72914_a(crashreport);
        BufferedWriter writer1 = Files.newBufferedWriter(pathIn.resolve("example_crash.txt"), new OpenOption[0]);
        worldentityspawner$entitydensitymanager = null;
        try {
            writer1.write(crashreport.func_71502_e());
        }
        catch (Throwable throwable) {
            worldentityspawner$entitydensitymanager = throwable;
            throw throwable;
        }
        finally {
            if (writer1 != null) {
                if (worldentityspawner$entitydensitymanager != null) {
                    try {
                        ((Writer)writer1).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)worldentityspawner$entitydensitymanager).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)writer1).close();
                }
            }
        }
        Path path = pathIn.resolve("chunks.csv");
        BufferedWriter writer2 = Files.newBufferedWriter(path, new OpenOption[0]);
        Object object = null;
        try {
            chunkmanager.func_225406_a(writer2);
        }
        catch (Throwable entry2) {
            object = entry2;
            throw entry2;
        }
        finally {
            if (writer2 != null) {
                if (object != null) {
                    try {
                        ((Writer)writer2).close();
                    }
                    catch (Throwable entry2) {
                        ((Throwable)object).addSuppressed(entry2);
                    }
                } else {
                    ((Writer)writer2).close();
                }
            }
        }
        Path path1 = pathIn.resolve("entities.csv");
        BufferedWriter writer3 = Files.newBufferedWriter(path1, new OpenOption[0]);
        entry2 = null;
        try {
            ServerWorld.func_225320_a(writer3, (Iterable<Entity>)this.field_217498_x.values());
        }
        catch (Throwable throwable) {
            entry2 = throwable;
            throw throwable;
        }
        finally {
            if (writer3 != null) {
                if (entry2 != null) {
                    try {
                        ((Writer)writer3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entry2).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)writer3).close();
                }
            }
        }
        Path path2 = pathIn.resolve("block_entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.func_225321_a(writer4);
        }
    }

    private static void func_225320_a(Writer writerIn, Iterable<Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("uuid").func_225423_a("type").func_225423_a("alive").func_225423_a("display_name").func_225423_a("custom_name").func_225422_a(writerIn);
        for (Entity entity : entities) {
            ITextComponent itextcomponent = entity.func_200201_e();
            ITextComponent itextcomponent1 = entity.func_145748_c_();
            csvwriter.func_225426_a(new Object[]{entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_110124_au(), Registry.field_212629_r.func_177774_c(entity.func_200600_R()), entity.func_70089_S(), itextcomponent1.getString(), itextcomponent != null ? itextcomponent.getString() : null});
        }
    }

    private void func_225321_a(Writer writerIn) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("type").func_225422_a(writerIn);
        for (TileEntity tileentity : this.field_147482_g) {
            BlockPos blockpos = tileentity.func_174877_v();
            csvwriter.func_225426_a(new Object[]{blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), Registry.field_212626_o.func_177774_c(tileentity.func_200662_C())});
        }
    }

    @VisibleForTesting
    public void func_229854_a_(MutableBoundingBox boundingBox) {
        this.field_147490_S.removeIf(p_241118_1_ -> boundingBox.func_175898_b((Vector3i)p_241118_1_.func_180328_a()));
    }

    public void func_230547_a_(BlockPos p_230547_1_, Block p_230547_2_) {
        if (!this.func_234925_Z_()) {
            this.func_195593_d(p_230547_1_, p_230547_2_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public Iterable<Entity> func_241136_z_() {
        return Iterables.unmodifiableIterable((Iterable)this.field_217498_x.values());
    }

    public String toString() {
        return "ServerLevel[" + this.field_241103_E_.func_76065_j() + "]";
    }

    public boolean func_241109_A_() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236228_i_();
    }

    public long func_72905_C() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236221_b_();
    }

    @Nullable
    public DragonFightManager func_241110_C_() {
        return this.field_241105_O_;
    }

    public Stream<? extends StructureStart<?>> func_241827_a(SectionPos p_241827_1_, Structure<?> p_241827_2_) {
        return this.func_241112_a_().func_235011_a_(p_241827_1_, p_241827_2_);
    }

    public ServerWorld func_201672_e() {
        return this;
    }

    public static void func_241121_a_(ServerWorld p_241121_0_) {
        BlockPos blockpos = field_241108_a_;
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o() - 2;
        int k = blockpos.func_177952_p();
        BlockPos.func_191531_b((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(p_241122_1_ -> p_241121_0_.func_175656_a((BlockPos)p_241122_1_, Blocks.field_150343_Z.func_176223_P()));
        BlockPos.func_191531_b((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(p_241122_1_ -> p_241121_0_.func_175656_a((BlockPos)p_241122_1_, Blocks.field_150343_Z.func_176223_P()));
    }

    protected void initCapabilities() {
        this.gatherCapabilities();
        this.capabilityData = this.func_217481_x().func_215752_a(() -> new WorldCapabilityData((INBTSerializable)this.getCapabilities()), "capabilities");
        this.capabilityData.setCapabilities((INBTSerializable)this.getCapabilities());
    }

    public Stream<Entity> getEntities() {
        return this.field_217498_x.values().stream();
    }
}

