/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DebugChunkGenerator
extends ChunkGenerator {
    public static final Codec<DebugChunkGenerator> field_236066_e_ = RegistryLookupCodec.func_244331_a(Registry.field_239720_u_).xmap(DebugChunkGenerator::new, DebugChunkGenerator::func_242727_g).stable().codec();
    private static List<BlockState> field_177464_a = StreamSupport.stream(Registry.field_212618_g.spliterator(), false).flatMap(p_236067_0_ -> p_236067_0_.func_176194_O().func_177619_a().stream()).collect(Collectors.toList());
    private static int field_177462_b = MathHelper.func_76123_f((float)MathHelper.func_76129_c((float)field_177464_a.size()));
    private static int field_181039_c = MathHelper.func_76123_f((float)((float)field_177464_a.size() / (float)field_177462_b));
    protected static final BlockState field_185934_a = Blocks.field_150350_a.func_176223_P();
    protected static final BlockState field_185935_b = Blocks.field_180401_cv.func_176223_P();
    private final Registry<Biome> field_242726_j;

    public DebugChunkGenerator(Registry<Biome> p_i241974_1_) {
        super((BiomeProvider)new SingleBiomeProvider(p_i241974_1_.func_243576_d(Biomes.field_76772_c)), new DimensionStructuresSettings(false));
        this.field_242726_j = p_i241974_1_;
    }

    public Registry<Biome> func_242727_g() {
        return this.field_242726_j;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return field_236066_e_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long p_230349_1_) {
        return this;
    }

    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
    }

    public void func_230350_a_(long p_230350_1_, BiomeManager p_230350_3_, IChunk p_230350_4_, GenerationStage.Carving p_230350_5_) {
    }

    public void func_230351_a_(WorldGenRegion p_230351_1_, StructureManager p_230351_2_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = p_230351_1_.func_201679_a();
        int j = p_230351_1_.func_201680_b();
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (i << 4) + k;
                int j1 = (j << 4) + l;
                p_230351_1_.func_180501_a((BlockPos)blockpos$mutable.func_181079_c(i1, 60, j1), field_185935_b, 2);
                BlockState blockstate = DebugChunkGenerator.func_177461_b(i1, j1);
                if (blockstate == null) continue;
                p_230351_1_.func_180501_a((BlockPos)blockpos$mutable.func_181079_c(i1, 70, j1), blockstate, 2);
            }
        }
    }

    public void func_230352_b_(IWorld p_230352_1_, StructureManager p_230352_2_, IChunk p_230352_3_) {
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        return 0;
    }

    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return new Blockreader(new BlockState[0]);
    }

    public static BlockState func_177461_b(int p_177461_0_, int p_177461_1_) {
        int i;
        BlockState blockstate = field_185934_a;
        if (p_177461_0_ > 0 && p_177461_1_ > 0 && p_177461_0_ % 2 != 0 && p_177461_1_ % 2 != 0 && (p_177461_0_ /= 2) <= field_177462_b && (p_177461_1_ /= 2) <= field_181039_c && (i = MathHelper.func_76130_a((int)(p_177461_0_ * field_177462_b + p_177461_1_))) < field_177464_a.size()) {
            blockstate = field_177464_a.get(i);
        }
        return blockstate;
    }

    public static void initValidStates() {
        field_177464_a = StreamSupport.stream(Registry.field_212618_g.spliterator(), false).flatMap(block -> block.func_176194_O().func_177619_a().stream()).collect(Collectors.toList());
        field_177462_b = MathHelper.func_76123_f((float)MathHelper.func_76129_c((float)field_177464_a.size()));
        field_181039_c = MathHelper.func_76123_f((float)(field_177464_a.size() / field_177462_b));
    }
}

