/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeTagHandler;

public class TagRegistryManager {
    private static final Map<ResourceLocation, TagRegistry<?>> field_242190_a = Maps.newHashMap();

    public static <T> TagRegistry<T> func_242196_a(ResourceLocation p_242196_0_, Function<ITagCollectionSupplier, ITagCollection<T>> p_242196_1_) {
        TagRegistry<T> tagregistry = new TagRegistry<T>(p_242196_1_);
        TagRegistry<T> tagregistry1 = field_242190_a.putIfAbsent(p_242196_0_, tagregistry);
        if (tagregistry1 != null) {
            throw new IllegalStateException("Duplicate entry for static tag collection: " + p_242196_0_);
        }
        return tagregistry;
    }

    public static void func_242193_a(ITagCollectionSupplier p_242193_0_) {
        field_242190_a.values().forEach(p_242194_1_ -> p_242194_1_.func_242188_a(p_242193_0_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_242191_a() {
        field_242190_a.values().forEach(TagRegistry::func_232932_a_);
    }

    public static Multimap<ResourceLocation, ResourceLocation> func_242198_b(ITagCollectionSupplier p_242198_0_) {
        HashMultimap multimap = HashMultimap.create();
        field_242190_a.forEach((arg_0, arg_1) -> TagRegistryManager.lambda$func_242198_b$1((Multimap)multimap, p_242198_0_, arg_0, arg_1));
        return multimap;
    }

    public static void func_242197_b() {
        TagRegistry[] atagregistry = new TagRegistry[]{BlockTags.field_199899_c, ItemTags.field_199906_c, FluidTags.field_206961_c, EntityTypeTags.field_219766_c};
        boolean flag = Stream.of(atagregistry).anyMatch(p_242192_0_ -> !field_242190_a.containsValue(p_242192_0_));
        if (flag) {
            throw new IllegalStateException("Missing helper registrations");
        }
    }

    @Nullable
    public static TagRegistry<?> get(ResourceLocation rl) {
        return field_242190_a.get(rl);
    }

    public static Multimap<ResourceLocation, ResourceLocation> validateVanillaTags(ITagCollectionSupplier tagCollectionSupplier) {
        HashMultimap missingTags = HashMultimap.create();
        for (Map.Entry<ResourceLocation, TagRegistry<?>> entry : field_242190_a.entrySet()) {
            if (ForgeTagHandler.getCustomTagTypeNames().contains(entry.getKey())) continue;
            missingTags.putAll((Object)entry.getKey(), entry.getValue().func_242189_b(tagCollectionSupplier));
        }
        return missingTags;
    }

    public static void fetchCustomTagTypes(ITagCollectionSupplier tagCollectionSupplier) {
        ForgeTagHandler.getCustomTagTypeNames().forEach(tagRegistry -> field_242190_a.get(tagRegistry).func_242188_a(tagCollectionSupplier));
    }

    private static /* synthetic */ void lambda$func_242198_b$1(Multimap multimap, ITagCollectionSupplier p_242198_0_, ResourceLocation p_242195_2_, TagRegistry p_242195_3_) {
        multimap.putAll((Object)p_242195_2_, p_242195_3_.func_242189_b(p_242198_0_));
    }
}

