/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IResourceManager {
    public Set<String> func_199001_a();

    public IResource func_199002_a(ResourceLocation var1) throws IOException;

    public boolean func_219533_b(ResourceLocation var1);

    public List<IResource> func_199004_b(ResourceLocation var1) throws IOException;

    public Collection<ResourceLocation> func_199003_a(String var1, Predicate<String> var2);

    @OnlyIn(value=Dist.CLIENT)
    public Stream<IResourcePack> func_230232_b_();

    public static enum Instance implements IResourceManager
    {
        INSTANCE;


        @Override
        public Set<String> func_199001_a() {
            return ImmutableSet.of();
        }

        @Override
        public IResource func_199002_a(ResourceLocation resourceLocationIn) throws IOException {
            throw new FileNotFoundException(resourceLocationIn.toString());
        }

        @Override
        public boolean func_219533_b(ResourceLocation p_219533_1_) {
            return false;
        }

        @Override
        public List<IResource> func_199004_b(ResourceLocation resourceLocationIn) {
            return ImmutableList.of();
        }

        @Override
        public Collection<ResourceLocation> func_199003_a(String pathIn, Predicate<String> filter) {
            return ImmutableSet.of();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Stream<IResourcePack> func_230232_b_() {
            return Stream.of(new IResourcePack[0]);
        }
    }
}

