/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    private LootingEnchantBonus(ILootCondition[] conditions, RandomValueRange countIn, int limitIn) {
        super(conditions);
        this.field_186563_a = countIn;
        this.field_189971_b = limitIn;
    }

    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237434_g_;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216284_d);
    }

    private boolean func_215917_b() {
        return this.field_189971_b > 0;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)((Object)context.func_216031_c(LootParameters.field_216284_d));
        if (entity instanceof LivingEntity) {
            int i = context.getLootingModifier();
            if (i == 0) {
                return stack;
            }
            float f = (float)i * this.field_186563_a.func_186507_b(context.func_216032_b());
            stack.func_190917_f(Math.round(f));
            if (this.func_215917_b() && stack.func_190916_E() > this.field_189971_b) {
                stack.func_190920_e(this.field_189971_b);
            }
        }
        return stack;
    }

    public static Builder func_215915_a(RandomValueRange range) {
        return new Builder(range);
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        public void func_230424_a_(JsonObject p_230424_1_, LootingEnchantBonus p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.func_230424_a_(p_230424_1_, (LootFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.add("count", p_230424_3_.serialize((Object)p_230424_2_.field_186563_a));
            if (p_230424_2_.func_215917_b()) {
                p_230424_1_.add("limit", p_230424_3_.serialize((Object)p_230424_2_.field_189971_b));
            }
        }

        public LootingEnchantBonus func_186530_b(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            int i = JSONUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0);
            return new LootingEnchantBonus(conditionsIn, (RandomValueRange)JSONUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), i);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final RandomValueRange field_216073_a;
        private int field_216074_b = 0;

        public Builder(RandomValueRange p_i50932_1_) {
            this.field_216073_a = p_i50932_1_;
        }

        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_216072_a(int p_216072_1_) {
            this.field_216074_b = p_216072_1_;
            return this;
        }

        public ILootFunction func_216052_b() {
            return new LootingEnchantBonus(this.func_216053_g(), this.field_216073_a, this.field_216074_b);
        }
    }
}

