/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class SingleItemRecipe
implements IRecipe<IInventory> {
    protected final Ingredient field_222131_a;
    protected final ItemStack field_222132_b;
    private final IRecipeType<?> field_222135_e;
    private final IRecipeSerializer<?> field_222136_f;
    protected final ResourceLocation field_222133_c;
    protected final String field_222134_d;

    public SingleItemRecipe(IRecipeType<?> type, IRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, ItemStack result) {
        this.field_222135_e = type;
        this.field_222136_f = serializer;
        this.field_222133_c = id;
        this.field_222134_d = group;
        this.field_222131_a = ingredient;
        this.field_222132_b = result;
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return this.field_222135_e;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return this.field_222136_f;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.field_222133_c;
    }

    @Override
    public String func_193358_e() {
        return this.field_222134_d;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.field_222132_b;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.field_222131_a);
        return nonnulllist;
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.field_222132_b.func_77946_l();
    }

    public static class Serializer<T extends SingleItemRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> field_222180_t;

        protected Serializer(IRecipeFactory<T> factory) {
            this.field_222180_t = factory;
        }

        @Override
        public T func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            int i = JSONUtils.func_151203_m((JsonObject)json, (String)"count");
            ItemStack itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(s1)), i);
            return this.field_222180_t.create(recipeId, s, ingredient, itemstack);
        }

        @Override
        public T func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b(buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return this.field_222180_t.create(recipeId, s, ingredient, itemstack);
        }

        @Override
        public void func_199427_a_(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((SingleItemRecipe)recipe).field_222134_d);
            ((SingleItemRecipe)recipe).field_222131_a.func_199564_a(buffer);
            buffer.func_150788_a(((SingleItemRecipe)recipe).field_222132_b);
        }

        static interface IRecipeFactory<T extends SingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

