/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.fml.DatagenModLoader;

public class Ingredient
implements Predicate<ItemStack> {
    private static final Set<Ingredient> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    public static final Ingredient field_193370_a = new Ingredient(Stream.empty());
    private final IItemList[] field_199807_b;
    private ItemStack[] field_193371_b;
    private IntList field_194140_c;
    private final boolean isSimple;
    private final boolean isVanilla = this.getClass() == Ingredient.class;

    public static void invalidateAll() {
        INSTANCES.stream().filter(e -> e != null).forEach(i -> i.invalidate());
    }

    protected Ingredient(Stream<? extends IItemList> itemLists) {
        this.field_199807_b = (IItemList[])itemLists.toArray(IItemList[]::new);
        this.isSimple = !DatagenModLoader.isRunningDataGen() && !Arrays.stream(this.field_199807_b).anyMatch(list -> list.func_199799_a().stream().anyMatch(stack -> stack.func_77973_b().isDamageable((ItemStack)((Object)((Object)stack)))));
        INSTANCES.add(this);
    }

    public ItemStack[] func_193365_a() {
        this.func_199806_d();
        return this.field_193371_b;
    }

    private void func_199806_d() {
        if (this.field_193371_b == null) {
            this.field_193371_b = (ItemStack[])Arrays.stream(this.field_199807_b).flatMap(p_209359_0_ -> p_209359_0_.func_199799_a().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable ItemStack p_test_1_) {
        if (p_test_1_ == null) {
            return false;
        }
        this.func_199806_d();
        if (this.field_193371_b.length == 0) {
            return p_test_1_.func_190926_b();
        }
        for (ItemStack itemstack : this.field_193371_b) {
            if (itemstack.func_77973_b() != p_test_1_.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public IntList func_194139_b() {
        if (this.field_194140_c == null) {
            this.func_199806_d();
            this.field_194140_c = new IntArrayList(this.field_193371_b.length);
            for (ItemStack itemstack : this.field_193371_b) {
                this.field_194140_c.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.field_194140_c.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.field_194140_c;
    }

    public final void func_199564_a(PacketBuffer buffer) {
        this.func_199806_d();
        if (!this.isVanilla()) {
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)this);
            return;
        }
        buffer.func_150787_b(this.field_193371_b.length);
        for (int i = 0; i < this.field_193371_b.length; ++i) {
            buffer.func_150788_a(this.field_193371_b[i]);
        }
    }

    public JsonElement func_200304_c() {
        if (this.field_199807_b.length == 1) {
            return this.field_199807_b[0].func_200303_b();
        }
        JsonArray jsonarray = new JsonArray();
        for (IItemList ingredient$iitemlist : this.field_199807_b) {
            jsonarray.add((JsonElement)ingredient$iitemlist.func_200303_b());
        }
        return jsonarray;
    }

    public boolean func_203189_d() {
        return !(this.field_199807_b.length != 0 || this.field_193371_b != null && this.field_193371_b.length != 0 || this.field_194140_c != null && !this.field_194140_c.isEmpty());
    }

    protected void invalidate() {
        this.field_193371_b = null;
        this.field_194140_c = null;
    }

    public boolean isSimple() {
        return this.isSimple || this == field_193370_a;
    }

    public final boolean isVanilla() {
        return this.isVanilla;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        if (!this.isVanilla()) {
            throw new IllegalStateException("Modders must implement Ingredient.getSerializer in their custom Ingredients: " + this);
        }
        return VanillaIngredientSerializer.INSTANCE;
    }

    public static Ingredient func_209357_a(Stream<? extends IItemList> stream) {
        Ingredient ingredient = new Ingredient(stream);
        return ingredient.field_199807_b.length == 0 ? field_193370_a : ingredient;
    }

    public static Ingredient func_199804_a(IItemProvider ... itemsIn) {
        return Ingredient.func_234819_a_(Arrays.stream(itemsIn).map(ItemStack::new));
    }

    public static Ingredient func_193369_a(ItemStack ... stacks) {
        return Ingredient.func_234819_a_(Arrays.stream(stacks));
    }

    public static Ingredient func_234819_a_(Stream<ItemStack> p_234819_0_) {
        return Ingredient.func_209357_a(p_234819_0_.filter(p_234824_0_ -> !p_234824_0_.func_190926_b()).map(p_209356_0_ -> new SingleItemList((ItemStack)((Object)p_209356_0_))));
    }

    public static Ingredient func_199805_a(ITag<Item> tagIn) {
        return Ingredient.func_209357_a(Stream.of(new TagList(tagIn)));
    }

    public static Ingredient func_199566_b(PacketBuffer buffer) {
        int i = buffer.func_150792_a();
        if (i == -1) {
            return CraftingHelper.getIngredient((ResourceLocation)buffer.func_192575_l(), (PacketBuffer)buffer);
        }
        return Ingredient.func_209357_a(Stream.generate(() -> new SingleItemList(buffer.func_150791_c())).limit(i));
    }

    public static Ingredient func_199802_a(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            Ingredient ret = CraftingHelper.getIngredient((JsonElement)json);
            if (ret != null) {
                return ret;
            }
            if (json.isJsonObject()) {
                return Ingredient.func_209357_a(Stream.of(Ingredient.func_199803_a(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return Ingredient.func_209357_a(StreamSupport.stream(jsonarray.spliterator(), false).map(p_209355_0_ -> Ingredient.func_199803_a(JSONUtils.func_151210_l((JsonElement)p_209355_0_, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static IItemList func_199803_a(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item"));
            Item item = (Item)((Object)Registry.field_212630_s.func_241873_b(resourcelocation1).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + resourcelocation1 + "'")));
            return new SingleItemList(new ItemStack(item));
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            ITag<Item> itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourcelocation);
            if (itag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + resourcelocation + "'");
            }
            return new TagList(itag);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static Ingredient merge(Collection<Ingredient> parts) {
        return Ingredient.func_209357_a(parts.stream().flatMap(i -> Arrays.stream(i.field_199807_b)));
    }

    public static class TagList
    implements IItemList {
        private final ITag<Item> field_199800_a;

        public TagList(ITag<Item> tagIn) {
            this.field_199800_a = tagIn;
        }

        @Override
        public Collection<ItemStack> func_199799_a() {
            ArrayList list = Lists.newArrayList();
            for (Item item : this.field_199800_a.func_230236_b_()) {
                list.add(new ItemStack(item));
            }
            if (list.size() == 0 && !((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue()) {
                list.add(new ItemStack(Blocks.field_180401_cv).func_200302_a((ITextComponent)new StringTextComponent("Empty Tag: " + TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_199800_a).toString())));
            }
            return list;
        }

        @Override
        public JsonObject func_200303_b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_199800_a).toString());
            return jsonobject;
        }
    }

    public static class SingleItemList
    implements IItemList {
        private final ItemStack field_199801_a;

        public SingleItemList(ItemStack stackIn) {
            this.field_199801_a = stackIn;
        }

        @Override
        public Collection<ItemStack> func_199799_a() {
            return Collections.singleton(this.field_199801_a);
        }

        @Override
        public JsonObject func_200303_b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.field_199801_a.func_77973_b()).toString());
            return jsonobject;
        }
    }

    public static interface IItemList {
        public Collection<ItemStack> func_199799_a();

        public JsonObject func_200303_b();
    }
}

