/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.fluid.FluidState;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
extends ReloadListener<ModelBakery>
implements AutoCloseable {
    private Map<ResourceLocation, IBakedModel> field_174958_a = new HashMap<ResourceLocation, IBakedModel>();
    @Nullable
    private SpriteMap field_229352_b_;
    private final BlockModelShapes field_174957_c;
    private final TextureManager field_229353_d_;
    private final BlockColors field_224743_d;
    private int field_229354_f_;
    private IBakedModel field_174955_d;
    private Object2IntMap<BlockState> field_224744_f;

    public ModelManager(TextureManager textureManagerIn, BlockColors blockColorsIn, int maxMipmapLevelIn) {
        this.field_229353_d_ = textureManagerIn;
        this.field_224743_d = blockColorsIn;
        this.field_229354_f_ = maxMipmapLevelIn;
        this.field_174957_c = new BlockModelShapes(this);
    }

    public IBakedModel getModel(ResourceLocation modelLocation) {
        return this.field_174958_a.getOrDefault(modelLocation, this.field_174955_d);
    }

    public IBakedModel func_174953_a(ModelResourceLocation modelLocation) {
        return this.field_174958_a.getOrDefault((Object)modelLocation, this.field_174955_d);
    }

    public IBakedModel func_174951_a() {
        return this.field_174955_d;
    }

    public BlockModelShapes func_174954_c() {
        return this.field_174957_c;
    }

    protected ModelBakery func_212854_a_(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        profilerIn.func_219894_a();
        ModelLoader modelbakery = new ModelLoader(resourceManagerIn, this.field_224743_d, profilerIn, this.field_229354_f_);
        profilerIn.func_219897_b();
        return modelbakery;
    }

    protected void func_212853_a_(ModelBakery objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        profilerIn.func_219894_a();
        profilerIn.func_76320_a("upload");
        if (this.field_229352_b_ != null) {
            this.field_229352_b_.close();
        }
        this.field_229352_b_ = objectIn.func_229333_a_(this.field_229353_d_, profilerIn);
        this.field_174958_a = objectIn.func_217846_a();
        this.field_224744_f = objectIn.func_225354_b();
        this.field_174955_d = this.field_174958_a.get((Object)ModelBakery.field_177604_a);
        ForgeHooksClient.onModelBake((ModelManager)this, this.field_174958_a, (ModelLoader)((ModelLoader)objectIn));
        profilerIn.func_219895_b("cache");
        this.field_174957_c.func_178124_c();
        profilerIn.func_76319_b();
        profilerIn.func_219897_b();
    }

    public boolean func_224742_a(BlockState oldState, BlockState newState) {
        int j;
        if (oldState == newState) {
            return false;
        }
        int i = this.field_224744_f.getInt((Object)oldState);
        if (i != -1 && i == (j = this.field_224744_f.getInt((Object)newState))) {
            FluidState fluidstate1;
            FluidState fluidstate = oldState.func_204520_s();
            return fluidstate != (fluidstate1 = newState.func_204520_s());
        }
        return true;
    }

    public AtlasTexture func_229356_a_(ResourceLocation locationIn) {
        if (this.field_229352_b_ == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.field_229352_b_.func_229152_a_(locationIn);
    }

    @Override
    public void close() {
        if (this.field_229352_b_ != null) {
            this.field_229352_b_.close();
        }
    }

    public void func_229355_a_(int levelIn) {
        this.field_229354_f_ = levelIn;
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

