/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer {
    private static final RenderType field_230010_a_ = RenderType.func_228658_l_((ResourceLocation)new ResourceLocation("textures/map/map_background.png"));
    private static final RenderType field_230011_b_ = RenderType.func_228658_l_((ResourceLocation)new ResourceLocation("textures/map/map_background_checkerboard.png"));
    private final Minecraft field_78455_a;
    private ItemStack field_187467_d = ItemStack.field_190927_a;
    private ItemStack field_187468_e = ItemStack.field_190927_a;
    private float field_187469_f;
    private float field_187470_g;
    private float field_187471_h;
    private float field_187472_i;
    private final EntityRendererManager field_178111_g;
    private final ItemRenderer field_178112_h;

    public FirstPersonRenderer(Minecraft mcIn) {
        this.field_78455_a = mcIn;
        this.field_178111_g = mcIn.func_175598_ae();
        this.field_178112_h = mcIn.func_175599_af();
    }

    public void func_228397_a_(LivingEntity livingEntityIn, ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        if (!itemStackIn.func_190926_b()) {
            this.field_178112_h.func_229109_a_(livingEntityIn, itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, livingEntityIn.field_70170_p, combinedLightIn, OverlayTexture.field_229196_a_);
        }
    }

    private float func_178100_c(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        return -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
    }

    private void func_228403_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, HandSide side) {
        this.field_78455_a.func_110434_K().func_110577_a(this.field_78455_a.field_71439_g.func_110306_p());
        PlayerRenderer playerrenderer = (PlayerRenderer)this.field_178111_g.func_78713_a(this.field_78455_a.field_71439_g);
        matrixStackIn.func_227860_a_();
        float f = side == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(92.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * -41.0f));
        matrixStackIn.func_227861_a_((double)(f * 0.3f), (double)-1.1f, (double)0.45f);
        if (side == HandSide.RIGHT) {
            playerrenderer.func_229144_a_(matrixStackIn, bufferIn, combinedLightIn, this.field_78455_a.field_71439_g);
        } else {
            playerrenderer.func_229146_b_(matrixStackIn, bufferIn, combinedLightIn, this.field_78455_a.field_71439_g);
        }
        matrixStackIn.func_227865_b_();
    }

    private void func_228402_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, float equippedProgress, HandSide handIn, float swingProgress, ItemStack stack) {
        float f = handIn == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStackIn.func_227861_a_((double)(f * 0.125f), -0.125, 0.0);
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 10.0f));
            this.func_228401_a_(matrixStackIn, bufferIn, combinedLightIn, equippedProgress, swingProgress, handIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_((double)(f * 0.51f), (double)(-0.08f + equippedProgress * -1.2f), -0.75);
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        matrixStackIn.func_227861_a_((double)(f * f3), (double)(f4 - 0.3f * f2), (double)f5);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * -45.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * f2 * -30.0f));
        this.func_228404_a_(matrixStackIn, bufferIn, combinedLightIn, stack);
        matrixStackIn.func_227865_b_();
    }

    private void func_228400_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, float pitch, float equippedProgress, float swingProgress) {
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        matrixStackIn.func_227861_a_(0.0, (double)(-f1 / 2.0f), (double)f2);
        float f3 = this.func_178100_c(pitch);
        matrixStackIn.func_227861_a_(0.0, (double)(0.04f + equippedProgress * -1.2f + f3 * -0.5f), (double)-0.72f);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f3 * -85.0f));
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            this.func_228403_a_(matrixStackIn, bufferIn, combinedLightIn, HandSide.RIGHT);
            this.func_228403_a_(matrixStackIn, bufferIn, combinedLightIn, HandSide.LEFT);
            matrixStackIn.func_227865_b_();
        }
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4 * 20.0f));
        matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
        this.func_228404_a_(matrixStackIn, bufferIn, combinedLightIn, this.field_187467_d);
    }

    private void func_228404_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, ItemStack stack) {
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStackIn.func_227862_a_(0.38f, 0.38f, 0.38f);
        matrixStackIn.func_227861_a_(-0.5, -0.5, 0.0);
        matrixStackIn.func_227862_a_(0.0078125f, 0.0078125f, 0.0078125f);
        MapData mapdata = FilledMapItem.func_195950_a(stack, this.field_78455_a.field_71441_e);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(mapdata == null ? field_230010_a_ : field_230011_b_);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        ivertexbuilder.func_227888_a_(matrix4f, -7.0f, 135.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(combinedLightIn).func_181675_d();
        ivertexbuilder.func_227888_a_(matrix4f, 135.0f, 135.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(combinedLightIn).func_181675_d();
        ivertexbuilder.func_227888_a_(matrix4f, 135.0f, -7.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(combinedLightIn).func_181675_d();
        ivertexbuilder.func_227888_a_(matrix4f, -7.0f, -7.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(combinedLightIn).func_181675_d();
        if (mapdata != null) {
            this.field_78455_a.field_71460_t.func_147701_i().func_228086_a_(matrixStackIn, bufferIn, mapdata, false, combinedLightIn);
        }
    }

    private void func_228401_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, float equippedProgress, float swingProgress, HandSide side) {
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        matrixStackIn.func_227861_a_((double)(f * (f2 + 0.64000005f)), (double)(f3 + -0.6f + equippedProgress * -0.6f), (double)(f4 + -0.71999997f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 45.0f));
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * f6 * 70.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * f5 * -20.0f));
        ClientPlayerEntity abstractclientplayerentity = this.field_78455_a.field_71439_g;
        this.field_78455_a.func_110434_K().func_110577_a(abstractclientplayerentity.func_110306_p());
        matrixStackIn.func_227861_a_((double)(f * -1.0f), (double)3.6f, 3.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 120.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(200.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * -135.0f));
        matrixStackIn.func_227861_a_((double)(f * 5.6f), 0.0, 0.0);
        PlayerRenderer playerrenderer = (PlayerRenderer)this.field_178111_g.func_78713_a(abstractclientplayerentity);
        if (flag) {
            playerrenderer.func_229144_a_(matrixStackIn, bufferIn, combinedLightIn, abstractclientplayerentity);
        } else {
            playerrenderer.func_229146_b_(matrixStackIn, bufferIn, combinedLightIn, abstractclientplayerentity);
        }
    }

    private void func_228398_a_(MatrixStack matrixStackIn, float partialTicks, HandSide handIn, ItemStack stack) {
        float f = (float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f;
        float f1 = f / (float)stack.func_77988_m();
        if (f1 < 0.8f) {
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            matrixStackIn.func_227861_a_(0.0, (double)f2, 0.0);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = handIn == HandSide.RIGHT ? 1 : -1;
        matrixStackIn.func_227861_a_((double)(f3 * 0.6f * (float)i), (double)(f3 * -0.5f), (double)(f3 * 0.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * f3 * 90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f3 * 10.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)i * f3 * 30.0f));
    }

    private void func_228399_a_(MatrixStack matrixStackIn, HandSide handIn, float swingProgress) {
        int i = handIn == HandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * (45.0f + f * -20.0f)));
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)i * f1 * -20.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f1 * -80.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * -45.0f));
    }

    private void func_228406_b_(MatrixStack matrixStackIn, HandSide handIn, float equippedProg) {
        int i = handIn == HandSide.RIGHT ? 1 : -1;
        matrixStackIn.func_227861_a_((double)((float)i * 0.56f), (double)(-0.52f + equippedProg * -0.6f), (double)-0.72f);
    }

    public void func_228396_a_(float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer.Impl bufferIn, ClientPlayerEntity playerEntityIn, int combinedLightIn) {
        float f7;
        float f6;
        float f2;
        float f5;
        float f = playerEntityIn.func_70678_g(partialTicks);
        Hand hand = (Hand)MoreObjects.firstNonNull((Object)playerEntityIn.field_184622_au, (Object)Hand.MAIN_HAND);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)playerEntityIn.field_70127_C, (float)playerEntityIn.field_70125_A);
        boolean flag = true;
        boolean flag1 = true;
        if (playerEntityIn.func_184587_cr()) {
            ItemStack itemstack1;
            Hand hand1;
            ItemStack itemstack = playerEntityIn.func_184607_cu();
            if (itemstack.func_77973_b() instanceof ShootableItem) {
                flag = playerEntityIn.func_184600_cs() == Hand.MAIN_HAND;
                boolean bl = flag1 = !flag;
            }
            if ((hand1 = playerEntityIn.func_184600_cs()) == Hand.MAIN_HAND && (itemstack1 = playerEntityIn.func_184592_cb()).func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)itemstack1)) {
                flag1 = false;
            }
        } else {
            ItemStack itemstack2 = playerEntityIn.func_184614_ca();
            ItemStack itemstack3 = playerEntityIn.func_184592_cb();
            if (itemstack2.func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)itemstack2)) {
                boolean bl = flag1 = !flag;
            }
            if (itemstack3.func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)itemstack3)) {
                flag = !itemstack2.func_190926_b();
                flag1 = !flag;
            }
        }
        float f3 = MathHelper.func_219799_g((float)partialTicks, (float)playerEntityIn.field_71164_i, (float)playerEntityIn.field_71155_g);
        float f4 = MathHelper.func_219799_g((float)partialTicks, (float)playerEntityIn.field_71163_h, (float)playerEntityIn.field_71154_f);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((playerEntityIn.func_195050_f(partialTicks) - f3) * 0.1f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((playerEntityIn.func_195046_g(partialTicks) - f4) * 0.1f));
        if (flag && !ForgeHooksClient.renderSpecificFirstPersonHand((Hand)Hand.MAIN_HAND, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (float)partialTicks, (float)f1, (float)(f5 = hand == Hand.MAIN_HAND ? f : 0.0f), (float)(f2 = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.field_187470_g, (float)this.field_187469_f)), (ItemStack)this.field_187467_d)) {
            this.func_228405_a_(playerEntityIn, partialTicks, f1, Hand.MAIN_HAND, f5, this.field_187467_d, f2, matrixStackIn, (IRenderTypeBuffer)bufferIn, combinedLightIn);
        }
        if (flag1 && !ForgeHooksClient.renderSpecificFirstPersonHand((Hand)Hand.OFF_HAND, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (float)partialTicks, (float)f1, (float)(f6 = hand == Hand.OFF_HAND ? f : 0.0f), (float)(f7 = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.field_187472_i, (float)this.field_187471_h)), (ItemStack)this.field_187468_e)) {
            this.func_228405_a_(playerEntityIn, partialTicks, f1, Hand.OFF_HAND, f6, this.field_187468_e, f7, matrixStackIn, (IRenderTypeBuffer)bufferIn, combinedLightIn);
        }
        bufferIn.func_228461_a_();
    }

    private void func_228405_a_(AbstractClientPlayerEntity player, float partialTicks, float pitch, Hand handIn, float swingProgress, ItemStack stack, float equippedProgress, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        boolean flag = handIn == Hand.MAIN_HAND;
        HandSide handside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        matrixStackIn.func_227860_a_();
        if (stack.func_190926_b()) {
            if (flag && !player.func_82150_aj()) {
                this.func_228401_a_(matrixStackIn, bufferIn, combinedLightIn, equippedProgress, swingProgress, handside);
            }
        } else if (stack.func_77973_b() instanceof FilledMapItem) {
            if (flag && this.field_187468_e.func_190926_b()) {
                this.func_228400_a_(matrixStackIn, bufferIn, combinedLightIn, pitch, equippedProgress, swingProgress);
            } else {
                this.func_228402_a_(matrixStackIn, bufferIn, combinedLightIn, equippedProgress, handside, swingProgress, stack);
            }
        } else if (stack.func_77973_b() instanceof CrossbowItem) {
            int i;
            boolean flag1 = CrossbowItem.func_220012_d((ItemStack)stack);
            boolean flag2 = handside == HandSide.RIGHT;
            int n = i = flag2 ? 1 : -1;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == handIn) {
                this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                matrixStackIn.func_227861_a_((double)((float)i * -0.4785682f), (double)-0.094387f, 0.05731530860066414);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-11.935f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * 65.3f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)i * -9.785f));
                float f9 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                float f13 = f9 / (float)CrossbowItem.func_220026_e((ItemStack)stack);
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f13 > 0.1f) {
                    float f16 = MathHelper.func_76126_a((float)((f9 - 0.1f) * 1.3f));
                    float f3 = f13 - 0.1f;
                    float f4 = f16 * f3;
                    matrixStackIn.func_227861_a_((double)(f4 * 0.0f), (double)(f4 * 0.004f), (double)(f4 * 0.0f));
                }
                matrixStackIn.func_227861_a_((double)(f13 * 0.0f), (double)(f13 * 0.0f), (double)(f13 * 0.04f));
                matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f + f13 * 0.2f);
                matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)i * 45.0f));
            } else {
                float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                matrixStackIn.func_227861_a_((double)((float)i * f), (double)f1, (double)f2);
                this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                this.func_228399_a_(matrixStackIn, handside, swingProgress);
                if (flag1 && swingProgress < 0.001f) {
                    matrixStackIn.func_227861_a_((double)((float)i * -0.641864f), 0.0, 0.0);
                    matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * 10.0f));
                }
            }
            this.func_228397_a_(player, stack, flag2 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag2, matrixStackIn, bufferIn, combinedLightIn);
        } else {
            boolean flag3;
            boolean bl = flag3 = handside == HandSide.RIGHT;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == handIn) {
                int k = flag3 ? 1 : -1;
                switch (stack.func_77975_n()) {
                    case NONE: {
                        this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.func_228398_a_(matrixStackIn, partialTicks, handside, stack);
                        this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                        break;
                    }
                    case BLOCK: {
                        this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                        break;
                    }
                    case BOW: {
                        this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                        matrixStackIn.func_227861_a_((double)((float)k * -0.2785682f), 0.18344387412071228, 0.15731531381607056);
                        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-13.935f));
                        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)k * 35.3f));
                        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)k * -9.785f));
                        float f8 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f12 = f8 / 20.0f;
                        f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                        if (f12 > 1.0f) {
                            f12 = 1.0f;
                        }
                        if (f12 > 0.1f) {
                            float f15 = MathHelper.func_76126_a((float)((f8 - 0.1f) * 1.3f));
                            float f18 = f12 - 0.1f;
                            float f20 = f15 * f18;
                            matrixStackIn.func_227861_a_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                        }
                        matrixStackIn.func_227861_a_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
                        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)k * 45.0f));
                        break;
                    }
                    case SPEAR: {
                        this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                        matrixStackIn.func_227861_a_((double)((float)k * -0.5f), (double)0.7f, (double)0.1f);
                        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-55.0f));
                        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)k * 35.3f));
                        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)k * -9.785f));
                        float f7 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f11 = f7 / 10.0f;
                        if (f11 > 1.0f) {
                            f11 = 1.0f;
                        }
                        if (f11 > 0.1f) {
                            float f14 = MathHelper.func_76126_a((float)((f7 - 0.1f) * 1.3f));
                            float f17 = f11 - 0.1f;
                            float f19 = f14 * f17;
                            matrixStackIn.func_227861_a_((double)(f19 * 0.0f), (double)(f19 * 0.004f), (double)(f19 * 0.0f));
                        }
                        matrixStackIn.func_227861_a_(0.0, 0.0, (double)(f11 * 0.2f));
                        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f + f11 * 0.2f);
                        matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)k * 45.0f));
                    }
                }
            } else if (player.func_204805_cN()) {
                this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                int j = flag3 ? 1 : -1;
                matrixStackIn.func_227861_a_((double)((float)j * -0.4f), (double)0.8f, (double)0.3f);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)j * 65.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)j * -85.0f));
            } else {
                float f5 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f6 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f10 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                int l = flag3 ? 1 : -1;
                matrixStackIn.func_227861_a_((double)((float)l * f5), (double)f6, (double)f10);
                this.func_228406_b_(matrixStackIn, handside, equippedProgress);
                this.func_228399_a_(matrixStackIn, handside, swingProgress);
            }
            this.func_228397_a_(player, stack, flag3 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag3, matrixStackIn, bufferIn, combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    public void func_78441_a() {
        this.field_187470_g = this.field_187469_f;
        this.field_187472_i = this.field_187471_h;
        ClientPlayerEntity clientplayerentity = this.field_78455_a.field_71439_g;
        ItemStack itemstack = clientplayerentity.func_184614_ca();
        ItemStack itemstack1 = clientplayerentity.func_184592_cb();
        if (ItemStack.func_77989_b(this.field_187467_d, itemstack)) {
            this.field_187467_d = itemstack;
        }
        if (ItemStack.func_77989_b(this.field_187468_e, itemstack1)) {
            this.field_187468_e = itemstack1;
        }
        if (clientplayerentity.func_184838_M()) {
            this.field_187469_f = MathHelper.func_76131_a((float)(this.field_187469_f - 0.4f), (float)0.0f, (float)1.0f);
            this.field_187471_h = MathHelper.func_76131_a((float)(this.field_187471_h - 0.4f), (float)0.0f, (float)1.0f);
        } else {
            float f = clientplayerentity.func_184825_o(1.0f);
            boolean requipM = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.field_187467_d, (ItemStack)itemstack, (int)clientplayerentity.field_71071_by.field_70461_c);
            boolean requipO = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.field_187468_e, (ItemStack)itemstack1, (int)-1);
            if (!requipM && this.field_187467_d != itemstack) {
                this.field_187467_d = itemstack;
            }
            if (!requipO && this.field_187468_e != itemstack1) {
                this.field_187468_e = itemstack1;
            }
            this.field_187469_f += MathHelper.func_76131_a((float)((!requipM ? f * f * f : 0.0f) - this.field_187469_f), (float)-0.4f, (float)0.4f);
            this.field_187471_h += MathHelper.func_76131_a((float)((float)(!requipO ? 1 : 0) - this.field_187471_h), (float)-0.4f, (float)0.4f);
        }
        if (this.field_187469_f < 0.1f) {
            this.field_187467_d = itemstack;
        }
        if (this.field_187471_h < 0.1f) {
            this.field_187468_e = itemstack1;
        }
    }

    public void func_187460_a(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.field_187469_f = 0.0f;
        } else {
            this.field_187471_h = 0.0f;
        }
    }
}

