/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network.login;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.login.IClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.server.SCustomPayloadLoginPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.CryptManager;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientLoginNetHandler
implements IClientLoginNetHandler {
    private static final Logger field_147396_a = LogManager.getLogger();
    private final Minecraft field_147394_b;
    @Nullable
    private final Screen field_147395_c;
    private final Consumer<ITextComponent> field_209525_d;
    private final NetworkManager field_147393_d;
    private GameProfile field_175091_e;

    public ClientLoginNetHandler(NetworkManager networkManagerIn, Minecraft mcIn, @Nullable Screen previousScreen, Consumer<ITextComponent> statusMessageConsumerIn) {
        this.field_147393_d = networkManagerIn;
        this.field_147394_b = mcIn;
        this.field_147395_c = previousScreen;
        this.field_209525_d = statusMessageConsumerIn;
    }

    public void func_147389_a(SEncryptionRequestPacket packetIn) {
        SecretKey secretkey = CryptManager.func_75890_a();
        PublicKey publickey = packetIn.func_149608_d();
        String s = new BigInteger(CryptManager.func_75895_a((String)packetIn.func_149609_c(), (PublicKey)publickey, (SecretKey)secretkey)).toString(16);
        CEncryptionResponsePacket cencryptionresponsepacket = new CEncryptionResponsePacket(secretkey, publickey, packetIn.func_149607_e());
        this.field_209525_d.accept((ITextComponent)new TranslationTextComponent("connect.authorizing"));
        HTTPUtil.field_180193_a.submit(() -> {
            ITextComponent itextcomponent = this.func_209522_a(s);
            if (itextcomponent != null) {
                if (this.field_147394_b.func_147104_D() == null || !this.field_147394_b.func_147104_D().func_181041_d()) {
                    this.field_147393_d.func_150718_a(itextcomponent);
                    return;
                }
                field_147396_a.warn(itextcomponent.getString());
            }
            this.field_209525_d.accept((ITextComponent)new TranslationTextComponent("connect.encrypting"));
            this.field_147393_d.func_201058_a((IPacket<?>)cencryptionresponsepacket, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_209523_2_ -> this.field_147393_d.func_150727_a(secretkey)));
        });
    }

    @Nullable
    private ITextComponent func_209522_a(String serverHash) {
        try {
            this.func_147391_c().joinServer(this.field_147394_b.func_110432_I().func_148256_e(), this.field_147394_b.func_110432_I().func_148254_d(), serverHash);
            return null;
        }
        catch (AuthenticationUnavailableException authenticationunavailableexception) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", new Object[]{new TranslationTextComponent("disconnect.loginFailedInfo.serversUnavailable")});
        }
        catch (InvalidCredentialsException invalidcredentialsexception) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", new Object[]{new TranslationTextComponent("disconnect.loginFailedInfo.invalidSession")});
        }
        catch (AuthenticationException authenticationexception) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", authenticationexception.getMessage());
        }
    }

    private MinecraftSessionService func_147391_c() {
        return this.field_147394_b.func_152347_ac();
    }

    public void func_147390_a(SLoginSuccessPacket packetIn) {
        this.field_209525_d.accept((ITextComponent)new TranslationTextComponent("connect.joining"));
        this.field_175091_e = packetIn.func_179730_a();
        this.field_147393_d.func_150723_a(ProtocolType.PLAY);
        NetworkHooks.handleClientLoginSuccess((NetworkManager)this.field_147393_d);
        this.field_147393_d.func_150719_a((INetHandler)new ClientPlayNetHandler(this.field_147394_b, this.field_147395_c, this.field_147393_d, this.field_175091_e));
    }

    public void func_147231_a(ITextComponent reason) {
        if (this.field_147395_c != null && this.field_147395_c instanceof RealmsScreen) {
            this.field_147394_b.func_147108_a((Screen)new DisconnectedRealmsScreen(this.field_147395_c, DialogTexts.field_244280_i, reason));
        } else {
            this.field_147394_b.func_147108_a((Screen)new DisconnectedScreen(this.field_147395_c, DialogTexts.field_244280_i, reason));
        }
    }

    public NetworkManager func_147298_b() {
        return this.field_147393_d;
    }

    public void func_147388_a(SDisconnectLoginPacket packetIn) {
        this.field_147393_d.func_150718_a(packetIn.func_149603_c());
    }

    public void func_180464_a(SEnableCompressionPacket packetIn) {
        if (!this.field_147393_d.func_150731_c()) {
            this.field_147393_d.func_179289_a(packetIn.func_179731_a());
        }
    }

    public void func_209521_a(SCustomPayloadLoginPacket packetIn) {
        if (NetworkHooks.onCustomPayload((ICustomPacket)packetIn, (NetworkManager)this.field_147393_d)) {
            return;
        }
        this.field_209525_d.accept((ITextComponent)new TranslationTextComponent("connect.negotiating"));
        this.field_147393_d.func_179290_a(new CCustomPayloadLoginPacket(packetIn.func_209918_a(), null));
    }
}

