/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class LeavesBlock
extends Block
implements IForgeShearable {
    public static final IntegerProperty field_208494_a = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty field_208495_b = BlockStateProperties.field_208515_s;

    public LeavesBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_208494_a, Integer.valueOf(7)))).func_206870_a((Property)field_208495_b, Boolean.valueOf(false))));
    }

    @Override
    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_208494_a) == 7 && (Boolean)state.func_177229_b((Property)field_208495_b) == false;
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((Property)field_208494_a) == 7) {
            LeavesBlock.func_220075_c(state, worldIn, pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_180501_a(pos, LeavesBlock.func_208493_b(state, worldIn, pos), 3);
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = LeavesBlock.func_208492_w(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((Property)field_208494_a) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static BlockState func_208493_b(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            i = Math.min(i, LeavesBlock.func_208492_w(worldIn.func_180495_p((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)((Object)state.func_206870_a((Property)field_208494_a, Integer.valueOf(i)));
    }

    private static int func_208492_w(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_(neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof LeavesBlock ? (Integer)neighbor.func_177229_b((Property)field_208494_a) : 7;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)((Object)worldIn), blockpos, Direction.UP))) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_208494_a, field_208495_b});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return LeavesBlock.func_208493_b((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_208495_b, Boolean.valueOf(true))), context.func_195991_k(), context.func_195995_a());
    }
}

