/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.sworddisplay;

import com.sofodev.sworddisplay.blocks.SwordCaseBlock;
import com.sofodev.sworddisplay.blocks.SwordDisplayBlock;
import com.sofodev.sworddisplay.blocks.SwordDisplayTile;
import com.sofodev.sworddisplay.blocks.TESRSwordDisplay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sworddisplay")
public class SwordDisplay {
    public static final String MODID = "sworddisplay";
    public static final Logger LOGGER = LogManager.getLogger((String)"sworddisplay");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sworddisplay");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"sworddisplay");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"sworddisplay");
    public static final ItemGroup SD_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), "sworddisplay"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryEvents.SWORD_DISPLAY.get());
        }
    };

    public SwordDisplay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        this.setRenderLayer(RegistryEvents.SWORD_CASE, RegistryEvents.WOODEN_SWORD_CASE, RegistryEvents.DARK_OAK_SWORD_CASE, RegistryEvents.BIRCH_SWORD_CASE, RegistryEvents.ACACIA_SWORD_CASE, RegistryEvents.JUNGLE_SWORD_CASE, RegistryEvents.SPRUCE_SWORD_CASE, RegistryEvents.PRISMARINE_SWORD_CASE, RegistryEvents.IRON_SWORD_CASE, RegistryEvents.GOLDEN_SWORD_CASE, RegistryEvents.DIAMOND_SWORD_CASE, RegistryEvents.EMERALD_SWORD_CASE);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)RegistryEvents.SWORD_DISPLAY_TYPE.get()), TESRSwordDisplay::new);
    }

    @SafeVarargs
    private final void setRenderLayer(RegistryObject<Block> ... blocks) {
        Arrays.stream(blocks).forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228645_f_()));
    }

    @Mod.EventBusSubscriber(modid="sworddisplay", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static List<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
        public static final RegistryObject<Block> SWORD_DISPLAY = RegistryEvents.regWithItem("sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> WOODEN_SWORD_DISPLAY = RegistryEvents.regWithItem("wooden_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> DARK_OAK_SWORD_DISPLAY = RegistryEvents.regWithItem("dark_oak_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> BIRCH_SWORD_DISPLAY = RegistryEvents.regWithItem("birch_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> ACACIA_SWORD_DISPLAY = RegistryEvents.regWithItem("acacia_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> JUNGLE_SWORD_DISPLAY = RegistryEvents.regWithItem("jungle_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> SPRUCE_SWORD_DISPLAY = RegistryEvents.regWithItem("spruce_sword_display", () -> new SwordDisplayBlock(ToolType.AXE));
        public static final RegistryObject<Block> PRISMARINE_SWORD_DISPLAY = RegistryEvents.regWithItem("prismarine_sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> IRON_SWORD_DISPLAY = RegistryEvents.regWithItem("iron_sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> GOLDEN_SWORD_DISPLAY = RegistryEvents.regWithItem("golden_sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> DIAMOND_SWORD_DISPLAY = RegistryEvents.regWithItem("diamond_sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> EMERALD_SWORD_DISPLAY = RegistryEvents.regWithItem("emerald_sword_display", () -> new SwordDisplayBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> SWORD_CASE = RegistryEvents.regWithItem("sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> WOODEN_SWORD_CASE = RegistryEvents.regWithItem("wooden_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> DARK_OAK_SWORD_CASE = RegistryEvents.regWithItem("dark_oak_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> BIRCH_SWORD_CASE = RegistryEvents.regWithItem("birch_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> ACACIA_SWORD_CASE = RegistryEvents.regWithItem("acacia_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> JUNGLE_SWORD_CASE = RegistryEvents.regWithItem("jungle_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> SPRUCE_SWORD_CASE = RegistryEvents.regWithItem("spruce_sword_case", () -> new SwordCaseBlock(ToolType.AXE));
        public static final RegistryObject<Block> PRISMARINE_SWORD_CASE = RegistryEvents.regWithItem("prismarine_sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> IRON_SWORD_CASE = RegistryEvents.regWithItem("iron_sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> GOLDEN_SWORD_CASE = RegistryEvents.regWithItem("golden_sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> DIAMOND_SWORD_CASE = RegistryEvents.regWithItem("diamond_sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<Block> EMERALD_SWORD_CASE = RegistryEvents.regWithItem("emerald_sword_case", () -> new SwordCaseBlock(ToolType.PICKAXE));
        public static final RegistryObject<TileEntityType<SwordDisplayTile>> SWORD_DISPLAY_TYPE = TILE_ENTITIES.register("sword_display", () -> RegistryEvents.build(TileEntityType.Builder.func_223042_a(SwordDisplayTile::new, (Block[])new Block[]{(Block)SWORD_DISPLAY.get(), (Block)WOODEN_SWORD_DISPLAY.get(), (Block)DARK_OAK_SWORD_DISPLAY.get(), (Block)BIRCH_SWORD_DISPLAY.get(), (Block)ACACIA_SWORD_DISPLAY.get(), (Block)JUNGLE_SWORD_DISPLAY.get(), (Block)SPRUCE_SWORD_DISPLAY.get(), (Block)PRISMARINE_SWORD_DISPLAY.get(), (Block)IRON_SWORD_DISPLAY.get(), (Block)GOLDEN_SWORD_DISPLAY.get(), (Block)DIAMOND_SWORD_DISPLAY.get(), (Block)EMERALD_SWORD_DISPLAY.get(), (Block)SWORD_CASE.get(), (Block)WOODEN_SWORD_CASE.get(), (Block)DARK_OAK_SWORD_CASE.get(), (Block)BIRCH_SWORD_CASE.get(), (Block)ACACIA_SWORD_CASE.get(), (Block)JUNGLE_SWORD_CASE.get(), (Block)SPRUCE_SWORD_CASE.get(), (Block)PRISMARINE_SWORD_CASE.get(), (Block)IRON_SWORD_CASE.get(), (Block)GOLDEN_SWORD_CASE.get(), (Block)DIAMOND_SWORD_CASE.get(), (Block)EMERALD_SWORD_CASE.get()})));
        public static final Set<RegistryObject<BlockItem>> ITEM_BLOCKS = RegistryEvents.registerBlockItems();

        public static RegistryObject<Block> register(String name, Supplier<? extends Block> sup) {
            return BLOCKS.register(name, sup);
        }

        public static RegistryObject<Block> regWithItem(String name, Supplier<? extends Block> sup) {
            RegistryObject<Block> block = RegistryEvents.register(name, sup);
            blocks.add(block);
            return block;
        }

        private static <T extends TileEntity> TileEntityType<T> build(TileEntityType.Builder<T> builder) {
            return builder.func_206865_a(null);
        }

        public static Set<RegistryObject<BlockItem>> registerBlockItems() {
            return blocks.stream().map(block -> ITEMS.register(block.getId().func_110623_a(), () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(SD_GROUP)))).collect(Collectors.toSet());
        }
    }
}

