/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class SPacketSyncRender {
    private int entityId;
    private int slotId;
    private String curioId;
    private boolean value;

    public SPacketSyncRender(int entityId, String curioId, int slotId, boolean value) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.curioId = curioId;
        this.value = value;
    }

    public static void encode(SPacketSyncRender msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.slotId);
        buf.writeBoolean(msg.value);
    }

    public static SPacketSyncRender decode(PacketBuffer buf) {
        return new SPacketSyncRender(buf.readInt(), buf.func_150789_c(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncRender msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity).ifPresent(handler -> handler.getStacksHandler(msg.curioId).ifPresent(stacksHandler -> {
                    int index = msg.slotId;
                    NonNullList<Boolean> renderStatuses = stacksHandler.getRenders();
                    if (renderStatuses.size() > index) {
                        renderStatuses.set(index, (Object)msg.value);
                    }
                }));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

