/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CsvRow {
    private final long originalLineNumber;
    private final Map<String, Integer> headerMap;
    private final List<String> fields;

    CsvRow(long originalLineNumber, Map<String, Integer> headerMap, List<String> fields) {
        this.originalLineNumber = originalLineNumber;
        this.headerMap = headerMap;
        this.fields = fields;
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getField(int index) {
        return this.fields.get(index);
    }

    public String getField(String name) {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        Integer col = this.headerMap.get(name);
        if (col != null && col < this.fields.size()) {
            return this.fields.get(col);
        }
        return null;
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Map<String, String> getFieldMap() {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(this.headerMap.size());
        for (Map.Entry<String, Integer> header : this.headerMap.entrySet()) {
            String key = header.getKey();
            Integer col = this.headerMap.get(key);
            String val = col != null && col < this.fields.size() ? this.fields.get(col) : null;
            fieldMap.put(key, val);
        }
        return Collections.unmodifiableMap(fieldMap);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CsvRow{");
        sb.append("originalLineNumber=");
        sb.append(this.originalLineNumber);
        sb.append(", ");
        sb.append("fields=");
        if (this.headerMap != null) {
            sb.append('{');
            Iterator<Map.Entry<String, String>> it = this.getFieldMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append(entry.getKey());
                sb.append('=');
                if (entry.getValue() != null) {
                    sb.append(entry.getValue());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        } else {
            sb.append(this.fields.toString());
        }
        sb.append('}');
        return sb.toString();
    }
}

