/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.server;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.polymorph.client.RecipeSelectionManager;

public class SPacketSendRecipes {
    private final List<String> recipes;

    public SPacketSendRecipes(List<String> recipes) {
        this.recipes = recipes;
    }

    public static void encode(SPacketSendRecipes msg, PacketBuffer buf) {
        for (String id : msg.recipes) {
            buf.func_180714_a(id);
        }
    }

    public static SPacketSendRecipes decode(PacketBuffer buf) {
        ArrayList<String> recipes = new ArrayList<String>();
        while (buf.isReadable()) {
            recipes.add(buf.func_150789_c(Short.MAX_VALUE));
        }
        return new SPacketSendRecipes(recipes);
    }

    public static void handle(SPacketSendRecipes msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
            if (clientPlayerEntity != null) {
                RecipeManager manager = clientPlayerEntity.field_70170_p.func_199532_z();
                ArrayList recipes = new ArrayList();
                msg.recipes.forEach(id -> manager.func_215367_a(new ResourceLocation(id)).ifPresent(recipe -> {
                    if (recipe instanceof ICraftingRecipe) {
                        recipes.add((ICraftingRecipe)recipe);
                    }
                }));
                RecipeSelectionManager.getInstance().ifPresent(selectionManager -> selectionManager.setRecipes(recipes, clientPlayerEntity.field_70170_p, true));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

