/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import top.theillusivec4.polymorph.client.gui.RecipeSelectWidget;

public class RecipeSelectionGui
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    private final Consumer<IRecipe<CraftingInventory>> recipeSelector;
    private final CraftingInventory craftingInventory;
    private List<RecipeSelectWidget> buttons = new ArrayList<RecipeSelectWidget>();
    private RecipeSelectWidget hoveredButton;
    private boolean visible = false;
    private int x;
    private int y;
    private List<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();

    public RecipeSelectionGui(int x, int y, CraftingInventory craftingInventory, Consumer<IRecipe<CraftingInventory>> recipeSelector) {
        this.setPosition(x, y);
        this.recipeSelector = recipeSelector;
        this.craftingInventory = craftingInventory;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        int size = this.recipes.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.buttons.forEach(button -> {
            button.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<RecipeSelectWidget> getButtons() {
        return this.buttons;
    }

    public void setRecipes(List<ICraftingRecipe> recipes) {
        this.recipes = recipes;
        this.buttons.clear();
        recipes.forEach(recipe -> this.buttons.add(new RecipeSelectWidget(this.craftingInventory, (IRecipe<CraftingInventory>)recipe)));
        this.updateButtonPositions();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void renderTooltip(MatrixStack matrixStack, int p_193721_1_, int p_193721_2_) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && this.hoveredButton != null) {
            mc.field_71462_r.func_243308_b(matrixStack, this.hoveredButton.getTooltipText(mc.field_71462_r), p_193721_1_, p_193721_2_);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.isVisible()) {
            this.hoveredButton = null;
            this.buttons.forEach(button -> {
                button.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
                if (button.field_230694_p_ && button.func_230449_g_()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(matrixStack, p_render_1_, p_render_2_);
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isVisible()) {
            for (RecipeSelectWidget button : this.buttons) {
                if (!button.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                this.recipeSelector.accept(button.recipe);
                return true;
            }
        }
        return false;
    }
}

