/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.PolyProvider;
import top.theillusivec4.polymorph.client.RecipeOutputWrapper;
import top.theillusivec4.polymorph.client.gui.RecipeSelectionGui;
import top.theillusivec4.polymorph.client.gui.ToggleRecipeButton;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.network.client.CPacketFetchRecipes;
import top.theillusivec4.polymorph.common.network.client.CPacketSetRecipe;
import top.theillusivec4.polymorph.common.network.client.CPacketTransferRecipe;

public class RecipeSelectionManager {
    private static final ResourceLocation TOGGLE = new ResourceLocation("polymorph", "textures/gui/toggle.png");
    private static final Field RECIPE_BOOK = ObfuscationReflectionHelper.findField(RecipeBookGui.class, (String)"field_193964_s");
    private static RecipeSelectionManager instance;
    private static ItemStack preferredStack;
    private RecipeSelectionGui recipeSelectionGui;
    private ImageButton toggleButton;
    private CraftingInventory craftingInventory;
    private IRecipe<CraftingInventory> lastPlacedRecipe;
    private List<ICraftingRecipe> lastRecipesList;
    private IRecipe<CraftingInventory> lastSelectedRecipe;
    private boolean needsUpdate;
    private boolean canUpdate = true;
    private boolean needsPositionUpdate;
    private ContainerScreen<?> parent;
    private PolyProvider provider;
    private static final int GLFW_LEFT_SHIFT = 340;
    private static final int GLFW_RIGHT_SHIFT = 344;

    public static Optional<RecipeSelectionManager> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static RecipeSelectionManager createInstance(ContainerScreen<?> screen, PolyProvider provider) {
        instance = new RecipeSelectionManager(screen, provider);
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static ItemStack getPreferredStack() {
        return preferredStack;
    }

    public static void setPreferredStack(ItemStack stack) {
        preferredStack = stack.func_77946_l();
    }

    public static void updateManager() {
        RecipeSelectionManager.getInstance().ifPresent(manager -> {
            if (manager.canUpdate) {
                manager.markUpdate();
            }
        });
    }

    public RecipeSelectionManager(ContainerScreen<?> screen, PolyProvider provider) {
        this.parent = screen;
        this.provider = provider;
        int x = screen.field_230708_k_ / 2 + provider.getXOffset();
        int y = screen.field_230709_l_ / 2 + provider.getYOffset();
        this.craftingInventory = provider.getCraftingInventory();
        this.recipeSelectionGui = new RecipeSelectionGui(x - 4, y - 32, Objects.requireNonNull(this.craftingInventory), this::selectRecipe);
        this.toggleButton = new ToggleRecipeButton(x, y, 16, 16, 0, 0, 17, TOGGLE, clickWidget -> this.recipeSelectionGui.setVisible(!this.recipeSelectionGui.isVisible()));
        this.toggleButton.field_230694_p_ = this.recipeSelectionGui.getButtons().size() > 1;
    }

    public Optional<List<ICraftingRecipe>> getLastRecipesList() {
        return Optional.ofNullable(this.lastRecipesList);
    }

    public void setLastRecipesList(List<ICraftingRecipe> recipesList) {
        this.lastRecipesList = recipesList;
    }

    public Optional<IRecipe<CraftingInventory>> getLastPlacedRecipe() {
        return Optional.ofNullable(this.lastPlacedRecipe);
    }

    public void setLastPlacedRecipe(IRecipe<CraftingInventory> recipe) {
        this.lastPlacedRecipe = recipe;
    }

    public Optional<IRecipe<CraftingInventory>> getLastSelectedRecipe() {
        return Optional.ofNullable(this.lastSelectedRecipe);
    }

    public void setLastSelectedRecipe(IRecipe<CraftingInventory> recipe) {
        this.lastSelectedRecipe = recipe;
    }

    public void tick() {
        if (this.needsPositionUpdate) {
            this.needsPositionUpdate = false;
            int x = this.parent.field_230708_k_ / 2 + this.provider.getXOffset();
            int y = this.parent.field_230709_l_ / 2 + this.provider.getYOffset();
            if (this.parent instanceof IRecipeShownListener) {
                IRecipeShownListener recipeShownListener = (IRecipeShownListener)this.parent;
                RecipeBookGui recipeBookGui = recipeShownListener.func_194310_f();
                RecipeBook recipeBook = null;
                try {
                    recipeBook = (RecipeBook)RECIPE_BOOK.get(recipeBookGui);
                }
                catch (IllegalAccessException e) {
                    Polymorph.LOGGER.error("Something went wrong while accessing recipe book!");
                }
                if (recipeBook != null && recipeBookGui.func_191878_b()) {
                    x += 77;
                }
            }
            this.recipeSelectionGui.setPosition(x - 4, y - 32);
            this.toggleButton.func_191746_c(x, y);
        }
        if (this.needsUpdate) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            this.needsUpdate = false;
            if (world != null) {
                this.getLastPlacedRecipe().ifPresent(recipe -> {
                    if (recipe.func_77569_a((IInventory)this.craftingInventory, (World)world)) {
                        List recipes = this.getLastRecipesList().orElse(new ArrayList());
                        this.setRecipes(recipes, (World)world, false);
                    } else {
                        this.fetchRecipes();
                    }
                });
                if (!this.getLastPlacedRecipe().isPresent()) {
                    this.fetchRecipes();
                }
            }
        }
    }

    public void setRecipes(List<ICraftingRecipe> recipes, World world, boolean refresh) {
        if (refresh) {
            HashSet recipeOutputs = new HashSet();
            recipes.removeIf(rec -> !recipeOutputs.add(new RecipeOutputWrapper(rec.func_77572_b((IInventory)this.craftingInventory))));
            if (!recipes.isEmpty()) {
                ICraftingRecipe defaultRecipe = recipes.get(0);
                this.setLastSelectedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                this.setLastPlacedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                this.setLastRecipesList(recipes);
            }
        }
        this.recipeSelectionGui.setRecipes(recipes);
        boolean bl = this.toggleButton.field_230694_p_ = recipes.size() > 1;
        if (!preferredStack.func_190926_b()) {
            for (ICraftingRecipe craftingRecipe : recipes) {
                if (craftingRecipe.func_77572_b((IInventory)this.craftingInventory).func_77973_b() != preferredStack.func_77973_b()) continue;
                this.setLastSelectedRecipe((IRecipe<CraftingInventory>)craftingRecipe);
                break;
            }
            preferredStack = ItemStack.field_190927_a;
        }
        this.getLastSelectedRecipe().ifPresent(recipe -> {
            if (recipe.func_77569_a((IInventory)this.craftingInventory, world)) {
                ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
                this.lockUpdates();
                if (playerEntity != null) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetRecipe(recipe.func_199560_c().toString()));
                }
            }
        });
    }

    private void fetchRecipes() {
        NetworkHandler.INSTANCE.sendToServer((Object)new CPacketFetchRecipes());
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.recipeSelectionGui.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.toggleButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.toggleButton.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.recipeSelectionGui.func_231044_a_(mouseX, mouseY, button)) {
            this.recipeSelectionGui.setVisible(false);
            return true;
        }
        if (this.recipeSelectionGui.isVisible()) {
            if (!this.toggleButton.func_231044_a_(mouseX, mouseY, button)) {
                this.recipeSelectionGui.setVisible(false);
            }
            return true;
        }
        Slot slot = this.provider.getOutputSlot();
        if (this.toggleButton.field_230694_p_ && slot == this.parent.getSlotUnderMouse() && RecipeSelectionManager.isShiftKeyDown()) {
            return this.getLastSelectedRecipe().map(recipe -> {
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketTransferRecipe(recipe.func_199560_c().toString()));
                return true;
            }).orElse(false);
        }
        return false;
    }

    public void selectRecipe(IRecipe<CraftingInventory> recipe) {
        this.setLastSelectedRecipe(recipe);
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity != null) {
            ItemStack stack = recipe.func_77572_b((IInventory)this.craftingInventory);
            this.provider.getOutputSlot().func_75215_d(stack.func_77946_l());
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetRecipe(recipe.func_199560_c().toString()));
        }
    }

    public void markPositionChanged() {
        this.needsPositionUpdate = true;
    }

    public void lockUpdates() {
        this.canUpdate = false;
    }

    public void unlockUpdates() {
        this.canUpdate = true;
    }

    public void markUpdate() {
        this.needsUpdate = true;
    }

    private static boolean isShiftKeyDown() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }

    static {
        preferredStack = ItemStack.field_190927_a;
    }
}

