/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.teleportation;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.PehkuiInterface;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.ducks.IEServerPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEServerPlayerEntity;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.Validate;

public class ServerTeleportationManager {
    private Set<ServerPlayerEntity> teleportingEntities = new HashSet<ServerPlayerEntity>();
    private WeakHashMap<Entity, Long> lastTeleportGameTime = new WeakHashMap();
    public boolean isFiringMyChangeDimensionEvent = false;
    public final WeakHashMap<ServerPlayerEntity, Tuple<RegistryKey<World>, Vector3d>> lastPosition = new WeakHashMap();
    private static final boolean useOldTeleport = false;

    public ServerTeleportationManager() {
        ModMain.postServerTickSignal.connectWithWeakRef(this, ServerTeleportationManager::tick);
        Portal.serverPortalTickSignal.connectWithWeakRef(this, (this_, portal) -> ServerTeleportationManager.getEntitiesToTeleport(portal).forEach(entity -> this.tryToTeleportRegularEntity((Portal)((Object)portal), (Entity)entity)));
    }

    public static boolean shouldEntityTeleport(Portal portal, Entity entity) {
        return entity.field_70170_p == portal.field_70170_p && portal.isTeleportable() && portal.isMovedThroughPortal(entity.func_174824_e(0.0f), entity.func_174824_e(1.0f).func_178787_e(entity.func_213322_ci()));
    }

    public void tryToTeleportRegularEntity(Portal portal, Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            return;
        }
        if (entity instanceof Portal) {
            return;
        }
        if (entity.func_184187_bx() != null || this.doesEntityClutterContainPlayer(entity)) {
            return;
        }
        if (entity.field_70128_L) {
            return;
        }
        if (!entity.func_184222_aU()) {
            return;
        }
        if (this.isJustTeleported(entity, 10L)) {
            return;
        }
        double motion = McHelper.lastTickPosOf(entity).func_72436_e(entity.func_213303_ch());
        if (motion > 20.0) {
            return;
        }
        ModMain.serverTaskList.addTask(() -> {
            this.teleportRegularEntity(entity, portal);
            return true;
        });
    }

    private static Stream<Entity> getEntitiesToTeleport(Portal portal) {
        return portal.field_70170_p.func_175647_a(Entity.class, portal.func_174813_aQ().func_186662_g(2.0), e -> true).stream().filter(e -> !(e instanceof Portal)).filter(entity -> ServerTeleportationManager.shouldEntityTeleport(portal, entity));
    }

    public void onPlayerTeleportedInClient(ServerPlayerEntity player, RegistryKey<World> dimensionBefore, Vector3d oldEyePos, UUID portalId) {
        this.recordLastPosition(player);
        Portal portal = this.findPortal(dimensionBefore, portalId);
        this.lastTeleportGameTime.put((Entity)player, McHelper.getServerGameTime());
        if (this.canPlayerTeleport(player, dimensionBefore, oldEyePos, portal)) {
            if (this.isTeleporting(player)) {
                Helper.log(player.toString() + "is teleporting frequently");
            }
            RegistryKey<World> dimensionTo = portal.dimensionTo;
            Vector3d newEyePos = portal.transformPoint(oldEyePos);
            this.teleportPlayer(player, dimensionTo, newEyePos);
            portal.onEntityTeleportedOnServer((Entity)player);
            PehkuiInterface.onServerEntityTeleported.accept((Entity)player, portal);
        } else {
            Helper.err(String.format("Player cannot teleport through portal %s %s %s %s", new Object[]{player.func_200200_C_().func_150261_e(), player.field_70170_p.func_234923_W_(), player.func_213303_ch(), portal}));
        }
    }

    private Portal findPortal(RegistryKey<World> dimensionBefore, UUID portalId) {
        ServerWorld originalWorld = McHelper.getServer().func_71218_a(dimensionBefore);
        Entity portalEntity = originalWorld.func_217461_a(portalId);
        if (portalEntity == null) {
            portalEntity = GlobalPortalStorage.get((ServerWorld)originalWorld).data.stream().filter(p -> p.func_110124_au().equals(portalId)).findFirst().orElse(null);
        }
        if (portalEntity == null) {
            return null;
        }
        if (portalEntity instanceof Portal) {
            return (Portal)portalEntity;
        }
        return null;
    }

    public void recordLastPosition(ServerPlayerEntity player) {
        this.lastPosition.put(player, (Tuple<RegistryKey<World>, Vector3d>)new Tuple((Object)player.field_70170_p.func_234923_W_(), (Object)player.func_213303_ch()));
    }

    private boolean canPlayerTeleport(ServerPlayerEntity player, RegistryKey<World> dimensionBefore, Vector3d posBefore, Entity portalEntity) {
        if (player.func_184187_bx() != null) {
            return true;
        }
        return ServerTeleportationManager.canPlayerReachPos(player, dimensionBefore, posBefore) && portalEntity instanceof Portal && ((Portal)portalEntity).getDistanceToPlane(posBefore) < 20.0;
    }

    public static boolean canPlayerReachPos(ServerPlayerEntity player, RegistryKey<World> dimension, Vector3d pos) {
        Vector3d playerPos = player.func_213303_ch();
        if (player.field_70170_p.func_234923_W_() == dimension && playerPos.func_72436_e(pos) < 256.0) {
            return true;
        }
        return McHelper.getServerPortalsNearby((Entity)player, 20.0).filter(portal -> portal.dimensionTo == dimension).map(portal -> portal.transformPointRough(playerPos)).anyMatch(mappedPos -> mappedPos.func_72436_e(pos) < 256.0);
    }

    public void teleportPlayer(ServerPlayerEntity player, RegistryKey<World> dimensionTo, Vector3d newEyePos) {
        ServerWorld fromWorld = (ServerWorld)player.field_70170_p;
        ServerWorld toWorld = McHelper.getServer().func_71218_a(dimensionTo);
        if (player.field_70170_p.func_234923_W_() == dimensionTo) {
            McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
            McHelper.updateBoundingBox((Entity)player);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
            ((IEServerPlayNetworkHandler)player.field_71135_a).cancelTeleportRequest();
        }
        McHelper.adjustVehicle((Entity)player);
        player.field_71135_a.func_184342_d();
    }

    public void invokeTpmeCommand(ServerPlayerEntity player, RegistryKey<World> dimensionTo, Vector3d newPos) {
        ServerWorld fromWorld = (ServerWorld)player.field_70170_p;
        ServerWorld toWorld = McHelper.getServer().func_71218_a(dimensionTo);
        if (player.field_70170_p.func_234923_W_() == dimensionTo) {
            player.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newPos);
            this.sendPositionConfirmMessage(player);
        }
        player.field_71135_a.func_147364_a(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c, player.field_70177_z, player.field_70125_A);
        player.field_71135_a.func_184342_d();
        ((IEServerPlayNetworkHandler)player.field_71135_a).cancelTeleportRequest();
    }

    private void changePlayerDimension(ServerPlayerEntity player, ServerWorld fromWorld, ServerWorld toWorld, Vector3d newEyePos) {
        NewChunkTrackingGraph.addAdditionalDirectTickets(player);
        this.teleportingEntities.add(player);
        Entity vehicle = player.func_184187_bx();
        if (vehicle != null) {
            ((IEServerPlayerEntity)player).stopRidingWithoutTeleportRequest();
        }
        Vector3d oldPos = player.func_213303_ch();
        O_O.segregateServerPlayer(fromWorld, player);
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        player.field_70170_p = toWorld;
        toWorld.func_217447_b(player);
        toWorld.func_217464_b((Entity)player);
        player.field_71134_c.func_73080_a(toWorld);
        if (vehicle != null) {
            Vector3d vehiclePos = new Vector3d(newEyePos.field_72450_a, McHelper.getVehicleY(vehicle, (Entity)player), newEyePos.field_72449_c);
            this.changeEntityDimension(vehicle, (RegistryKey<World>)toWorld.func_234923_W_(), vehiclePos.func_72441_c(0.0, (double)vehicle.func_70047_e(), 0.0), false);
            ((IEServerPlayerEntity)player).startRidingWithoutTeleportRequest(vehicle);
            McHelper.adjustVehicle((Entity)player);
        }
        Helper.log(String.format("%s :: (%s %s %s %s)->(%s %s %s %s)", player.func_200200_C_().func_150261_e(), fromWorld.func_234923_W_().func_240901_a_(), oldPos.func_82615_a(), oldPos.func_82617_b(), oldPos.func_82616_c(), toWorld.func_234923_W_().func_240901_a_(), (int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_()));
        O_O.onPlayerTravelOnServer(player, (RegistryKey<World>)fromWorld.func_234923_W_(), (RegistryKey<World>)toWorld.func_234923_W_());
        if (toWorld.func_234923_W_() == World.field_234919_h_) {
            ((IEServerPlayerEntity)player).setEnteredNetherPos(player.func_213303_ch());
        }
        ((IEServerPlayerEntity)player).updateDimensionTravelAdvancements(fromWorld);
        GlobalPortalStorage.onPlayerLoggedIn(player);
    }

    private void sendPositionConfirmMessage(ServerPlayerEntity player) {
        IPacket packet = MyNetwork.createStcDimensionConfirm((RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_213303_ch());
        player.field_71135_a.func_147359_a(packet);
    }

    private void tick() {
        this.teleportingEntities = new HashSet<ServerPlayerEntity>();
        long tickTimeNow = McHelper.getServerGameTime();
        ArrayList<ServerPlayerEntity> copiedPlayerList = McHelper.getCopiedPlayerList();
        if (tickTimeNow % 30L == 7L) {
            for (ServerPlayerEntity player2 : copiedPlayerList) {
                this.updateForPlayer(tickTimeNow, player2);
            }
        }
        copiedPlayerList.forEach(player -> McHelper.getServerEntitiesNearbyWithoutLoadingChunk(player.field_70170_p, player.func_213303_ch(), Entity.class, 32.0).filter(entity -> !(entity instanceof ServerPlayerEntity)).forEach(entity -> McHelper.getGlobalPortals(entity.field_70170_p).stream().filter(globalPortal -> ServerTeleportationManager.shouldEntityTeleport(globalPortal, entity)).findFirst().ifPresent(globalPortal -> this.tryToTeleportRegularEntity((Portal)((Object)((Object)((Object)globalPortal))), (Entity)entity))));
    }

    private void updateForPlayer(long tickTimeNow, ServerPlayerEntity player) {
        if (player.field_71136_j || player.field_98038_p) {
            this.lastTeleportGameTime.put((Entity)player, tickTimeNow);
            return;
        }
        Long lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(player, 0L);
        if (tickTimeNow - lastTeleportGameTime > 60L) {
            this.sendPositionConfirmMessage(player);
            player.func_184846_L();
        } else {
            ((IEServerPlayNetworkHandler)player.field_71135_a).cancelTeleportRequest();
        }
    }

    public boolean isTeleporting(ServerPlayerEntity entity) {
        return this.teleportingEntities.contains(entity);
    }

    private void teleportRegularEntity(Entity entity, Portal portal) {
        Long lastTeleportGameTime;
        Validate.isTrue((!(entity instanceof ServerPlayerEntity) ? 1 : 0) != 0);
        if (entity.field_70170_p != portal.field_70170_p) {
            Helper.err(String.format("Cannot teleport %s from %s through %s", new Object[]{entity, entity.field_70170_p.func_234923_W_(), portal}));
            return;
        }
        long currGameTime = McHelper.getServerGameTime();
        if (currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) < 3L) {
            return;
        }
        this.lastTeleportGameTime.put(entity, currGameTime);
        if (entity.func_184218_aH() || this.doesEntityClutterContainPlayer(entity)) {
            return;
        }
        Vector3d velocity = entity.func_213322_ci();
        List passengerList = entity.func_184188_bt();
        Vector3d newEyePos = portal.transformPoint(McHelper.getEyePos(entity));
        if (portal.dimensionTo != entity.field_70170_p.func_234923_W_()) {
            Entity newEntity = entity = this.changeEntityDimension(entity, portal.dimensionTo, newEyePos, true);
            passengerList.stream().map(e -> this.changeEntityDimension((Entity)e, portal.dimensionTo, newEyePos, true)).collect(Collectors.toList()).forEach(e -> e.func_184205_a(newEntity, true));
        }
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        ((ServerWorld)entity.field_70170_p).func_217464_b(entity);
        entity.func_213317_d(portal.transformLocalVec(velocity));
        portal.onEntityTeleportedOnServer(entity);
        PehkuiInterface.onServerEntityTeleported.accept(entity, portal);
        this.lastTeleportGameTime.put(entity, currGameTime);
    }

    public Entity changeEntityDimension(Entity entity, RegistryKey<World> toDimension, Vector3d newEyePos, boolean recreateEntity) {
        ServerWorld fromWorld = (ServerWorld)entity.field_70170_p;
        ServerWorld toWorld = McHelper.getServer().func_71218_a(toDimension);
        entity.func_213319_R();
        if (recreateEntity) {
            Entity oldEntity = entity;
            Entity newEntity = entity.func_200600_R().func_200721_a((World)toWorld);
            if (newEntity == null) {
                return oldEntity;
            }
            newEntity.func_180432_n(oldEntity);
            McHelper.setEyePos(newEntity, newEyePos, newEyePos);
            McHelper.updateBoundingBox(newEntity);
            newEntity.func_70034_d(oldEntity.func_70079_am());
            oldEntity.func_70106_y();
            toWorld.func_217460_e(newEntity);
            return newEntity;
        }
        O_O.segregateServerEntity(fromWorld, entity);
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        entity.field_70170_p = toWorld;
        toWorld.func_217460_e(entity);
        return entity;
    }

    private boolean doesEntityClutterContainPlayer(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return true;
        }
        List passengerList = entity.func_184188_bt();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(this::doesEntityClutterContainPlayer);
    }

    public boolean isJustTeleported(Entity entity, long valveTickTime) {
        Long lastTeleportGameTime;
        long currGameTime = McHelper.getServerGameTime();
        return currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) < valveTickTime;
    }

    public void acceptDubiousMovePacket(ServerPlayerEntity player, CPlayerPacket packet, RegistryKey<World> dimension) {
        double z;
        double y;
        if (player.field_70170_p.func_234923_W_() == dimension) {
            return;
        }
        double x = packet.func_186997_a(player.func_226277_ct_());
        Vector3d newPos = new Vector3d(x, y = packet.func_186996_b(player.func_226278_cu_()), z = packet.func_187000_c(player.func_226281_cx_()));
        if (ServerTeleportationManager.canPlayerReachPos(player, dimension, newPos)) {
            this.recordLastPosition(player);
            this.teleportPlayer(player, dimension, newPos);
            Helper.log(String.format("accepted dubious move packet %s %s %s %s %s %s %s", player.field_70170_p.func_234923_W_(), x, y, z, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
        } else {
            Helper.log(String.format("ignored dubious move packet %s %s %s %s %s %s %s", player.field_70170_p.func_234923_W_().func_240901_a_(), x, y, z, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
        }
    }
}

