/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.teleportation;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ducks.IEEntity;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CollisionHelper {
    private static AxisAlignedBB clipBox(AxisAlignedBB box, Vector3d planePos, Vector3d planeNormal) {
        boolean isPushedPosInFrontOfPlane;
        boolean xForward = planeNormal.field_72450_a > 0.0;
        boolean yForward = planeNormal.field_72448_b > 0.0;
        boolean zForward = planeNormal.field_72449_c > 0.0;
        Vector3d pushedPos = new Vector3d(xForward ? box.field_72340_a : box.field_72336_d, yForward ? box.field_72338_b : box.field_72337_e, zForward ? box.field_72339_c : box.field_72334_f);
        Vector3d staticPos = new Vector3d(xForward ? box.field_72336_d : box.field_72340_a, yForward ? box.field_72337_e : box.field_72338_b, zForward ? box.field_72334_f : box.field_72339_c);
        double tOfPushedPos = Helper.getCollidingT(planePos, planeNormal, pushedPos, planeNormal);
        boolean bl = isPushedPosInFrontOfPlane = tOfPushedPos < 0.0;
        if (isPushedPosInFrontOfPlane) {
            return box;
        }
        boolean isStaticPosInFrontOfPlane = Helper.isInFrontOfPlane(staticPos, planePos, planeNormal);
        if (!isStaticPosInFrontOfPlane) {
            return null;
        }
        Vector3d afterBeingPushed = pushedPos.func_178787_e(planeNormal.func_186678_a(tOfPushedPos));
        return new AxisAlignedBB(afterBeingPushed, staticPos);
    }

    public static boolean shouldCollideWithPortal(Entity entity, Portal portal, float tickDelta) {
        return portal.isTeleportable() && portal.isInFrontOfPortal(entity.func_174824_e(tickDelta));
    }

    public static Vector3d handleCollisionHalfwayInPortal(Entity entity, Vector3d attemptedMove, Portal collidingPortal, Function<Vector3d, Vector3d> handleCollisionFunc) {
        AxisAlignedBB originalBoundingBox = entity.func_174813_aQ();
        Vector3d thisSideMove = CollisionHelper.getThisSideMove(entity, attemptedMove, collidingPortal, handleCollisionFunc, originalBoundingBox);
        Vector3d otherSideMove = CollisionHelper.getOtherSideMove(entity, attemptedMove, collidingPortal, handleCollisionFunc, originalBoundingBox);
        if (attemptedMove.field_72448_b < 0.0) {
            if (otherSideMove.field_72448_b > 0.0) {
                return new Vector3d(CollisionHelper.absMin(thisSideMove.field_72450_a, otherSideMove.field_72450_a), otherSideMove.field_72448_b, CollisionHelper.absMin(thisSideMove.field_72449_c, otherSideMove.field_72449_c));
            }
            if (thisSideMove.field_72448_b > 0.0) {
                Vector3d newThisSideMove = handleCollisionFunc.apply(attemptedMove);
                Vector3d newOtherSideMove = CollisionHelper.getOtherSideMove(entity, newThisSideMove, collidingPortal, handleCollisionFunc, originalBoundingBox);
                return newOtherSideMove;
            }
        }
        return new Vector3d(CollisionHelper.absMin(thisSideMove.field_72450_a, otherSideMove.field_72450_a), CollisionHelper.absMin(thisSideMove.field_72448_b, otherSideMove.field_72448_b), CollisionHelper.absMin(thisSideMove.field_72449_c, otherSideMove.field_72449_c));
    }

    private static double absMin(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    private static Vector3d getOtherSideMove(Entity entity, Vector3d attemptedMove, Portal collidingPortal, Function<Vector3d, Vector3d> handleCollisionFunc, AxisAlignedBB originalBoundingBox) {
        if (collidingPortal.rotation != null) {
            return attemptedMove;
        }
        if (collidingPortal.hasScaling()) {
            return attemptedMove;
        }
        AxisAlignedBB boxOtherSide = CollisionHelper.getCollisionBoxOtherSide(collidingPortal, originalBoundingBox, attemptedMove);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        World oldWorld = entity.field_70170_p;
        Vector3d oldPos = entity.func_213303_ch();
        Vector3d oldLastTickPos = McHelper.lastTickPosOf(entity);
        entity.field_70170_p = CollisionHelper.getWorld(entity.field_70170_p.field_72995_K, collidingPortal.dimensionTo);
        entity.func_174826_a(boxOtherSide);
        Vector3d move2 = handleCollisionFunc.apply(attemptedMove);
        entity.field_70170_p = oldWorld;
        McHelper.setPosAndLastTickPos(entity, oldPos, oldLastTickPos);
        entity.func_174826_a(originalBoundingBox);
        return move2;
    }

    private static Vector3d getThisSideMove(Entity entity, Vector3d attemptedMove, Portal collidingPortal, Function<Vector3d, Vector3d> handleCollisionFunc, AxisAlignedBB originalBoundingBox) {
        AxisAlignedBB boxThisSide = CollisionHelper.getCollisionBoxThisSide(collidingPortal, originalBoundingBox, attemptedMove);
        if (boxThisSide == null) {
            return attemptedMove;
        }
        entity.func_174826_a(boxThisSide);
        Vector3d move1 = handleCollisionFunc.apply(attemptedMove);
        entity.func_174826_a(originalBoundingBox);
        return move1;
    }

    private static AxisAlignedBB getCollisionBoxThisSide(Portal portal, AxisAlignedBB originalBox, Vector3d attemptedMove) {
        Vector3d cullingPos = portal.func_213303_ch().func_178788_d(attemptedMove);
        return CollisionHelper.clipBox(originalBox, cullingPos, portal.getNormal());
    }

    private static AxisAlignedBB getCollisionBoxOtherSide(Portal portal, AxisAlignedBB originalBox, Vector3d attemptedMove) {
        Vector3d teleportation = portal.destination.func_178788_d(portal.func_213303_ch());
        return CollisionHelper.clipBox(originalBox.func_191194_a(teleportation), portal.destination.func_178788_d(attemptedMove), portal.getNormal().func_186678_a(-1.0));
    }

    public static World getWorld(boolean isClient, RegistryKey<World> dimension) {
        if (isClient) {
            return CHelper.getClientWorld(dimension);
        }
        return McHelper.getServer().func_71218_a(dimension);
    }

    @Deprecated
    public static Portal getCollidingPortalUnreliable(Entity entity, float tickDelta) {
        AxisAlignedBB box = entity.func_174813_aQ().func_216361_a(entity.func_213322_ci());
        return CollisionHelper.getCollidingPortalRough(entity, box).filter(portal -> CollisionHelper.shouldCollideWithPortal(entity, portal, tickDelta)).min(Comparator.comparingDouble(p -> p.func_226278_cu_())).orElse(null);
    }

    public static Stream<Portal> getCollidingPortalRough(Entity entity, AxisAlignedBB box) {
        World world = entity.field_70170_p;
        List<GlobalTrackedPortal> globalPortals = McHelper.getGlobalPortals(world);
        List<Portal> collidingNormalPortals = McHelper.getEntitiesRegardingLargeEntities(world, box, 10.0, Portal.class, p -> true);
        if (globalPortals.isEmpty()) {
            return collidingNormalPortals.stream();
        }
        return Stream.concat(collidingNormalPortals.stream(), globalPortals.stream().filter(p -> p.func_174813_aQ().func_186662_g(0.5).func_72326_a(box)));
    }

    public static boolean isCollidingWithAnyPortal(Entity entity) {
        return ((IEEntity)entity).getCollidingPortal() != null;
    }

    public static boolean isNearbyPortal(Entity entity) {
        return CollisionHelper.getCollidingPortalRough(entity, entity.func_174813_aQ().func_186662_g(1.0)).findAny().isPresent();
    }

    public static AxisAlignedBB getActiveCollisionBox(Entity entity) {
        Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
        if (collidingPortal != null) {
            AxisAlignedBB thisSideBox = CollisionHelper.getCollisionBoxThisSide(collidingPortal, entity.func_174813_aQ(), Vector3d.field_186680_a);
            if (thisSideBox != null) {
                return thisSideBox;
            }
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return entity.func_174813_aQ();
    }

    private static void updateGlobalPortalCollidingPortalForWorld(World world) {
        world.func_217381_Z().func_76320_a("global_portal_colliding_portal");
        List<GlobalTrackedPortal> globalPortals = McHelper.getGlobalPortals(world);
        Iterable<Entity> worldEntityList = McHelper.getWorldEntityList(world);
        for (GlobalTrackedPortal globalPortal : globalPortals) {
            for (Entity entity : worldEntityList) {
                if (!CollisionHelper.shouldCollideWithPortal(entity, globalPortal, 1.0f)) continue;
                ((IEEntity)entity).notifyCollidingWithPortal(globalPortal);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    public static void init() {
        ModMain.postServerTickSignal.connect(() -> {
            for (ServerWorld world : McHelper.getServer().func_212370_w()) {
                CollisionHelper.updateGlobalPortalCollidingPortalForWorld((World)world);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ModMain.postClientTickSignal.connect(CollisionHelper::updateClientGlobalPortalCollidingPortal);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateClientGlobalPortalCollidingPortal() {
        for (ClientWorld world : CGlobal.clientWorldLoader.clientWorldMap.values()) {
            CollisionHelper.updateGlobalPortalCollidingPortalForWorld((World)world);
        }
    }

    public static void notifyCollidingPortals(Portal portal) {
        if (!portal.isInteractable()) {
            return;
        }
        AxisAlignedBB portalBoundingBox = portal.func_174813_aQ();
        double compensation = 3.0;
        int xMin = (int)Math.floor(portalBoundingBox.field_72340_a - 3.0);
        int yMin = (int)Math.floor(portalBoundingBox.field_72338_b - 3.0);
        int zMin = (int)Math.floor(portalBoundingBox.field_72339_c - 3.0);
        int xMax = (int)Math.ceil(portalBoundingBox.field_72336_d + 3.0);
        int yMax = (int)Math.ceil(portalBoundingBox.field_72337_e + 3.0);
        int zMax = (int)Math.ceil(portalBoundingBox.field_72334_f + 3.0);
        List<Entity> collidingEntities = McHelper.findEntities(Entity.class, McHelper.getChunkAccessor(portal.field_70170_p), xMin >> 4, xMax >> 4, Math.max(0, yMin >> 4), Math.min(15, yMax >> 4), zMin >> 4, zMax >> 4, entity -> {
            if (entity instanceof Portal) {
                return false;
            }
            AxisAlignedBB entityBoxStretched = entity.func_174813_aQ().func_216361_a(entity.func_213322_ci());
            if (!entityBoxStretched.func_72326_a(portalBoundingBox)) {
                return false;
            }
            return CollisionHelper.shouldCollideWithPortal(entity, portal, 1.0f);
        });
        for (Entity entity2 : collidingEntities) {
            ((IEEntity)entity2).notifyCollidingWithPortal(portal);
        }
    }
}

