/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.teleportation;

import com.qouteall.hiding_in_the_bushes.MyNetworkClient;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.PehkuiInterface;
import com.qouteall.immersive_portals.ducks.IEClientPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import com.qouteall.immersive_portals.ducks.IEGameRenderer;
import com.qouteall.immersive_portals.ducks.IEMinecraftClient;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.TransformationManager;
import com.qouteall.immersive_portals.render.context_management.FogRendererContext;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import com.qouteall.immersive_portals.teleportation.CollisionHelper;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientTeleportationManager {
    Minecraft client = Minecraft.func_71410_x();
    public long tickTimeForTeleportation = 0L;
    private long lastTeleportGameTime = 0L;
    private Vector3d moveStartPoint = null;
    private long teleportTickTimeLimit = 0L;
    public static boolean isTeleportingTick = false;
    public static boolean isTeleportingFrame = false;
    private static final int teleportLimit = 2;

    public ClientTeleportationManager() {
        ModMain.postClientTickSignal.connectWithWeakRef(this, ClientTeleportationManager::tick);
    }

    private void tick() {
        ++this.tickTimeForTeleportation;
        this.changePlayerMotionIfCollidingWithPortal();
        isTeleportingTick = false;
    }

    public void acceptSynchronizationDataFromServer(RegistryKey<World> dimension, Vector3d pos, boolean forceAccept) {
        if (!forceAccept) {
            if (this.isTeleportingFrequently()) {
                return;
            }
            if (this.client.field_71439_g.field_70173_aa < 200) {
                return;
            }
        }
        if (this.client.field_71439_g.field_70170_p.func_234923_W_() != dimension) {
            this.forceTeleportPlayer(dimension, pos);
        }
    }

    public void manageTeleportation(float tickDelta) {
        if (Global.disableTeleportation) {
            return;
        }
        isTeleportingFrame = false;
        if (this.client.field_71441_e == null || this.client.field_71439_g == null) {
            this.moveStartPoint = null;
        } else {
            if (this.client.field_71439_g.field_70169_q == 0.0 && this.client.field_71439_g.field_70167_r == 0.0 && this.client.field_71439_g.field_70166_s == 0.0) {
                return;
            }
            if (this.moveStartPoint != null) {
                boolean teleported;
                for (int i = 0; i < 2 && (teleported = this.tryTeleport(tickDelta)); ++i) {
                    if (i == 0) continue;
                    Helper.log("Nested teleport");
                }
            }
            this.moveStartPoint = this.getPlayerHeadPos(tickDelta);
        }
    }

    private boolean tryTeleport(float tickDelta) {
        Vector3d newHeadPos = this.getPlayerHeadPos(tickDelta);
        if (this.moveStartPoint.func_72436_e(newHeadPos) > 400.0) {
            Helper.log("The Player is Moving Too Fast!");
            return false;
        }
        Tuple pair = CHelper.getClientNearbyPortals(32.0).flatMap(portal -> {
            Vector3d collidingPoint;
            if (portal.isTeleportable() && (collidingPoint = portal.rayTrace(this.moveStartPoint, newHeadPos)) != null) {
                return Stream.of(new Tuple((Object)portal, (Object)collidingPoint));
            }
            return Stream.empty();
        }).min(Comparator.comparingDouble(p -> ((Vector3d)p.func_76340_b()).func_72436_e(this.moveStartPoint))).orElse(null);
        if (pair != null) {
            Portal portal2 = (Portal)((Object)pair.func_76341_a());
            Vector3d collidingPos = (Vector3d)pair.func_76340_b();
            this.teleportPlayer(portal2);
            this.moveStartPoint = portal2.transformPoint(collidingPos).func_178787_e(portal2.getContentDirection().func_186678_a(0.001));
            return true;
        }
        return false;
    }

    private Vector3d getPlayerHeadPos(float tickDelta) {
        return this.client.field_71439_g.func_174824_e(tickDelta);
    }

    private void teleportPlayer(Portal portal) {
        if (this.tickTimeForTeleportation <= this.teleportTickTimeLimit) {
            return;
        }
        this.lastTeleportGameTime = this.tickTimeForTeleportation;
        ClientPlayerEntity player = this.client.field_71439_g;
        RegistryKey<World> toDimension = portal.dimensionTo;
        Vector3d oldEyePos = McHelper.getEyePos((Entity)player);
        Vector3d newEyePos = portal.transformPoint(oldEyePos);
        Vector3d newLastTickEyePos = portal.transformPoint(McHelper.getLastTickEyePos((Entity)player));
        ClientWorld fromWorld = this.client.field_71441_e;
        RegistryKey fromDimension = fromWorld.func_234923_W_();
        if (fromDimension != toDimension) {
            ClientWorld toWorld = CGlobal.clientWorldLoader.getWorld(toDimension);
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
        }
        McHelper.setEyePos((Entity)player, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
        PehkuiInterface.onClientPlayerTeleported.accept(portal);
        player.field_71174_a.func_147297_a(MyNetworkClient.createCtsTeleport((RegistryKey<World>)fromDimension, oldEyePos, portal.func_110124_au()));
        ClientTeleportationManager.tickAfterTeleportation(player, newEyePos, newLastTickEyePos);
        this.amendChunkEntityStatus((Entity)player);
        McHelper.adjustVehicle((Entity)player);
        if (portal.teleportChangesScale) {
            player.func_213317_d(portal.transformLocalVecNonScale(player.func_213322_ci()));
        } else {
            player.func_213317_d(portal.transformLocalVec(player.func_213322_ci()));
        }
        TransformationManager.onClientPlayerTeleported(portal);
        if (player.func_184187_bx() != null) {
            this.disableTeleportFor(40);
        }
        RenderStates.updatePreRenderInfo(RenderStates.tickDelta);
        Helper.log(String.format("Client Teleported %s %s", new Object[]{portal, this.tickTimeForTeleportation}));
        isTeleportingTick = true;
        isTeleportingFrame = true;
        if (portal.extension.adjustPositionAfterTeleport) {
            ClientTeleportationManager.adjustPlayerPosition(player);
        }
    }

    public boolean isTeleportingFrequently() {
        return this.tickTimeForTeleportation - this.lastTeleportGameTime <= 20L || this.tickTimeForTeleportation <= this.teleportTickTimeLimit;
    }

    private void forceTeleportPlayer(RegistryKey<World> toDimension, Vector3d destination) {
        Helper.log("force teleported " + toDimension + destination);
        ClientWorld fromWorld = this.client.field_71441_e;
        RegistryKey fromDimension = fromWorld.func_234923_W_();
        ClientPlayerEntity player = this.client.field_71439_g;
        if (fromDimension == toDimension) {
            player.func_70107_b(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
            McHelper.adjustVehicle((Entity)player);
        } else {
            ClientWorld toWorld = CGlobal.clientWorldLoader.getWorld(toDimension);
            this.changePlayerDimension(player, fromWorld, toWorld, destination);
        }
        this.moveStartPoint = null;
        this.disableTeleportFor(20);
        this.amendChunkEntityStatus((Entity)player);
    }

    public void changePlayerDimension(ClientPlayerEntity player, ClientWorld fromWorld, ClientWorld toWorld, Vector3d newEyePos) {
        Entity vehicle = player.func_184187_bx();
        player.func_213319_R();
        RegistryKey toDimension = toWorld.func_234923_W_();
        RegistryKey fromDimension = fromWorld.func_234923_W_();
        ClientPlayNetHandler workingNetHandler = ((IEClientWorld)fromWorld).getNetHandler();
        ClientPlayNetHandler fakedNetHandler = ((IEClientWorld)toWorld).getNetHandler();
        ((IEClientPlayNetworkHandler)workingNetHandler).setWorld(toWorld);
        ((IEClientPlayNetworkHandler)fakedNetHandler).setWorld(fromWorld);
        ((IEClientWorld)fromWorld).setNetHandler(fakedNetHandler);
        ((IEClientWorld)toWorld).setNetHandler(workingNetHandler);
        O_O.segregateClientEntity(fromWorld, (Entity)player);
        player.field_70170_p = toWorld;
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        toWorld.func_217408_a(player.func_145782_y(), (AbstractClientPlayerEntity)player);
        this.client.field_71441_e = toWorld;
        ((IEMinecraftClient)this.client).setWorldRenderer(CGlobal.clientWorldLoader.getWorldRenderer((RegistryKey<World>)toDimension));
        toWorld.func_96443_a(fromWorld.func_96441_U());
        if (this.client.field_71452_i != null) {
            this.client.field_71452_i.func_78870_a(toWorld);
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a((World)toWorld);
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.func_71410_x().field_71460_t;
        gameRenderer.setLightmapTextureManager(CGlobal.clientWorldLoader.getDimensionRenderHelper((RegistryKey<World>)toDimension).lightmapTexture);
        if (vehicle != null) {
            Vector3d vehiclePos = new Vector3d(newEyePos.field_72450_a, McHelper.getVehicleY(vehicle, (Entity)player), newEyePos.field_72449_c);
            ClientTeleportationManager.moveClientEntityAcrossDimension(vehicle, toWorld, vehiclePos);
            player.func_184205_a(vehicle, true);
        }
        Helper.log(String.format("Client Changed Dimension from %s to %s time: %s", fromDimension.func_240901_a_(), toDimension.func_240901_a_(), this.tickTimeForTeleportation));
        OFInterface.onPlayerTraveled.accept((RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension);
        FogRendererContext.onPlayerTeleport((RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension);
        O_O.onPlayerChangeDimensionClient((RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension);
    }

    private void amendChunkEntityStatus(Entity entity) {
        Chunk worldChunk1 = entity.field_70170_p.func_175726_f(new BlockPos(entity.func_213303_ch()));
        Chunk chunk2 = entity.field_70170_p.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj);
        this.removeEntityFromChunk(entity, worldChunk1);
        if (chunk2 instanceof Chunk) {
            this.removeEntityFromChunk(entity, chunk2);
        }
        worldChunk1.func_76612_a(entity);
    }

    private void removeEntityFromChunk(Entity entity, Chunk worldChunk) {
        for (ClassInheritanceMultiMap section : worldChunk.func_177429_s()) {
            section.remove((Object)entity);
        }
    }

    private void changePlayerMotionIfCollidingWithPortal() {
        ClientPlayerEntity player = this.client.field_71439_g;
        List portals = player.field_70170_p.func_175647_a(Portal.class, player.func_174813_aQ().func_186662_g(0.5), e -> !(e instanceof Mirror));
        if (!portals.isEmpty()) {
            Portal portal = (Portal)((Object)portals.get(0));
            if (portal.extension.motionAffinity > 0.0) {
                this.changeMotion((Entity)player, portal);
            } else if (portal.extension.motionAffinity < 0.0 && player.func_213322_ci().func_72433_c() > 0.7) {
                this.changeMotion((Entity)player, portal);
            }
        }
    }

    private void changeMotion(Entity player, Portal portal) {
        Vector3d velocity = player.func_213322_ci();
        player.func_213317_d(velocity.func_186678_a(1.0 + portal.extension.motionAffinity));
    }

    public static void moveClientEntityAcrossDimension(Entity entity, ClientWorld newWorld, Vector3d newPos) {
        ClientWorld oldWorld = (ClientWorld)entity.field_70170_p;
        O_O.segregateClientEntity(oldWorld, entity);
        entity.field_70170_p = newWorld;
        entity.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        newWorld.func_217411_a(entity.func_145782_y(), entity);
    }

    public void disableTeleportFor(int ticks) {
        this.teleportTickTimeLimit = this.tickTimeForTeleportation + (long)ticks;
    }

    private static void tickAfterTeleportation(ClientPlayerEntity player, Vector3d newEyePos, Vector3d newLastTickEyePos) {
        McHelper.findEntitiesByBox(Portal.class, player.field_70170_p, player.func_174813_aQ(), 10.0, portal -> true).forEach(CollisionHelper::notifyCollidingPortals);
        CollisionHelper.updateClientGlobalPortalCollidingPortal();
        player.func_70071_h_();
        McHelper.setEyePos((Entity)player, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox((Entity)player);
    }

    private static void adjustPlayerPosition(ClientPlayerEntity player) {
        AxisAlignedBB boundingBox = player.func_174813_aQ();
        AxisAlignedBB bottomHalfBox = boundingBox.func_191195_a(0.0, boundingBox.func_216360_c() / 2.0, 0.0);
        Stream collisions = player.field_70170_p.func_226666_b_((Entity)player, bottomHalfBox);
        double maxCollisionY = collisions.mapToDouble(s -> s.func_197752_a().field_72337_e).max().orElse(player.func_226278_cu_());
        double delta = maxCollisionY - player.func_226278_cu_();
        if (delta <= 0.0) {
            return;
        }
        int ticks = 5;
        double originalY = player.func_226278_cu_();
        int[] counter = new int[]{0};
        ModMain.clientTaskList.addTask(() -> {
            if (player.field_70128_L) {
                return true;
            }
            if (player.func_226278_cu_() < originalY - 1.0 || player.func_226278_cu_() > maxCollisionY + 1.0) {
                return true;
            }
            if (counter[0] >= 5) {
                return true;
            }
            counter[0] = counter[0] + 1;
            double progress = (double)counter[0] / 5.0;
            progress = TransformationManager.mapProgress(progress);
            double newY = MathHelper.func_219803_d((double)progress, (double)originalY, (double)maxCollisionY);
            player.func_226288_n_(player.func_226277_ct_(), newY, player.func_226281_cx_());
            McHelper.updateBoundingBox((Entity)player);
            return false;
        });
    }
}

