/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render.context_management;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class StaticFieldsSwappingManager<Context> {
    private Consumer<Context> copyFromObject;
    private Consumer<Context> copyToObject;
    private boolean strictCheck;
    private RegistryKey<World> outerDimension;
    private Stack<ContextRecord<Context>> swappedContext = new Stack();
    public final Map<RegistryKey<World>, ContextRecord<Context>> contextMap = new HashMap<RegistryKey<World>, ContextRecord<Context>>();

    public StaticFieldsSwappingManager(Consumer<Context> copyFromObject, Consumer<Context> copyToObject, boolean doStrictCheck) {
        Validate.notNull(copyFromObject);
        this.copyFromObject = copyFromObject;
        this.copyToObject = copyToObject;
        this.strictCheck = doStrictCheck;
    }

    public boolean isSwapped() {
        return !this.swappedContext.empty();
    }

    public void setOuterDimension(RegistryKey<World> dim) {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        this.outerDimension = dim;
    }

    public void resetChecks() {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        this.contextMap.values().forEach(record -> {
            record.isHoldingLatestContext = record.dimension != this.outerDimension;
        });
    }

    public RegistryKey<World> getCurrentDimension() {
        if (this.swappedContext.empty()) {
            Validate.notNull(this.outerDimension);
            return this.outerDimension;
        }
        return this.swappedContext.peek().dimension;
    }

    public void pushSwapping(RegistryKey<World> newDimension) {
        RegistryKey<World> currentDimension = this.getCurrentDimension();
        ContextRecord<Context> oldContext = this.contextMap.get(currentDimension);
        ContextRecord<Context> newContext = this.contextMap.get(newDimension);
        Validate.notNull(oldContext);
        Validate.notNull(newContext);
        this.swappedContext.push(newContext);
        this.transferDataFromStaticFieldsToObject(oldContext);
        this.transferDataFromObjectToStaticFields(newContext);
    }

    public void popSwapping() {
        ContextRecord<Context> outerContext = this.swappedContext.pop();
        ContextRecord<Context> innerContext = this.contextMap.get(this.getCurrentDimension());
        this.transferDataFromStaticFieldsToObject(outerContext);
        this.transferDataFromObjectToStaticFields(innerContext);
    }

    public void swapAndInvoke(RegistryKey<World> newDimension, Runnable func) {
        this.pushSwapping(newDimension);
        func.run();
        this.popSwapping();
    }

    private void transferDataFromObjectToStaticFields(ContextRecord<Context> newContext) {
        if (!this.strictCheck && newContext == null) {
            return;
        }
        if (this.strictCheck) {
            Validate.isTrue((boolean)newContext.isHoldingLatestContext);
        }
        newContext.isHoldingLatestContext = false;
        this.copyFromObject.accept(newContext.context);
    }

    private void transferDataFromStaticFieldsToObject(ContextRecord<Context> oldContext) {
        if (!this.strictCheck && oldContext == null) {
            return;
        }
        if (this.strictCheck) {
            Validate.isTrue((!oldContext.isHoldingLatestContext ? 1 : 0) != 0);
        }
        oldContext.isHoldingLatestContext = true;
        this.copyToObject.accept(oldContext.context);
    }

    public void updateOuterDimensionAndChangeContext(RegistryKey<World> newDimension) {
        Validate.isTrue((!this.isSwapped() ? 1 : 0) != 0);
        Validate.notNull(this.outerDimension);
        RegistryKey<World> oldDimension = this.outerDimension;
        this.transferDataFromStaticFieldsToObject(this.contextMap.get(oldDimension));
        this.transferDataFromObjectToStaticFields(this.contextMap.get(newDimension));
        this.outerDimension = newDimension;
    }

    public static class ContextRecord<Ctx> {
        public RegistryKey<World> dimension;
        public Ctx context;
        public boolean isHoldingLatestContext = false;

        public ContextRecord(RegistryKey<World> dimension, Ctx context, boolean isHoldingLatestContext) {
            this.dimension = dimension;
            this.context = context;
            this.isHoldingLatestContext = isHoldingLatestContext;
        }
    }
}

