/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render.context_management;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ducks.IEGameRenderer;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.FPSMonitor;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.context_management.FogRendererContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class RenderStates {
    public static RegistryKey<World> originalPlayerDimension;
    public static Vector3d originalPlayerPos;
    public static Vector3d originalPlayerLastTickPos;
    public static GameType originalGameMode;
    public static float tickDelta;
    public static Set<RegistryKey<World>> renderedDimensions;
    public static List<List<WeakReference<Portal>>> lastPortalRenderInfos;
    public static List<List<WeakReference<Portal>>> portalRenderInfos;
    public static Vector3d lastCameraPos;
    public static Vector3d cameraPosDelta;
    public static boolean shouldForceDisableCull;
    public static long renderStartNanoTime;
    public static double viewBobFactor;
    public static Matrix4f projectionMatrix;
    public static ActiveRenderInfo originalCamera;
    public static int originalCameraLightPacked;
    public static String debugText;
    public static boolean isLaggy;
    public static boolean isRenderingEntities;
    public static boolean renderedScalingPortal;

    public static void updatePreRenderInfo(float tickDelta_) {
        Entity cameraEntity = MyRenderHelper.client.field_175622_Z;
        if (cameraEntity == null) {
            return;
        }
        originalPlayerDimension = cameraEntity.field_70170_p.func_234923_W_();
        originalPlayerPos = cameraEntity.func_213303_ch();
        originalPlayerLastTickPos = McHelper.lastTickPosOf(cameraEntity);
        NetworkPlayerInfo entry = CHelper.getClientPlayerListEntry();
        originalGameMode = entry != null ? entry.func_178848_b() : GameType.CREATIVE;
        tickDelta = tickDelta_;
        renderedDimensions.clear();
        lastPortalRenderInfos = portalRenderInfos;
        portalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        FogRendererContext.update();
        renderStartNanoTime = System.nanoTime();
        RenderStates.updateViewBobbingFactor(cameraEntity);
        projectionMatrix = null;
        originalCamera = MyRenderHelper.client.field_71460_t.func_215316_n();
        originalCameraLightPacked = MyRenderHelper.client.func_175598_ae().func_229085_a_(MyRenderHelper.client.field_175622_Z, tickDelta);
        RenderStates.updateIsLaggy();
        debugText = "";
    }

    private static void updateIsLaggy() {
        if (!Global.lagAttackProof) {
            isLaggy = false;
            return;
        }
        if (isLaggy) {
            if (FPSMonitor.getMinimumFps() > 15) {
                isLaggy = false;
            }
        } else if (lastPortalRenderInfos.size() > 10 && (FPSMonitor.getAverageFps() < 8 || FPSMonitor.getMinimumFps() < 6)) {
            MyRenderHelper.client.field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("imm_ptl.laggy"), false);
            isLaggy = true;
        }
    }

    private static void updateViewBobbingFactor(Entity cameraEntity) {
        if (renderedScalingPortal) {
            RenderStates.setViewBobFactor(0.0);
            renderedScalingPortal = false;
            return;
        }
        Vector3d cameraPosVec = cameraEntity.func_174824_e(tickDelta);
        double minPortalDistance = CHelper.getClientNearbyPortals(16.0).map(portal -> portal.getDistanceToNearestPointInPortal(cameraPosVec)).min(Double::compareTo).orElse(100.0);
        if (minPortalDistance < 2.0) {
            if (minPortalDistance < 1.0) {
                RenderStates.setViewBobFactor(0.0);
            } else {
                RenderStates.setViewBobFactor(minPortalDistance - 1.0);
            }
        } else {
            RenderStates.setViewBobFactor(1.0);
        }
    }

    private static void setViewBobFactor(double arg) {
        viewBobFactor = arg < viewBobFactor ? arg : MathHelper.func_219803_d((double)0.1, (double)viewBobFactor, (double)arg);
    }

    public static void onTotalRenderEnd() {
        Vector3d currCameraPos;
        Minecraft client = Minecraft.func_71410_x();
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.func_71410_x().field_71460_t;
        gameRenderer.setLightmapTextureManager(CGlobal.clientWorldLoader.getDimensionRenderHelper((RegistryKey<World>)client.field_71441_e.func_234923_W_()).lightmapTexture);
        if (RenderStates.getRenderedPortalNum() != 0) {
            ((IEWorldRenderer)client.field_71438_f).getBuiltChunkStorage().func_178163_a(client.field_175622_Z.func_226277_ct_(), client.field_175622_Z.func_226281_cx_());
        }
        if ((cameraPosDelta = (currCameraPos = client.field_71460_t.func_215316_n().func_216785_c()).func_178788_d(lastCameraPos)).func_189985_c() > 1.0) {
            cameraPosDelta = Vector3d.field_186680_a;
        }
        lastCameraPos = currCameraPos;
    }

    public static int getRenderedPortalNum() {
        return portalRenderInfos.size();
    }

    public static boolean isDimensionRendered(RegistryKey<World> dimensionType) {
        if (dimensionType == originalPlayerDimension) {
            return true;
        }
        return renderedDimensions.contains(dimensionType);
    }

    static {
        tickDelta = 0.0f;
        renderedDimensions = new HashSet<RegistryKey<World>>();
        lastPortalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        portalRenderInfos = new ArrayList<List<WeakReference<Portal>>>();
        lastCameraPos = Vector3d.field_186680_a;
        cameraPosDelta = Vector3d.field_186680_a;
        shouldForceDisableCull = false;
        isLaggy = false;
        isRenderingEntities = false;
        renderedScalingPortal = false;
    }
}

