/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render.context_management;

import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderDimensionRedirect {
    private static Map<String, String> idMap = new HashMap<String, String>();
    private static Map<RegistryKey<World>, RegistryKey<World>> redirectMap = new HashMap<RegistryKey<World>, RegistryKey<World>>();

    public static void updateIdMap(Map<String, String> redirectIdMap) {
        idMap = redirectIdMap;
    }

    private static void updateRedirectMap() {
        redirectMap.clear();
        idMap.forEach((key, value) -> {
            RegistryKey<World> from = DimId.idToKey(new ResourceLocation(key));
            RegistryKey<World> to = DimId.idToKey(new ResourceLocation(value));
            if (from == null) {
                ModMain.clientTaskList.addTask(() -> {
                    CHelper.printChat("Invalid Dimension " + key);
                    return true;
                });
                return;
            }
            if (to == null && !value.equals("vanilla")) {
                ModMain.clientTaskList.addTask(() -> {
                    CHelper.printChat("Invalid Dimension " + value);
                    return true;
                });
                return;
            }
            redirectMap.put(from, to);
        });
    }

    public static boolean isNoShader(RegistryKey<World> dimension) {
        RegistryKey<World> r;
        return redirectMap.containsKey(dimension) && (r = redirectMap.get(dimension)) == null;
    }

    public static RegistryKey<World> getRedirectedDimension(RegistryKey<World> dimension) {
        if (redirectMap.containsKey(dimension)) {
            RegistryKey<World> r = redirectMap.get(dimension);
            if (r == null) {
                return dimension;
            }
            return r;
        }
        return dimension;
    }

    public static boolean hasSkylight(ClientWorld world) {
        RenderDimensionRedirect.updateRedirectMap();
        RegistryKey<World> redirectedDimension = RenderDimensionRedirect.getRedirectedDimension((RegistryKey<World>)world.func_234923_W_());
        if (redirectedDimension == world.func_234923_W_()) {
            return world.func_230315_m_().func_218272_d();
        }
        return redirectedDimension == World.field_234918_g_;
    }
}

