/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render.context_management;

import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PortalRendering {
    private static final Stack<Portal> portalLayers = new Stack();
    private static boolean isRenderingCache = false;
    private static boolean isRenderingOddNumberOfMirrorsCache = false;

    public static void pushPortalLayer(Portal portal) {
        portalLayers.push(portal);
        PortalRendering.updateCache();
    }

    public static void popPortalLayer() {
        portalLayers.pop();
        PortalRendering.updateCache();
    }

    private static void updateCache() {
        isRenderingCache = PortalRendering.getPortalLayer() != 0;
        int number = 0;
        for (Portal portal : portalLayers) {
            if (!(portal instanceof Mirror)) continue;
            ++number;
        }
        isRenderingOddNumberOfMirrorsCache = number % 2 == 1;
    }

    public static int getPortalLayer() {
        return portalLayers.size();
    }

    public static boolean isRendering() {
        return isRenderingCache;
    }

    public static boolean isRenderingOddNumberOfMirrors() {
        return isRenderingOddNumberOfMirrorsCache;
    }

    public static int getMaxPortalLayer() {
        if (RenderStates.isLaggy) {
            return 1;
        }
        return Global.maxPortalLayer;
    }

    public static Portal getRenderingPortal() {
        return portalLayers.peek();
    }

    public static void onBeginPortalWorldRendering() {
        List currRenderInfo = portalLayers.stream().map(WeakReference::new).collect(Collectors.toList());
        RenderStates.portalRenderInfos.add(currRenderInfo);
        if (portalLayers.stream().anyMatch(Portal::hasScaling)) {
            RenderStates.renderedScalingPortal = true;
        }
        CHelper.checkGlError();
    }

    public static void onEndPortalWorldRendering() {
        RenderStates.renderedDimensions.add(PortalRendering.portalLayers.peek().dimensionTo);
    }

    public static Vector3d getRenderingCameraPos() {
        Vector3d pos = RenderStates.originalCamera.func_216785_c();
        for (Portal portal : portalLayers) {
            pos = portal.transformPoint(pos);
        }
        return pos;
    }

    public static double getAllScaling() {
        double scale = 1.0;
        for (Portal portal : portalLayers) {
            scale *= portal.scaling;
        }
        return scale;
    }
}

