/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render.context_management;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ducks.IECamera;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import com.qouteall.immersive_portals.render.context_management.StaticFieldsSwappingManager;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class FogRendererContext {
    public float red;
    public float green;
    public float blue;
    public int waterFogColor = -1;
    public int nextWaterFogColor = -1;
    public long lastWaterFogColorUpdateTime = -1L;
    public static Consumer<FogRendererContext> copyContextFromObject;
    public static Consumer<FogRendererContext> copyContextToObject;
    public static Supplier<Vector3d> getCurrentFogColor;
    public static StaticFieldsSwappingManager<FogRendererContext> swappingManager;

    public static void init() {
        FogRenderer.class.hashCode();
        swappingManager = new StaticFieldsSwappingManager<FogRendererContext>(copyContextFromObject, copyContextToObject, false);
    }

    public static void update() {
        swappingManager.setOuterDimension(RenderStates.originalPlayerDimension);
        swappingManager.resetChecks();
        CGlobal.clientWorldLoader.clientWorldMap.keySet().forEach(dimension -> FogRendererContext.swappingManager.contextMap.computeIfAbsent((RegistryKey<World>)dimension, k -> new StaticFieldsSwappingManager.ContextRecord<FogRendererContext>((RegistryKey<World>)dimension, new FogRendererContext(), dimension != RenderStates.originalPlayerDimension)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector3d getFogColorOf(ClientWorld destWorld, Vector3d pos) {
        Minecraft client = Minecraft.func_71410_x();
        ClientWorld oldWorld = client.field_71441_e;
        RegistryKey newWorldKey = destWorld.func_234923_W_();
        FogRendererContext.swappingManager.contextMap.computeIfAbsent((RegistryKey<World>)newWorldKey, k -> new StaticFieldsSwappingManager.ContextRecord<FogRendererContext>((RegistryKey<World>)k, new FogRendererContext(), true));
        swappingManager.pushSwapping((RegistryKey<World>)newWorldKey);
        client.field_71441_e = destWorld;
        ActiveRenderInfo newCamera = new ActiveRenderInfo();
        ((IECamera)newCamera).portal_setPos(pos);
        ((IECamera)newCamera).portal_setFocusedEntity(client.field_175622_Z);
        try {
            Vector3d result;
            FogRenderer.func_228371_a_((ActiveRenderInfo)newCamera, (float)RenderStates.tickDelta, (ClientWorld)destWorld, (int)client.field_71474_y.field_151451_c, (float)client.field_71460_t.func_205002_d(RenderStates.tickDelta));
            Vector3d vector3d = result = getCurrentFogColor.get();
            return vector3d;
        }
        finally {
            swappingManager.popSwapping();
            client.field_71441_e = oldWorld;
        }
    }

    public static void onPlayerTeleport(RegistryKey<World> from, RegistryKey<World> to) {
        swappingManager.updateOuterDimensionAndChangeContext(to);
    }
}

