/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.portal.GeometryPortalShape;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PixelCuller;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.context_management.DimensionRenderHelper;
import com.qouteall.immersive_portals.render.context_management.FogRendererContext;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;

public class ViewAreaRenderer {
    private static void buildPortalViewAreaTrianglesBuffer(Vector3d fogColor, Portal portal, BufferBuilder bufferbuilder, Vector3d cameraPos, float tickDelta, float layerWidth) {
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        Vector3d posInPlayerCoordinate = portal.func_213303_ch().func_178788_d(cameraPos);
        if (portal instanceof Mirror) {
            double mirrorOffset = OFInterface.isShaders.getAsBoolean() || Global.pureMirror ? 0.01 : -0.01;
            posInPlayerCoordinate = posInPlayerCoordinate.func_178787_e(portal.getNormal().func_186678_a(mirrorOffset));
        }
        Consumer<Vector3d> vertexOutput = p -> ViewAreaRenderer.putIntoVertex(bufferbuilder, p, fogColor);
        ViewAreaRenderer.generateViewAreaTriangles(portal, posInPlayerCoordinate, vertexOutput);
    }

    private static void generateViewAreaTriangles(Portal portal, Vector3d posInPlayerCoordinate, Consumer<Vector3d> vertexOutput) {
        if (portal.specialShape == null) {
            if (portal instanceof GlobalTrackedPortal) {
                ViewAreaRenderer.generateTriangleForGlobalPortal(vertexOutput, portal, posInPlayerCoordinate);
            } else {
                ViewAreaRenderer.generateTriangleForNormalShape(vertexOutput, portal, posInPlayerCoordinate);
            }
        } else {
            ViewAreaRenderer.generateTriangleForSpecialShape(vertexOutput, portal, posInPlayerCoordinate);
        }
    }

    private static void generateTriangleForSpecialShape(Consumer<Vector3d> vertexOutput, Portal portal, Vector3d posInPlayerCoordinate) {
        ViewAreaRenderer.generateTriangleSpecial(vertexOutput, portal, posInPlayerCoordinate, portal.getNormal().func_186678_a(-0.5));
    }

    private static void generateTriangleSpecial(Consumer<Vector3d> vertexOutput, Portal portal, Vector3d posInPlayerCoordinate, Vector3d innerOffset) {
        GeometryPortalShape specialShape = portal.specialShape;
        for (GeometryPortalShape.TriangleInPlane triangle : specialShape.triangles) {
            Vector3d a = posInPlayerCoordinate.func_178787_e(portal.axisW.func_186678_a(triangle.x1)).func_178787_e(portal.axisH.func_186678_a(triangle.y1));
            Vector3d b = posInPlayerCoordinate.func_178787_e(portal.axisW.func_186678_a(triangle.x3)).func_178787_e(portal.axisH.func_186678_a(triangle.y3));
            Vector3d c = posInPlayerCoordinate.func_178787_e(portal.axisW.func_186678_a(triangle.x2)).func_178787_e(portal.axisH.func_186678_a(triangle.y2));
            vertexOutput.accept(a);
            vertexOutput.accept(b);
            vertexOutput.accept(c);
        }
    }

    private static void putIntoLocalVertex(Consumer<Vector3d> vertexOutput, Portal portal, Vector3d offset, Vector3d posInPlayerCoordinate, double localX, double localY) {
        vertexOutput.accept(posInPlayerCoordinate.func_178787_e(portal.axisW.func_186678_a(localX)).func_178787_e(portal.axisH.func_186678_a(localY)).func_178787_e(offset));
    }

    private static void generateTriangleForNormalShape(Consumer<Vector3d> vertexOutput, Portal portal, Vector3d posInPlayerCoordinate) {
        Vector3d v0 = portal.getPointInPlaneLocal(portal.width / 2.0 - 0.0, -portal.height / 2.0 + 0.0);
        Vector3d v1 = portal.getPointInPlaneLocal(-portal.width / 2.0 + 0.0, -portal.height / 2.0 + 0.0);
        Vector3d v2 = portal.getPointInPlaneLocal(portal.width / 2.0 - 0.0, portal.height / 2.0 - 0.0);
        Vector3d v3 = portal.getPointInPlaneLocal(-portal.width / 2.0 + 0.0, portal.height / 2.0 - 0.0);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.func_178787_e(posInPlayerCoordinate), v2.func_178787_e(posInPlayerCoordinate), v3.func_178787_e(posInPlayerCoordinate), v1.func_178787_e(posInPlayerCoordinate));
    }

    private static void generateTriangleForGlobalPortal(Consumer<Vector3d> vertexOutput, Portal portal, Vector3d posInPlayerCoordinate) {
        Vector3d cameraPosLocal = posInPlayerCoordinate.func_186678_a(-1.0);
        double cameraLocalX = cameraPosLocal.func_72430_b(portal.axisW);
        double cameraLocalY = cameraPosLocal.func_72430_b(portal.axisH);
        double r = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 - 16;
        double distance = Math.abs(cameraPosLocal.func_72430_b(portal.getNormal()));
        if (distance > 200.0) {
            r = r * 200.0 / distance;
        }
        Vector3d v0 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, -r + cameraLocalY);
        Vector3d v1 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, -r + cameraLocalY);
        Vector3d v2 = portal.getPointInPlaneLocalClamped(r + cameraLocalX, r + cameraLocalY);
        Vector3d v3 = portal.getPointInPlaneLocalClamped(-r + cameraLocalX, r + cameraLocalY);
        ViewAreaRenderer.putIntoQuad(vertexOutput, v0.func_178787_e(posInPlayerCoordinate), v2.func_178787_e(posInPlayerCoordinate), v3.func_178787_e(posInPlayerCoordinate), v1.func_178787_e(posInPlayerCoordinate));
    }

    private static void putIntoVertex(BufferBuilder bufferBuilder, Vector3d pos, Vector3d fogColor) {
        bufferBuilder.func_225582_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_227885_a_((float)fogColor.field_72450_a, (float)fogColor.field_72448_b, (float)fogColor.field_72449_c, 1.0f).func_181675_d();
    }

    private static void putIntoQuad(Consumer<Vector3d> vertexOutput, Vector3d a, Vector3d b, Vector3d c, Vector3d d) {
        vertexOutput.accept(b);
        vertexOutput.accept(c);
        vertexOutput.accept(d);
        vertexOutput.accept(d);
        vertexOutput.accept(a);
        vertexOutput.accept(b);
    }

    public static void drawPortalViewTriangle(Portal portal, MatrixStack matrixStack, boolean doFrontCulling, boolean doFaceCulling) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("render_view_triangle");
        DimensionRenderHelper helper = CGlobal.clientWorldLoader.getDimensionRenderHelper(portal.dimensionTo);
        Vector3d fogColor = ViewAreaRenderer.getCurrentFogColor(portal);
        if (doFaceCulling) {
            GlStateManager.func_227771_z_();
        } else {
            GlStateManager.func_227605_A_();
        }
        GlStateManager.func_227621_I_();
        PixelCuller.endCulling();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(fogColor, portal, bufferbuilder, PortalRenderer.client.field_71460_t.func_215316_n().func_216785_c(), RenderStates.tickDelta, portal instanceof Mirror ? 0.0f : 0.45f);
        boolean shouldReverseCull = PortalRendering.isRenderingOddNumberOfMirrors();
        if (shouldReverseCull) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
        if (doFrontCulling && PortalRendering.isRendering()) {
            PixelCuller.updateCullingPlaneInner(matrixStack, PortalRendering.getRenderingPortal(), false);
            PixelCuller.loadCullingPlaneClassical(matrixStack);
            PixelCuller.startClassicalCulling();
        }
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("draw");
        CGlobal.shaderManager.unloadShader();
        GL11.glEnable((int)34383);
        CHelper.checkGlError();
        McHelper.runWithTransformation(matrixStack, () -> ((Tessellator)tessellator).func_78381_a());
        GL11.glDisable((int)34383);
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        if (shouldReverseCull) {
            MyRenderHelper.recoverFaceCulling();
        }
        if (doFrontCulling && PortalRendering.isRendering()) {
            PixelCuller.endCulling();
        }
        GlStateManager.func_227619_H_();
        GlStateManager.func_227771_z_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private static Vector3d getCurrentFogColor(Portal portal) {
        if (OFInterface.isShaders.getAsBoolean()) {
            return Vector3d.field_186680_a;
        }
        return FogRendererContext.getFogColorOf((ClientWorld)portal.getDestinationWorld(), portal.transformPoint(McHelper.getCurrentCameraPos()));
    }

    private static boolean shouldRenderAdditionalHood(Portal portal, Vector3d cameraPos, double distanceToPlane) {
        Vector3d cameraRotation = Minecraft.func_71410_x().field_175622_Z.func_70040_Z();
        double cos = cameraRotation.func_72430_b(portal.getNormal());
        double sin = Math.sqrt(1.0 - cos * cos);
        double threshold = sin * 0.2 + 0.05;
        return distanceToPlane < threshold && portal.isPointInPortalProjection(cameraPos);
    }

    private static void renderAdditionalBox(Portal portal, Vector3d cameraPos, Consumer<Vector3d> vertexOutput) {
        Vector3d projected = portal.getPointInPortalProjection(cameraPos).func_178788_d(cameraPos);
        Vector3d normal = portal.getNormal();
        ViewAreaRenderer.renderHood(portal, vertexOutput, projected, normal);
    }

    private static void renderHood(Portal portal, Consumer<Vector3d> vertexOutput, Vector3d projected, Vector3d normal) {
        double boxRadius = 0.1 * Math.sqrt(3.0) * 1.3;
        double boxDepth = 0.13;
        Vector3d dx = portal.axisW.func_186678_a(boxRadius);
        Vector3d dy = portal.axisH.func_186678_a(boxRadius);
        Vector3d a = projected.func_178787_e(dx).func_178787_e(dy);
        Vector3d b = projected.func_178788_d(dx).func_178787_e(dy);
        Vector3d c = projected.func_178788_d(dx).func_178788_d(dy);
        Vector3d d = projected.func_178787_e(dx).func_178788_d(dy);
        Vector3d mid = projected.func_178787_e(normal.func_186678_a(-boxDepth));
        vertexOutput.accept(b);
        vertexOutput.accept(mid);
        vertexOutput.accept(a);
        vertexOutput.accept(c);
        vertexOutput.accept(mid);
        vertexOutput.accept(b);
        vertexOutput.accept(d);
        vertexOutput.accept(mid);
        vertexOutput.accept(c);
        vertexOutput.accept(a);
        vertexOutput.accept(mid);
        vertexOutput.accept(d);
    }

    @Deprecated
    private static void renderAdditionalBoxExperimental(Portal portal, Consumer<Vector3d> vertexOutput, Vector3d projected, Vector3d normal) {
        double boxRadius = 1.5;
        double boxDepth = 0.5;
        Vector3d dx = portal.axisW.func_186678_a(1.5);
        Vector3d dy = portal.axisH.func_186678_a(1.5);
        Vector3d a = projected.func_178787_e(dx).func_178787_e(dy);
        Vector3d b = projected.func_178788_d(dx).func_178787_e(dy);
        Vector3d c = projected.func_178788_d(dx).func_178788_d(dy);
        Vector3d d = projected.func_178787_e(dx).func_178788_d(dy);
        Vector3d dz = normal.func_186678_a(-0.5);
        Vector3d as = a.func_178787_e(dz);
        Vector3d bs = b.func_178787_e(dz);
        Vector3d cs = c.func_178787_e(dz);
        Vector3d ds = d.func_178787_e(dz);
        ViewAreaRenderer.putIntoQuad(vertexOutput, a, b, bs, as);
        ViewAreaRenderer.putIntoQuad(vertexOutput, b, c, cs, bs);
        ViewAreaRenderer.putIntoQuad(vertexOutput, c, d, ds, cs);
        ViewAreaRenderer.putIntoQuad(vertexOutput, d, a, as, ds);
        ViewAreaRenderer.putIntoQuad(vertexOutput, a, b, c, d);
    }
}

